/*
 * Decompiled with CFR 0.152.
 */
package za.co.absa.abris.avro.parsing.utils;

import io.confluent.kafka.schemaregistry.client.SchemaMetadata;
import java.security.InvalidParameterException;
import org.apache.avro.Schema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.Map;
import za.co.absa.abris.avro.read.confluent.SchemaManager$;
import za.co.absa.abris.avro.schemas.SchemaLoader$;

public final class AvroSchemaUtils$ {
    public static AvroSchemaUtils$ MODULE$;
    private final Logger logger;

    static {
        new AvroSchemaUtils$();
    }

    private Logger logger() {
        return this.logger;
    }

    private void configureSchemaManager(Map<String, String> schemaRegistryConf) {
        block0: {
            if (SchemaManager$.MODULE$.isSchemaRegistryConfigured()) break block0;
            SchemaManager$.MODULE$.configureSchemaRegistry(schemaRegistryConf);
        }
    }

    public Schema parse(String schema) {
        return new Schema.Parser().parse(schema);
    }

    public Schema load(String path) {
        return this.parse(this.loadPlain(path));
    }

    public Schema loadForValue(Map<String, String> schemaRegistryConf) {
        return SchemaLoader$.MODULE$.loadFromSchemaRegistryValue(schemaRegistryConf);
    }

    public Schema loadForKey(Map<String, String> schemaRegistryConf) {
        return SchemaLoader$.MODULE$.loadFromSchemaRegistryKey(schemaRegistryConf);
    }

    public SchemaMetadata load(int schemaVersion, Map<String, String> schemaRegistryConf) {
        return SchemaLoader$.MODULE$.loadFromSchemaRegistry(schemaVersion, schemaRegistryConf);
    }

    public Option<Object> registerIfCompatibleKeySchema(String topic, Schema schema, Map<String, String> schemaRegistryConf) {
        return this.registerIfCompatibleSchema(topic, schema, schemaRegistryConf, true);
    }

    public Option<Object> registerIfCompatibleValueSchema(String topic, Schema schema, Map<String, String> schemaRegistryConf) {
        return this.registerIfCompatibleSchema(topic, schema, schemaRegistryConf, false);
    }

    private Option<Object> registerIfCompatibleSchema(String topic, Schema schema, Map<String, String> schemaRegistryConf, boolean isKey) {
        None$ none$;
        this.configureSchemaManager(schemaRegistryConf);
        Option<String> option = SchemaManager$.MODULE$.getSubjectName(topic, isKey, schema, schemaRegistryConf);
        if (option instanceof Some) {
            None$ none$2;
            Some some = (Some)option;
            String subject = (String)some.value();
            if (!SchemaManager$.MODULE$.exists(subject) || SchemaManager$.MODULE$.isCompatible(schema, subject)) {
                this.logger().info(new StringBuilder(76).append("AvroSchemaUtils.registerIfCompatibleSchema: Registering schema for subject: ").append(subject).toString());
                none$2 = SchemaManager$.MODULE$.register(schema, subject);
            } else {
                this.logger().error(new StringBuilder(65).append("Schema incompatible with latest for subject '").append(subject).append("' in Schema Registry").toString());
                none$2 = None$.MODULE$;
            }
            none$ = none$2;
        } else if (None$.MODULE$.equals(option)) {
            none$ = None$.MODULE$;
        } else {
            throw new MatchError(option);
        }
        return none$;
    }

    public String loadPlain(String path) {
        return SchemaLoader$.MODULE$.loadFromFile(path);
    }

    public Option<Object> registerSchema(String schemaAsString, Map<String, String> registryConfig) throws InvalidParameterException {
        return this.registerSchema(this.parse(schemaAsString), registryConfig);
    }

    /*
     * Unable to fully structure code
     */
    public Option<Object> registerSchema(Schema schema, Map<String, String> registryConfig) throws InvalidParameterException {
        block6: {
            block5: {
                topic = (String)registryConfig.apply((Object)SchemaManager$.MODULE$.PARAM_SCHEMA_REGISTRY_TOPIC());
                valueStrategy = registryConfig.get((Object)SchemaManager$.MODULE$.PARAM_VALUE_SCHEMA_NAMING_STRATEGY());
                var8_6 = new Tuple2((Object)valueStrategy, (Object)(keyStrategy = registryConfig.get((Object)SchemaManager$.MODULE$.PARAM_KEY_SCHEMA_NAMING_STRATEGY())));
                if (var8_6 == null) break block5;
                var9_7 = (Option)var8_6._1();
                var10_8 = (Option)var8_6._2();
                if (!(var9_7 instanceof Some) || !None$.MODULE$.equals(var10_8)) break block5;
                var3_9 = this.registerIfCompatibleValueSchema(topic, schema, registryConfig);
                break block6;
            }
            if (var8_6 == null) ** GOTO lbl-1000
            var11_10 = (Option)var8_6._1();
            var12_11 = (Option)var8_6._2();
            if (None$.MODULE$.equals(var11_10) && var12_11 instanceof Some) {
                var3_9 = this.registerIfCompatibleKeySchema(topic, schema, registryConfig);
            } else lbl-1000:
            // 2 sources

            {
                if (var8_6 != null) {
                    var13_12 = (Option)var8_6._1();
                    var14_13 = (Option)var8_6._2();
                    if (var13_12 instanceof Some && var14_13 instanceof Some) {
                        throw new InvalidParameterException("Both key.schema.naming.strategy and value.schema.naming.strategy were defined. Only one of them supposed to be defined!");
                    }
                }
                throw new InvalidParameterException("At least one of key.schema.naming.strategy or value.schema.naming.strategy must be defined to use schema registry!");
            }
        }
        schemaId = var3_9;
        if (schemaId.isEmpty()) {
            throw new InvalidParameterException(new StringBuilder(150).append("Schema could not be registered for topic '").append(topic).append("'. ").append("Make sure that the Schema Registry is available, the parameters are correct and the schemas ar compatible").toString());
        }
        return schemaId;
    }

    private AvroSchemaUtils$() {
        MODULE$ = this;
        this.logger = LoggerFactory.getLogger(this.getClass());
    }
}

