/*
 * Decompiled with CFR 0.152.
 */
package com.ywl5320.libmusic;

import android.text.TextUtils;
import com.ywl5320.bean.TimeBean;
import com.ywl5320.libenum.MuteEnum;
import com.ywl5320.listener.OnCompleteListener;
import com.ywl5320.listener.OnErrorListener;
import com.ywl5320.listener.OnInfoListener;
import com.ywl5320.listener.OnLoadListener;
import com.ywl5320.listener.OnPauseResumeListener;
import com.ywl5320.listener.OnPreparedListener;
import com.ywl5320.listener.OnRecordListener;
import com.ywl5320.listener.OnShowPcmDataListener;
import com.ywl5320.listener.OnVolumeDBListener;
import java.io.File;

public class WlMusic {
    private String source;
    private TimeBean timeBean;
    private int duration = -1;
    private int volume = 100;
    private float playSpeed = 1.0f;
    private float playPitch = 1.0f;
    private MuteEnum mute = MuteEnum.MUTE_CENTER;
    private boolean playNext = false;
    private boolean playCircle = false;
    private boolean isPlaying = false;
    private boolean isSeek = false;
    private boolean seekingShowTime = true;
    private boolean stopStatus = false;
    private boolean preparedTostart = false;
    private boolean isCallBackPcmData = false;
    private boolean isShowPCMDB = false;
    private OnPreparedListener onPreparedListener;
    private OnErrorListener onErrorListener;
    private OnLoadListener onLoadListener;
    private OnInfoListener onInfoListener;
    private OnCompleteListener onCompleteListener;
    private OnPauseResumeListener onPauseResumeListener;
    private OnVolumeDBListener onVolumeDBListener;
    private OnRecordListener onRecordListener;
    private OnShowPcmDataListener onShowPcmDataListener;
    public static WlMusic instance = null;

    private WlMusic() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static synchronized WlMusic getInstance() {
        if (instance != null) return instance;
        Class<WlMusic> clazz = WlMusic.class;
        synchronized (WlMusic.class) {
            if (instance != null) return instance;
            instance = new WlMusic();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void setSource(String source) {
        this.source = source;
    }

    public String getSource() {
        return this.source;
    }

    public void setCallBackPcmData(boolean callBackPcmData) {
        this.isCallBackPcmData = callBackPcmData;
    }

    public void setShowPCMDB(boolean showPCMDB) {
        this.isShowPCMDB = showPCMDB;
    }

    public void setOnPreparedListener(OnPreparedListener onPreparedListener) {
        this.onPreparedListener = onPreparedListener;
    }

    public void setOnErrorListener(OnErrorListener onErrorListener) {
        this.onErrorListener = onErrorListener;
    }

    public void setOnLoadListener(OnLoadListener onLoadListener) {
        this.onLoadListener = onLoadListener;
    }

    public void setOnInfoListener(OnInfoListener onInfoListener) {
        this.onInfoListener = onInfoListener;
    }

    public void setOnCompleteListener(OnCompleteListener onCompleteListener) {
        this.onCompleteListener = onCompleteListener;
    }

    public void setOnPauseResumeListener(OnPauseResumeListener onPauseResumeListener) {
        this.onPauseResumeListener = onPauseResumeListener;
    }

    public void setOnVolumeDBListener(OnVolumeDBListener onVolumeDBListener) {
        this.onVolumeDBListener = onVolumeDBListener;
    }

    public void setOnRecordListener(OnRecordListener onRecordListener) {
        this.onRecordListener = onRecordListener;
    }

    public void setOnShowPcmDataListener(OnShowPcmDataListener onShowPcmDataListener) {
        this.onShowPcmDataListener = onShowPcmDataListener;
    }

    public boolean isPlaying() {
        return this.isPlaying;
    }

    public void prePared() {
        if (TextUtils.isEmpty((CharSequence)this.source)) {
            return;
        }
        if (this.stopStatus) {
            return;
        }
        this.playNext = false;
        this.n_prepared(this.source);
    }

    public void playNext(String source) {
        this.playNext = true;
        this.source = source;
        this.stop();
    }

    public void setPlayCircle(boolean playCircle) {
        this.playCircle = playCircle;
    }

    public boolean isPlayCircle() {
        return this.playCircle;
    }

    public void start() {
        if (this.isPlaying) {
            return;
        }
        if (!this.preparedTostart) {
            if (this.onErrorListener != null) {
                this.onErrorListener.onError(1009, "please call parpared first");
            }
            return;
        }
        if (this.timeBean == null) {
            this.timeBean = new TimeBean();
        }
        this.isPlaying = true;
        this.setVolume(this.volume);
        this.setPlaySpeed(this.playSpeed);
        this.setPlayPitch(this.playPitch);
        this.setMute(this.mute);
        this.n_start();
    }

    public void pause() {
        this.n_pause();
        if (this.onPauseResumeListener != null) {
            this.onPauseResumeListener.onPause(true);
        }
    }

    public void resume() {
        this.n_resume();
        if (this.onPauseResumeListener != null) {
            this.onPauseResumeListener.onPause(false);
        }
    }

    public void stop() {
        if (!this.stopStatus) {
            this.duration = -1;
            this.preparedTostart = false;
            this.stopStatus = true;
            this.timeBean = null;
            this.n_stop();
            this.isPlaying = false;
        }
    }

    public void seek(int secds, boolean seekingfinished, boolean showTime) {
        this.seekingShowTime = showTime;
        if (this.duration <= 0) {
            return;
        }
        if (seekingfinished) {
            this.isSeek = seekingfinished;
            this.n_seek(secds);
        }
    }

    public int getDuration() {
        if (this.duration < 0) {
            this.duration = this.n_getduration();
        }
        return this.duration;
    }

    public void setVolume(int percent) {
        if (percent <= 0) {
            percent = 0;
        } else if (percent >= 100) {
            percent = 100;
        }
        this.volume = percent;
        this.n_volume(this.volume);
    }

    public int getVolume() {
        return this.volume;
    }

    public void setPlaySpeed(float speed) {
        this.playSpeed = speed;
        this.n_playspeed(this.playSpeed);
    }

    public float getPlaySpeed() {
        return this.playSpeed;
    }

    public float getPlayPitch() {
        return this.playPitch;
    }

    public void setPlayPitch(float pitch) {
        this.playPitch = pitch;
        this.n_playpitch(pitch);
    }

    public void setMute(MuteEnum mute) {
        this.mute = mute;
        this.n_mute(mute.getValue());
    }

    public MuteEnum getMute() {
        return this.mute;
    }

    public void startRecordPlaying(String recordSavePath, String recordSaveName) {
        if (TextUtils.isEmpty((CharSequence)recordSavePath) || TextUtils.isEmpty((CharSequence)recordSaveName)) {
            return;
        }
        File file = new File(recordSavePath);
        if (!file.exists()) {
            file.mkdirs();
        }
        if (!file.exists()) {
            if (this.onErrorListener != null) {
                this.onErrorListener.onError(1008, "record path is wrong");
            }
            return;
        }
        this.n_startPlayRecord(recordSavePath + "/" + recordSaveName + ".aac");
    }

    public void stopRecordPlaying() {
        this.n_stopPlayRecord();
    }

    public void pauseRecordPlaying() {
        this.n_pauseRecordPlaying();
    }

    public void resumeRecordPlaying() {
        this.n_resumeRecordPlaying();
    }

    public void playCutAudio(int start_secs, int end_secs) {
        if (this.n_playCutAudio(start_secs, end_secs) == 0) {
            this.start();
        } else {
            this.onCallError(1008, "cut audio not work for this url");
        }
    }

    public void cutAudio(int start_secs, int end_secs, String savepath, String filename) {
        File file = new File(savepath);
        if (!file.exists()) {
            this.onCallError(1011, "the file is not exists");
            return;
        }
        if (this.n_cutAudio(start_secs, end_secs, savepath = savepath + "/" + filename.replace(".aac", "") + ".aac") == 0) {
            this.start();
        } else {
            this.onCallError(1010, "cut audio not work for this url(" + this.source + ")");
        }
    }

    public void cutAudio(int start_secs, int end_secs) {
        if (this.n_cutAudio_noRecord(start_secs, end_secs) == 0) {
            this.start();
        } else {
            this.onCallError(1010, "cut audio not work for this url(" + this.source + ")");
        }
    }

    private void onCallParpared() {
        if (this.onPreparedListener != null && !this.stopStatus) {
            this.preparedTostart = true;
            this.onPreparedListener.onPrepared();
        }
    }

    private void onCallError(int code, String msg) {
        if (this.onErrorListener != null) {
            this.onErrorListener.onError(code, msg);
        }
        new Thread(new Runnable(){

            @Override
            public void run() {
                WlMusic.this.stop();
            }
        }).start();
    }

    private void onCallLoad(boolean load) {
        if (this.onLoadListener != null) {
            this.onLoadListener.onLoad(load);
        }
    }

    private void onCallInfo(int currSec, int totalSec) {
        if (!this.seekingShowTime) {
            return;
        }
        if (this.onInfoListener != null && this.timeBean != null && !this.isSeek) {
            this.timeBean.setCurrSecs(currSec);
            this.timeBean.setTotalSecs(totalSec);
            this.duration = totalSec;
            this.onInfoListener.onInfo(this.timeBean);
        }
    }

    private void onCallComplete() {
        this.duration = this.getDuration();
        this.onCallInfo(this.duration, this.duration);
        if (this.onCompleteListener != null) {
            this.onCompleteListener.onComplete();
        }
        new Thread(new Runnable(){

            @Override
            public void run() {
                WlMusic.this.stop();
            }
        }).start();
    }

    private boolean onCallPlayCircle() {
        return this.playCircle;
    }

    private void onCallVolumeDB(int db) {
        if (this.onVolumeDBListener != null) {
            this.onVolumeDBListener.onVolumeDB(db);
        }
    }

    private void onCallStopComplete() {
        this.stopStatus = false;
        if (this.playNext) {
            this.prePared();
        }
    }

    private void onCallSeekComplete() {
        this.isSeek = false;
    }

    private void onCallRecordTime(int secds) {
        if (this.onRecordListener != null) {
            this.onRecordListener.onRecordTime(secds);
        }
    }

    private void onCallRecordComplete() {
        if (this.onRecordListener != null) {
            this.onRecordListener.onRecordComplete();
        }
    }

    private void onCallRecordPauseResume(boolean pause) {
        if (this.onRecordListener != null) {
            this.onRecordListener.onRecordPauseResume(pause);
        }
    }

    private void onCallPcmInfo(int samplerate, int bit, int channels) {
        if (this.onShowPcmDataListener != null) {
            this.onShowPcmDataListener.onPcmInfo(samplerate, bit, channels);
        }
    }

    private void onCallPcmData(byte[] pcmdata, int datasize, long clock) {
        if (this.onShowPcmDataListener != null) {
            this.onShowPcmDataListener.onPcmData(pcmdata, datasize, clock);
        }
    }

    private native void n_prepared(String var1);

    private native void n_start();

    private native void n_pause();

    private native void n_resume();

    private native void n_stop();

    private native void n_seek(int var1);

    private native void n_volume(int var1);

    private native void n_playspeed(float var1);

    private native void n_playpitch(float var1);

    private native void n_mute(int var1);

    private native void n_startPlayRecord(String var1);

    private native void n_stopPlayRecord();

    private native void n_pauseRecordPlaying();

    private native void n_resumeRecordPlaying();

    private native int n_playCutAudio(int var1, int var2);

    private native int n_cutAudio(int var1, int var2, String var3);

    private native int n_cutAudio_noRecord(int var1, int var2);

    private native int n_getduration();

    static {
        System.loadLibrary("avutil-55");
        System.loadLibrary("swresample-2");
        System.loadLibrary("avcodec-57");
        System.loadLibrary("avformat-57");
        System.loadLibrary("swscale-4");
        System.loadLibrary("avfilter-6");
        System.loadLibrary("avdevice-57");
        System.loadLibrary("ssl");
        System.loadLibrary("crypto");
        System.loadLibrary("wlmusic");
    }
}

