/*
 * Decompiled with CFR 0.152.
 */
package xyz.tynn.astring;

import android.content.Context;
import android.content.res.Resources;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.PluralsRes;
import java.util.Arrays;
import xyz.tynn.astring.AString;

final class QuantityStringResourceDelegate
implements AString {
    private final int resId;
    private final int quantity;
    private final Object[] formatArgs;

    QuantityStringResourceDelegate(@PluralsRes int resId, int quantity, @Nullable Object[] formatArgs) {
        this.resId = resId;
        this.quantity = quantity;
        this.formatArgs = formatArgs == null || formatArgs.length == 0 ? null : formatArgs;
    }

    @Override
    @Nullable
    public CharSequence invoke(@NonNull Context context) {
        Resources resources = context.getResources();
        if (this.formatArgs == null) {
            return resources.getQuantityString(this.resId, this.quantity);
        }
        return resources.getQuantityString(this.resId, this.quantity, this.formatArgs);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QuantityStringResourceDelegate that = (QuantityStringResourceDelegate)o;
        if (this.resId != that.resId || this.quantity != that.quantity) {
            return false;
        }
        return Arrays.equals(this.formatArgs, that.formatArgs);
    }

    public int hashCode() {
        return 961 * this.resId + 31 * this.quantity + Arrays.hashCode(this.formatArgs);
    }

    @NonNull
    public String toString() {
        StringBuilder sb = new StringBuilder("AString(").append("QuantityStringResource(").append(this.resId).append(',').append(this.quantity);
        if (this.formatArgs != null) {
            for (Object o : this.formatArgs) {
                sb.append(',').append(o);
            }
        }
        return sb.append("))").toString();
    }
}

