/*
 * Decompiled with CFR 0.152.
 */
package xyz.tynn.astring;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.StringRes;
import java.util.Arrays;
import xyz.tynn.astring.AString;

final class StringResourceDelegate
implements AString {
    private final int resId;
    private final Object[] formatArgs;

    StringResourceDelegate(@StringRes int resId, @Nullable Object[] formatArgs) {
        this.resId = resId;
        this.formatArgs = formatArgs == null || formatArgs.length == 0 ? null : formatArgs;
    }

    @Override
    @Nullable
    public CharSequence invoke(@NonNull Context context) {
        if (this.formatArgs == null) {
            return context.getString(this.resId);
        }
        return context.getString(this.resId, this.formatArgs);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StringResourceDelegate that = (StringResourceDelegate)o;
        if (this.resId != that.resId) {
            return false;
        }
        return Arrays.equals(this.formatArgs, that.formatArgs);
    }

    public int hashCode() {
        return 31 * this.resId + Arrays.hashCode(this.formatArgs);
    }

    @NonNull
    public String toString() {
        StringBuilder sb = new StringBuilder("AString(").append("StringResource(").append(this.resId);
        if (this.formatArgs != null) {
            for (Object o : this.formatArgs) {
                sb.append(',').append(o);
            }
        }
        return sb.append("))").toString();
    }
}

