/*
 * Decompiled with CFR 0.152.
 */
package xyz.tynn.astring;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.PluralsRes;
import xyz.tynn.astring.AString;

final class QuantityTextResourceDelegate
implements AString {
    private final int resId;
    private final int quantity;

    QuantityTextResourceDelegate(@PluralsRes int resId, int quantity) {
        this.resId = resId;
        this.quantity = quantity;
    }

    @Override
    @Nullable
    public CharSequence invoke(@NonNull Context context) {
        return context.getResources().getQuantityText(this.resId, this.quantity);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QuantityTextResourceDelegate that = (QuantityTextResourceDelegate)o;
        return this.resId == that.resId && this.quantity == that.quantity;
    }

    public int hashCode() {
        return 31 * this.resId + this.quantity;
    }

    @NonNull
    public String toString() {
        return "AString(QuantityTextResource(" + this.resId + ',' + this.quantity + "))";
    }
}

