/*
 * Decompiled with CFR 0.152.
 */
package xyz.truenight.databinding.rxjava;

import androidx.databinding.Observable;
import androidx.databinding.ObservableInt;
import io.reactivex.Observable;
import io.reactivex.disposables.Disposable;
import io.reactivex.subjects.BehaviorSubject;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import xyz.truenight.utils.Optional;
import xyz.truenight.utils.Utils;

public class RxObservableInteger
extends ObservableInt {
    private Set<Observable.OnPropertyChangedCallback> count = new CopyOnWriteArraySet<Observable.OnPropertyChangedCallback>();
    private Disposable subscription;
    private Observable<Optional<Integer>> observable;

    public RxObservableInteger(Observable<Optional<Integer>> observable) {
        this.observable = observable;
    }

    public RxObservableInteger(int value, Observable<Optional<Integer>> observable) {
        super(value);
        this.observable = observable;
    }

    public RxObservableInteger(BehaviorSubject<Optional<Integer>> subject) {
        super(RxObservableInteger.safe((Optional<Integer>)((Optional)subject.getValue())));
        this.observable = subject;
    }

    private static int safe(Optional<Integer> value) {
        return Utils.safe(value == null ? null : (Integer)value.orElse(null));
    }

    @Deprecated
    public void set(int value) {
        super.set(value);
    }

    public void addOnPropertyChangedCallback(Observable.OnPropertyChangedCallback callback) {
        super.addOnPropertyChangedCallback(callback);
        if (this.count.isEmpty()) {
            this.subscription = this.observable.subscribe(value -> super.set(RxObservableInteger.safe((Optional<Integer>)value)));
        }
        this.count.add(callback);
    }

    public void removeOnPropertyChangedCallback(Observable.OnPropertyChangedCallback callback) {
        super.removeOnPropertyChangedCallback(callback);
        this.count.remove(callback);
        if (this.count.isEmpty() && this.subscription != null && !this.subscription.isDisposed()) {
            this.subscription.dispose();
        }
    }
}

