/*
 * Decompiled with CFR 0.152.
 */
package xyz.truenight.databinding.lifecycle;

import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleEventObserver;
import androidx.lifecycle.LifecycleObserver;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.OnLifecycleEvent;
import androidx.lifecycle.ViewModel;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\b\u0010\t\u001a\u00020\nH&J\b\u0010\u000b\u001a\u00020\nH&J\u000e\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000eR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lxyz/truenight/databinding/lifecycle/LifecycleTrackingViewModel;", "Landroidx/lifecycle/ViewModel;", "()V", "mActiveCount", "", "isActiveState", "", "state", "Landroidx/lifecycle/Lifecycle$State;", "onActive", "", "onInactive", "registerLifecycle", "owner", "Landroidx/lifecycle/LifecycleOwner;", "lifecycle_release"})
public abstract class LifecycleTrackingViewModel
extends ViewModel {
    private int mActiveCount;

    public final void registerLifecycle(@NotNull LifecycleOwner owner) {
        Intrinsics.checkParameterIsNotNull((Object)owner, (String)"owner");
        owner.getLifecycle().addObserver((LifecycleObserver)new LifecycleEventObserver(this, owner){
            private boolean mActive;
            final /* synthetic */ LifecycleTrackingViewModel this$0;
            final /* synthetic */ LifecycleOwner $owner;

            public final boolean getMActive() {
                return this.mActive;
            }

            public final void setMActive(boolean bl) {
                this.mActive = bl;
            }

            @OnLifecycleEvent(value=Lifecycle.Event.ON_ANY)
            public void onStateChanged(@NotNull LifecycleOwner source, @NotNull Lifecycle.Event event) {
                Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
                Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
                Lifecycle lifecycle = source.getLifecycle();
                Intrinsics.checkExpressionValueIsNotNull((Object)lifecycle, (String)"source.lifecycle");
                if (lifecycle.getCurrentState() == Lifecycle.State.DESTROYED) {
                    this.$owner.getLifecycle().removeObserver((LifecycleObserver)this);
                    return;
                }
                Lifecycle lifecycle2 = source.getLifecycle();
                Intrinsics.checkExpressionValueIsNotNull((Object)lifecycle2, (String)"source.lifecycle");
                Lifecycle.State state = lifecycle2.getCurrentState();
                Intrinsics.checkExpressionValueIsNotNull((Object)state, (String)"source.lifecycle.currentState");
                this.activeStateChanged(LifecycleTrackingViewModel.access$isActiveState(this.this$0, state));
            }

            private final void activeStateChanged(boolean active) {
                if (active == this.mActive) {
                    return;
                }
                this.mActive = active;
                boolean wasInactive = LifecycleTrackingViewModel.access$getMActiveCount$p(this.this$0) == 0;
                LifecycleTrackingViewModel lifecycleTrackingViewModel = this.this$0;
                LifecycleTrackingViewModel.access$setMActiveCount$p(lifecycleTrackingViewModel, LifecycleTrackingViewModel.access$getMActiveCount$p(lifecycleTrackingViewModel) + (active ? 1 : -1));
                if (wasInactive && active) {
                    this.this$0.onActive();
                }
                if (LifecycleTrackingViewModel.access$getMActiveCount$p(this.this$0) == 0 && !active) {
                    this.this$0.onInactive();
                }
            }
            {
                this.this$0 = $outer;
                this.$owner = $captured_local_variable$1;
            }
        });
    }

    private final boolean isActiveState(Lifecycle.State state) {
        return state.isAtLeast(Lifecycle.State.STARTED);
    }

    public abstract void onActive();

    public abstract void onInactive();

    public static final /* synthetic */ boolean access$isActiveState(LifecycleTrackingViewModel $this, Lifecycle.State state) {
        return $this.isActiveState(state);
    }

    public static final /* synthetic */ int access$getMActiveCount$p(LifecycleTrackingViewModel $this) {
        return $this.mActiveCount;
    }

    public static final /* synthetic */ void access$setMActiveCount$p(LifecycleTrackingViewModel $this, int n) {
        $this.mActiveCount = n;
    }
}

