/*
 * Decompiled with CFR 0.152.
 */
package xyz.truenight.databinding.lifecycle;

import android.content.Context;
import android.content.res.Resources;
import androidx.annotation.LayoutRes;
import androidx.databinding.ViewDataBinding;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

public class BindingUtil {
    public static void throwMissingVariable(ViewDataBinding binding, int bindingVariable, @LayoutRes int layoutRes) {
        String bindingVariableName;
        Context context = binding.getRoot().getContext();
        Resources resources = context.getResources();
        String layoutName = resources.getResourceName(layoutRes);
        try {
            bindingVariableName = BindingUtil.getBindingVariableName(context, bindingVariable);
        }
        catch (Resources.NotFoundException e) {
            bindingVariableName = "" + bindingVariable;
        }
        throw new IllegalStateException("Could not bind variable '" + bindingVariableName + "' in layout '" + layoutName + "'");
    }

    static String getBindingVariableName(Context context, int bindingVariable) throws Resources.NotFoundException {
        try {
            return BindingUtil.getBindingVariableByDataBinderMapper(bindingVariable);
        }
        catch (Exception e1) {
            try {
                return BindingUtil.getBindingVariableByBR(context, bindingVariable);
            }
            catch (Exception e2) {
                throw new Resources.NotFoundException("" + bindingVariable);
            }
        }
    }

    private static String getBindingVariableByDataBinderMapper(int bindingVariable) throws Exception {
        Class<?> dataBinderMapper = Class.forName("android.databinding.DataBinderMapper");
        Method convertIdMethod = dataBinderMapper.getDeclaredMethod("convertBrIdToString", Integer.TYPE);
        convertIdMethod.setAccessible(true);
        Constructor<?> constructor = dataBinderMapper.getDeclaredConstructor(new Class[0]);
        constructor.setAccessible(true);
        Object instance = constructor.newInstance(new Object[0]);
        Object result = convertIdMethod.invoke(instance, bindingVariable);
        return (String)result;
    }

    private static String getBindingVariableByBR(Context context, int bindingVariable) throws Exception {
        Field[] fields;
        String packageName = context.getPackageName();
        Class<?> BRClass = Class.forName(packageName + ".BR");
        for (Field field : fields = BRClass.getFields()) {
            int value = field.getInt(null);
            if (value != bindingVariable) continue;
            return field.getName();
        }
        throw new Exception("not found");
    }
}

