/*
 * Decompiled with CFR 0.152.
 */
package xyz.truenight.databinding.lifecycle;

import android.app.Activity;
import android.content.Context;
import android.content.ContextWrapper;
import android.os.Bundle;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.CallSuper;
import androidx.annotation.LayoutRes;
import androidx.annotation.Nullable;
import androidx.collection.SimpleArrayMap;
import androidx.databinding.DataBindingUtil;
import androidx.databinding.ViewDataBinding;
import androidx.fragment.app.DialogFragment;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentActivity;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.ViewModel;
import androidx.lifecycle.ViewModelProvider;
import androidx.lifecycle.ViewModelProviders;
import java.util.Collection;
import xyz.truenight.databinding.lifecycle.BindingList;
import xyz.truenight.databinding.lifecycle.BindingProvider;
import xyz.truenight.databinding.lifecycle.BindingUtil;
import xyz.truenight.databinding.lifecycle.LifecycleTrackingViewModel;
import xyz.truenight.databinding.lifecycle.ViewModelBinding;
import xyz.truenight.utils.Utils;

public abstract class BindingLifecycleDialogFragment<B extends ViewDataBinding>
extends DialogFragment {
    private static final String TAG = BindingLifecycleDialogFragment.class.getSimpleName();
    private final SimpleArrayMap<String, ViewModel> map = new SimpleArrayMap();
    private B mBinding;
    private boolean mBinded;

    @CallSuper
    @Nullable
    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        if (this.mBinding == null) {
            this.mBinding = DataBindingUtil.inflate((LayoutInflater)inflater, (int)this.getBindingLayoutRes(), (ViewGroup)container, (boolean)false);
        }
        if (!this.mBinded) {
            BindingList bindings;
            BindingProvider viewModelBindings = this.getViewModelBindings();
            BindingList bindingList = bindings = viewModelBindings == null ? null : viewModelBindings.getItems();
            if (Utils.isNotEmpty((Collection)bindings)) {
                for (ViewModelBinding holder : bindings) {
                    ViewModelProvider provider = holder.getFactory() == null ? (holder.getActivity() == null ? ViewModelProviders.of((Fragment)holder.getFragment()) : ViewModelProviders.of((FragmentActivity)holder.getActivity())) : (holder.getActivity() == null ? ViewModelProviders.of((Fragment)holder.getFragment(), (ViewModelProvider.Factory)holder.getFactory()) : ViewModelProviders.of((FragmentActivity)holder.getActivity(), (ViewModelProvider.Factory)holder.getFactory()));
                    ViewModel viewModel = provider.get(holder.getVmClass());
                    this.map.put((Object)holder.getVmClass().getCanonicalName(), (Object)viewModel);
                    this.onPrepareViewModel(holder.getVmClass(), viewModel);
                    if (viewModel instanceof LifecycleTrackingViewModel) {
                        ((LifecycleTrackingViewModel)viewModel).registerLifecycle((LifecycleOwner)this);
                    }
                    if (this.mBinding.setVariable(holder.getVariableId(), (Object)viewModel)) continue;
                    BindingUtil.throwMissingVariable(this.mBinding, holder.getVariableId(), this.getBindingLayoutRes());
                }
            }
        }
        return this.mBinding.getRoot();
    }

    protected void onPrepareViewModel(Class<? extends ViewModel> vmClass, ViewModel viewModel) {
    }

    public void onDestroy() {
        super.onDestroy();
        if (this.mBinding != null) {
            this.mBinding.unbind();
            this.mBinded = false;
        }
    }

    @LayoutRes
    public abstract int getBindingLayoutRes();

    public abstract BindingProvider getViewModelBindings();

    public <VM extends ViewModel> VM getViewModel(Class<VM> viewModelClass) {
        return (VM)((ViewModel)this.map.get((Object)viewModelClass.getCanonicalName()));
    }

    public B binding() {
        return this.mBinding;
    }

    public void show(Context context) {
        try {
            this.show(BindingLifecycleDialogFragment.getFragmentActivity(context).getSupportFragmentManager(), ((Object)((Object)this)).getClass().getCanonicalName());
        }
        catch (Throwable th) {
            Log.e((String)TAG, (String)"", (Throwable)th);
        }
    }

    protected BindingList list(ViewModelBinding ... binding) {
        return new BindingList(binding);
    }

    protected final ViewModelBinding bind(FragmentActivity activity, int variableId, Class<? extends ViewModel> vmClass) {
        return new ViewModelBinding(activity, variableId, vmClass);
    }

    protected final <T extends ViewModel> ViewModelBinding bind(FragmentActivity activity, int variableId, Class<T> vmClass, ViewModelBinding.Factory<T> factory) {
        return new ViewModelBinding(activity, variableId, vmClass, factory);
    }

    protected final ViewModelBinding bind(Fragment fragment, int variableId, Class<? extends ViewModel> vmClass) {
        return new ViewModelBinding(fragment, variableId, vmClass);
    }

    protected final <T extends ViewModel> ViewModelBinding bind(Fragment fragment, int variableId, Class<T> vmClass, ViewModelBinding.Factory<T> factory) {
        return new ViewModelBinding(fragment, variableId, vmClass, factory);
    }

    public static FragmentActivity getFragmentActivity(Context context) {
        return BindingLifecycleDialogFragment.getFragmentActivity(context, false);
    }

    public static FragmentActivity getFragmentActivity(Context context, boolean safe) {
        if (context instanceof FragmentActivity) {
            return (FragmentActivity)context;
        }
        if (context instanceof Activity) {
            throw new IllegalStateException("Context " + context + " NOT support-v4 Activity");
        }
        if (context instanceof ContextWrapper) {
            return BindingLifecycleDialogFragment.getFragmentActivity(((ContextWrapper)context).getBaseContext(), safe);
        }
        if (safe) {
            return null;
        }
        throw new IllegalStateException("Context " + context + " NOT contains activity!");
    }
}

