/*
 * Decompiled with CFR 0.152.
 */
package xyz.truenight.databinding.lifecycle;

import android.arch.lifecycle.LifecycleOwner;
import android.arch.lifecycle.ViewModel;
import android.arch.lifecycle.ViewModelProvider;
import android.arch.lifecycle.ViewModelProviders;
import android.databinding.DataBindingUtil;
import android.databinding.ViewDataBinding;
import android.os.Bundle;
import android.support.annotation.CallSuper;
import android.support.annotation.LayoutRes;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.support.v4.util.SimpleArrayMap;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import java.util.Collection;
import xyz.truenight.databinding.lifecycle.BindingList;
import xyz.truenight.databinding.lifecycle.BindingUtil;
import xyz.truenight.databinding.lifecycle.LifecycleTrackingViewModel;
import xyz.truenight.databinding.lifecycle.ViewModelBinding;
import xyz.truenight.utils.Utils;

public abstract class BindingLifecycleFragment<B extends ViewDataBinding>
extends Fragment {
    private final SimpleArrayMap<String, ViewModel> map = new SimpleArrayMap();
    private B mBinding;

    @CallSuper
    @Nullable
    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        BindingList bindings;
        if (this.mBinding == null) {
            this.mBinding = DataBindingUtil.inflate((LayoutInflater)inflater, (int)this.getBindingLayoutRes(), (ViewGroup)container, (boolean)false);
        }
        if (Utils.isNotEmpty((Collection)(bindings = this.getViewModelBindings()))) {
            for (ViewModelBinding holder : bindings) {
                ViewModelProvider provider = holder.getFactory() == null ? (holder.getActivity() == null ? ViewModelProviders.of((Fragment)holder.getFragment()) : ViewModelProviders.of((FragmentActivity)holder.getActivity())) : (holder.getActivity() == null ? ViewModelProviders.of((Fragment)holder.getFragment(), (ViewModelProvider.Factory)holder.getFactory()) : ViewModelProviders.of((FragmentActivity)holder.getActivity(), (ViewModelProvider.Factory)holder.getFactory()));
                ViewModel viewModel = provider.get(holder.getVmClass());
                this.map.put((Object)holder.getVmClass().getCanonicalName(), (Object)viewModel);
                if (viewModel instanceof LifecycleTrackingViewModel) {
                    ((LifecycleTrackingViewModel)viewModel).registerLifecycle((LifecycleOwner)this);
                }
                if (this.mBinding.setVariable(holder.getVariableId(), (Object)viewModel)) continue;
                BindingUtil.throwMissingVariable(this.mBinding, holder.getVariableId(), this.getBindingLayoutRes());
            }
        }
        return this.mBinding.getRoot();
    }

    public void onDestroyView() {
        super.onDestroyView();
        if (this.mBinding != null) {
            this.mBinding.unbind();
        }
    }

    @LayoutRes
    public abstract int getBindingLayoutRes();

    public abstract BindingList getViewModelBindings();

    public <VM extends ViewModel> VM getViewModel(Class<VM> viewModelClass) {
        return (VM)((ViewModel)this.map.get((Object)viewModelClass.getCanonicalName()));
    }

    public B binding() {
        return this.mBinding;
    }

    protected BindingList list(ViewModelBinding ... binding) {
        return new BindingList(binding);
    }

    protected final ViewModelBinding bind(FragmentActivity activity, int variableId, Class<? extends ViewModel> vmClass) {
        return new ViewModelBinding(activity, variableId, vmClass);
    }

    protected final <T extends ViewModel> ViewModelBinding bind(FragmentActivity activity, int variableId, Class<T> vmClass, ViewModelBinding.Factory<T> factory) {
        return new ViewModelBinding(activity, variableId, vmClass, factory);
    }

    protected final ViewModelBinding bind(Fragment fragment, int variableId, Class<? extends ViewModel> vmClass) {
        return new ViewModelBinding(fragment, variableId, vmClass);
    }

    protected final <T extends ViewModel> ViewModelBinding bind(Fragment fragment, int variableId, Class<T> vmClass, ViewModelBinding.Factory<T> factory) {
        return new ViewModelBinding(fragment, variableId, vmClass, factory);
    }
}

