/*
 * Decompiled with CFR 0.152.
 */
package xyz.truenight.databinding.lifecycle;

import android.arch.lifecycle.GenericLifecycleObserver;
import android.arch.lifecycle.Lifecycle;
import android.arch.lifecycle.LifecycleObserver;
import android.arch.lifecycle.LifecycleOwner;
import android.arch.lifecycle.OnLifecycleEvent;
import android.arch.lifecycle.ViewModel;

public abstract class LifecycleTrackingViewModel
extends ViewModel {
    private boolean active;
    private int mActiveCount;

    public void registerLifecycle(final LifecycleOwner owner) {
        owner.getLifecycle().addObserver((LifecycleObserver)new GenericLifecycleObserver(){

            @OnLifecycleEvent(value=Lifecycle.Event.ON_ANY)
            public void onStateChanged(LifecycleOwner source, Lifecycle.Event event) {
                if (source.getLifecycle().getCurrentState() == Lifecycle.State.DESTROYED) {
                    owner.getLifecycle().removeObserver((LifecycleObserver)this);
                    return;
                }
                LifecycleTrackingViewModel.this.activeStateChanged(LifecycleTrackingViewModel.isActiveState(source.getLifecycle().getCurrentState()));
            }
        });
    }

    private void activeStateChanged(boolean newActive) {
        if (newActive == this.active) {
            return;
        }
        this.active = newActive;
        boolean wasInactive = this.mActiveCount == 0;
        this.mActiveCount += this.active ? 1 : -1;
        if (wasInactive && this.active) {
            this.onActive();
        }
        if (this.mActiveCount == 0 && !this.active) {
            this.onInactive();
        }
    }

    private static boolean isActiveState(Lifecycle.State state) {
        return state.isAtLeast(Lifecycle.State.STARTED);
    }

    public abstract void onActive();

    public abstract void onInactive();
}

