/*
 * Decompiled with CFR 0.152.
 */
package xyz.tozymc.configuration.json.option;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import org.jetbrains.annotations.NotNull;
import xyz.tozymc.configuration.file.FileConfig;
import xyz.tozymc.configuration.file.option.FileConfigOptions;
import xyz.tozymc.configuration.json.JsonConfig;

public class JsonConfigOptions
extends FileConfigOptions {
    private Gson gson;
    private boolean prettyPrint = true;

    public JsonConfigOptions(@NotNull FileConfig config) {
        super(config);
    }

    public boolean prettyPrint() {
        return this.prettyPrint;
    }

    @NotNull
    public JsonConfigOptions prettyPrint(boolean prettyPrint) {
        if (this.prettyPrint != prettyPrint) {
            this.gson = null;
        }
        this.prettyPrint = prettyPrint;
        return this;
    }

    @NotNull
    public Gson gson() {
        if (this.gson != null) {
            return this.gson;
        }
        GsonBuilder builder = new GsonBuilder();
        if (this.prettyPrint) {
            builder.setPrettyPrinting();
        }
        this.gson = builder.create();
        return this.gson;
    }

    @NotNull
    public JsonConfig config() {
        return (JsonConfig)super.config();
    }
}

