/*
 * Decompiled with CFR 0.152.
 */
package xyz.tozymc.configuration.util;

import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public final class Validators {
    private Validators() {
    }

    @Contract(value="null, _ -> fail; !null, _ -> param1", pure=true)
    @NotNull
    public static <T> T notNullArgs(T obj, String errMessage) {
        if (obj == null) {
            throw new IllegalArgumentException(errMessage);
        }
        return obj;
    }

    @Contract(value="null, _, _ -> fail; !null, _, _ -> param1")
    @NotNull
    public static <T> T notNullArgs(T obj, String errMessage, Object ... errMessageArgs) {
        if (obj == null) {
            throw new IllegalArgumentException(String.format(errMessage, errMessageArgs));
        }
        return obj;
    }

    @Contract(value="null, _ -> fail; !null, _ -> param1", pure=true)
    @NotNull
    public static <T> T notNull(T obj, String errMessage) {
        if (obj == null) {
            throw new NullPointerException(errMessage);
        }
        return obj;
    }
}

