/*
 * Decompiled with CFR 0.152.
 */
package xyz.tozymc.configuration.util;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.tozymc.configuration.TcConfigSection;

public final class SectionPaths {
    private SectionPaths() {
    }

    @NotNull
    public static String createPath(@Nullable TcConfigSection parent, @NotNull String name) {
        if (parent == null) {
            return name;
        }
        String parentPath = parent.getFullPath();
        return parentPath.isBlank() ? name : String.format("%s%s%s", parentPath, Character.valueOf(SectionPaths.getPathSeparator(parent)), name);
    }

    @NotNull
    public static String createPath(@NotNull TcConfigSection parent, @NotNull TcConfigSection relativeTo, @NotNull String name) {
        char sep = SectionPaths.getPathSeparator(parent);
        StringBuilder builder = new StringBuilder();
        for (TcConfigSection curr = parent; curr != null && curr != relativeTo; curr = curr.getParent()) {
            if (builder.length() > 0) {
                builder.insert(0, sep);
            }
            builder.insert(0, curr.getName());
        }
        if (builder.length() > 0) {
            builder.append(sep);
        }
        return builder.append(name).toString();
    }

    private static char getPathSeparator(TcConfigSection section) {
        return section.getRoot().getOptions().pathSeparator();
    }
}

