/*
 * Decompiled with CFR 0.152.
 */
package xyz.tozymc.configuration.serialization;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.VarHandle;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import xyz.tozymc.configuration.exception.TcConfigSerializationException;
import xyz.tozymc.configuration.serialization.annotation.SerializeAs;

final class ReflectionCache {
    private final MethodHandles.Lookup lookup = MethodHandles.lookup();
    private final Map<Class<?>, List<AnnotatedField>> annotatedFields = new HashMap();
    private final Map<Class<?>, AnnotatedConstructor> annotatedConstructors = new HashMap();

    ReflectionCache() {
    }

    void clear() {
        this.annotatedFields.clear();
        this.annotatedConstructors.clear();
    }

    List<AnnotatedField> getAnnotatedFields(Class<?> clazz) {
        if (this.annotatedFields.containsKey(clazz)) {
            return this.annotatedFields.get(clazz);
        }
        List<AnnotatedField> annotatedFields = Arrays.stream(clazz.getDeclaredFields()).filter(field -> field.isAnnotationPresent(SerializeAs.class)).map(x$0 -> new AnnotatedField((Field)x$0)).collect(Collectors.toUnmodifiableList());
        this.annotatedFields.put(clazz, annotatedFields);
        return annotatedFields;
    }

    AnnotatedConstructor getAnnotatedConstructor(Class<?> clazz) {
        if (this.annotatedConstructors.containsKey(clazz)) {
            return this.annotatedConstructors.get(clazz);
        }
        AnnotatedConstructor annotatedConstructor = this.findParametersConstructor(clazz);
        if (annotatedConstructor == null) {
            annotatedConstructor = this.findEmptyConstructor(clazz);
        }
        this.annotatedConstructors.put(clazz, annotatedConstructor);
        return annotatedConstructor;
    }

    private AnnotatedConstructor findParametersConstructor(Class<?> clazz) {
        List<Class<?>> paramTypes = this.getAnnotatedFields(clazz).stream().map(f -> f.varHandle.varType()).collect(Collectors.toUnmodifiableList());
        try {
            MethodHandle constructor = MethodHandles.privateLookupIn(clazz, this.lookup).findConstructor(clazz, MethodType.methodType(Void.TYPE, paramTypes));
            if (constructor != null) {
                return new AnnotatedConstructor(constructor, true);
            }
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            // empty catch block
        }
        return null;
    }

    private AnnotatedConstructor findEmptyConstructor(Class<?> clazz) {
        try {
            MethodHandle constructor = this.lookup.findConstructor(clazz, MethodType.methodType(Void.TYPE));
            return new AnnotatedConstructor(constructor, false);
        }
        catch (NoSuchMethodException e) {
            throw new TcConfigSerializationException("Type must have an empty constructor to deserialize", e);
        }
        catch (IllegalAccessException e) {
            throw new TcConfigSerializationException("Error when accessing to empty constructor", e);
        }
    }

    class AnnotatedField {
        private final VarHandle varHandle;
        private final String key;

        private AnnotatedField(Field field) {
            try {
                this.varHandle = MethodHandles.privateLookupIn(field.getDeclaringClass(), ReflectionCache.this.lookup).unreflectVarHandle(field);
            }
            catch (IllegalAccessException e) {
                throw new TcConfigSerializationException("Error when converting Field to VarHandle", e);
            }
            this.key = field.getAnnotation(SerializeAs.class).value();
        }

        String key() {
            return this.key;
        }

        Object value(Object instance) {
            return this.varHandle.get(instance);
        }

        void set(Object instance, Object value) {
            this.varHandle.set(instance, value);
        }
    }

    class AnnotatedConstructor {
        private final MethodHandle constructor;
        private final boolean hasParams;

        AnnotatedConstructor(MethodHandle constructor, boolean hasParams) {
            this.constructor = constructor;
            this.hasParams = hasParams;
        }

        Object newInstance(Map<String, ?> params) {
            return this.hasParams ? this.newInstance0(params.values()) : this.setObjectFields(this.newInstance0(Collections.emptyList()), params);
        }

        private Object newInstance0(Collection<?> values) {
            try {
                return this.constructor.invokeWithArguments(List.copyOf(values));
            }
            catch (Throwable e) {
                throw new TcConfigSerializationException("Error when invoking new instance", e);
            }
        }

        private Object setObjectFields(Object object, Map<String, ?> map) {
            List<AnnotatedField> annotatedFields = ReflectionCache.this.getAnnotatedFields(object.getClass());
            annotatedFields.forEach(f -> f.set(object, map.get(f.key())));
            return object;
        }
    }
}

