/*
 * Decompiled with CFR 0.152.
 */
package xyz.tozymc.configuration.memory;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import xyz.tozymc.configuration.exception.TcConfigException;
import xyz.tozymc.configuration.exception.TcConfigSerializationException;
import xyz.tozymc.configuration.memory.MemoryConfigSection;
import xyz.tozymc.configuration.memory.PrimitiveArrays;
import xyz.tozymc.configuration.serialization.TcConfigSerializations;
import xyz.tozymc.configuration.util.SectionPaths;

class MemoryStorage {
    final LinkedHashMap<String, Object> values = new LinkedHashMap();
    private final MemoryConfigSection section;
    private Set<String> keySet;
    private Map<String, ?> cachedValues;

    MemoryStorage(MemoryConfigSection section) {
        this.section = section;
    }

    private static String getFirstPathNode(String path, int pathSepInd) {
        return path.substring(0, pathSepInd);
    }

    private static String trimFirstPathNode(String path, int pathSepInd) {
        return path.substring(pathSepInd + 1);
    }

    private static List<?> mappedArrayValue(Object[] values) {
        ArrayList<Object> list = new ArrayList<Object>();
        for (Object value : values) {
            try {
                Map<String, ?> serialized = TcConfigSerializations.serializeObject(value);
                list.add(serialized);
            }
            catch (TcConfigSerializationException ignored) {
                list.add(value);
            }
        }
        return list;
    }

    private int getPathSepIndex(String path) {
        return path.indexOf(this.section.getRoot().getOptions().pathSeparator());
    }

    void reload(Map<String, ?> map) {
        this.clearCache();
        this.values.clear();
        map.forEach((k, v) -> {
            if (v instanceof Map) {
                this.createSection((String)k, true, (Map)v);
            } else {
                this.set((String)k, false, v);
            }
        });
    }

    Object get(String path) {
        if (path.isEmpty()) {
            return null;
        }
        int pathSepInd = this.getPathSepIndex(path);
        if (pathSepInd < 0) {
            return this.values.get(path);
        }
        String firstNode = MemoryStorage.getFirstPathNode(path, pathSepInd);
        Object val = this.values.get(firstNode);
        if (val instanceof MemoryConfigSection) {
            return ((MemoryConfigSection)val).storage.get(MemoryStorage.trimFirstPathNode(path, pathSepInd));
        }
        throw new TcConfigException(SectionPaths.createPath(this.section, firstNode) + " is not a section");
    }

    Object set(String path, boolean absent, Object newVal) {
        if (path.isEmpty()) {
            return null;
        }
        int pathSepInd = this.getPathSepIndex(path);
        if (pathSepInd < 0) {
            if (absent && this.values.containsKey(path)) {
                return null;
            }
            return this.setShallow(path, newVal);
        }
        String firstNode = MemoryStorage.getFirstPathNode(path, pathSepInd);
        Object val = this.values.get(firstNode);
        if (val == null) {
            val = this.createShallowSection(firstNode);
        }
        if (val instanceof MemoryConfigSection) {
            return ((MemoryConfigSection)val).storage.set(MemoryStorage.trimFirstPathNode(path, pathSepInd), absent, newVal);
        }
        throw new TcConfigException(SectionPaths.createPath(this.section, firstNode) + " is not a section");
    }

    private Object setShallow(String path, Object value) {
        Object old = this.values.get(path);
        if (value instanceof Map) {
            this.createSection(path, true, (Map)value);
            return old;
        }
        try {
            this.createSection(path, true, TcConfigSerializations.serializeObject(value));
            return old;
        }
        catch (TcConfigSerializationException tcConfigSerializationException) {
            if (value.getClass().isArray()) {
                return this.setArrayValue(path, value);
            }
            return this.setValue(path, value);
        }
    }

    private Object setValue(String key, Object value) {
        if (value == null) {
            return this.values.remove(key);
        }
        return this.values.put(key, value);
    }

    private Object setArrayValue(String key, Object value) {
        if (value == null) {
            return this.values.remove(key);
        }
        if (value instanceof byte[]) {
            return this.values.put(key, PrimitiveArrays.toList((byte[])value));
        }
        if (value instanceof short[]) {
            return this.values.put(key, PrimitiveArrays.toList((short[])value));
        }
        if (value instanceof int[]) {
            return this.values.put(key, PrimitiveArrays.toList((int[])value));
        }
        if (value instanceof long[]) {
            return this.values.put(key, PrimitiveArrays.toList((long[])value));
        }
        if (value instanceof float[]) {
            return this.values.put(key, PrimitiveArrays.toList((float[])value));
        }
        if (value instanceof double[]) {
            return this.values.put(key, PrimitiveArrays.toList((double[])value));
        }
        if (value instanceof char[]) {
            return this.values.put(key, PrimitiveArrays.toList((char[])value));
        }
        if (value instanceof boolean[]) {
            return this.values.put(key, PrimitiveArrays.toList((boolean[])value));
        }
        return this.values.put(key, MemoryStorage.mappedArrayValue((Object[])value));
    }

    MemoryConfigSection createShallowSection(String path) {
        MemoryConfigSection child = this.section.newSection(this.section, path);
        this.values.put(path, child);
        return child;
    }

    MemoryConfigSection createSection(String path, boolean force, Map<String, ?> initials) throws TcConfigException {
        if (path.isEmpty()) {
            return null;
        }
        int pathSepInd = this.getPathSepIndex(path);
        if (pathSepInd < 0) {
            Object val = this.values.get(path);
            if (force && val != null) {
                throw new TcConfigException(SectionPaths.createPath(this.section, path) + " is exited");
            }
            MemoryConfigSection child = this.createShallowSection(path);
            if (initials != null) {
                initials.forEach((k, v) -> child.storage.set((String)k, false, v));
            }
            return child;
        }
        String firstNode = MemoryStorage.getFirstPathNode(path, pathSepInd);
        Object val = this.values.get(firstNode);
        if (force && val != null) {
            throw new TcConfigException(SectionPaths.createPath(this.section, path) + " is exited");
        }
        MemoryConfigSection child = this.createShallowSection(path);
        return child.storage.createSection(MemoryStorage.trimFirstPathNode(path, pathSepInd), force, initials);
    }

    void clearCache() {
        this.keySet = null;
        this.cachedValues = null;
    }

    Set<String> getKeys(boolean deep) {
        if (!deep) {
            return Collections.unmodifiableSet(this.values.keySet());
        }
        Set<String> ks = this.keySet;
        if (ks == null) {
            LinkedHashSet<String> keys = new LinkedHashSet<String>();
            this.keySet(keys, this.section);
            this.keySet = ks = Collections.unmodifiableSet(keys);
        }
        return ks;
    }

    private void keySet(Set<String> keys, MemoryConfigSection relativeTo) {
        this.values.forEach((k, v) -> {
            keys.add(SectionPaths.createPath(this.section, relativeTo, k));
            if (v instanceof MemoryConfigSection) {
                ((MemoryConfigSection)v).storage.keySet(keys, relativeTo);
            }
        });
    }

    Map<String, ?> getValues() {
        LinkedHashMap<String, Object> root = new LinkedHashMap<String, Object>();
        this.mapValues(root);
        return root;
    }

    void mapValues(Map<String, Object> mapped) {
        this.values.forEach((k, v) -> {
            if (v instanceof MemoryConfigSection) {
                LinkedHashMap<String, Object> child = new LinkedHashMap<String, Object>();
                mapped.put((String)k, child);
                ((MemoryConfigSection)v).storage.mapValues(child);
            } else {
                mapped.put((String)k, v);
            }
        });
    }

    Map<String, ?> cachedValues() {
        if (this.cachedValues == null) {
            this.cachedValues = this.getValues();
            return this.cachedValues;
        }
        return this.cachedValues;
    }
}

