/*
 * Decompiled with CFR 0.152.
 */
package xyz.tozymc.configuration.memory;

import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnmodifiableView;
import xyz.tozymc.configuration.TcConfig;
import xyz.tozymc.configuration.TcConfigSection;
import xyz.tozymc.configuration.exception.TcConfigException;
import xyz.tozymc.configuration.memory.MemoryStorage;
import xyz.tozymc.configuration.serialization.TcConfigSerializations;
import xyz.tozymc.configuration.util.SectionPaths;
import xyz.tozymc.configuration.util.Validators;

public abstract class MemoryConfigSection
implements TcConfigSection {
    final MemoryStorage storage = new MemoryStorage(this);
    private final TcConfig root;
    private final TcConfigSection parent;
    private final String name;
    private final String fullPath;

    protected MemoryConfigSection() {
        if (!(this instanceof TcConfig)) {
            throw new IllegalStateException("Cannot construct a root section when not a TcConfig");
        }
        this.root = (TcConfig)((Object)this);
        this.parent = null;
        this.name = "";
        this.fullPath = "";
    }

    protected MemoryConfigSection(@NotNull TcConfigSection parent, @NotNull String name) {
        this.root = parent.getRoot();
        this.parent = parent;
        this.name = name;
        this.fullPath = SectionPaths.createPath(parent, name);
    }

    protected abstract MemoryConfigSection newSection(TcConfigSection var1, String var2);

    protected void reloadSection(Map<String, ?> map) {
        this.storage.reload(map);
    }

    @Override
    @Nullable
    public <T> T get(@NotNull String path, @NotNull Class<T> type) {
        Object val = this.get(path);
        if (val instanceof MemoryConfigSection) {
            return TcConfigSerializations.deserializeObject(type, ((MemoryConfigSection)val).storage.cachedValues());
        }
        return type.isInstance(val) ? (T)type.cast(val) : null;
    }

    @Override
    @Nullable
    public <T> T getOrDefault(@NotNull String path, @NotNull Class<T> type, @Nullable T def) {
        T val = this.get(path, type);
        return val != null ? val : def;
    }

    @Override
    @Nullable
    public Object get(@NotNull String path) {
        Validators.notNullArgs(path, "Path cannot be null");
        return this.getOrDefault(path, null);
    }

    @Override
    @Nullable
    public Object getOrDefault(@NotNull String path, @Nullable Object def) {
        Validators.notNullArgs(path, "Path cannot be null");
        Object val = this.storage.get(path);
        return val != null ? val : def;
    }

    @Override
    @Nullable
    public Object set(@NotNull String path, @Nullable Object value) {
        Validators.notNullArgs(path, "Path cannot be null");
        return this.storage.set(path, false, value);
    }

    @Override
    @Nullable
    public Object setIfAbsent(@NotNull String path, @Nullable Object value) {
        Validators.notNullArgs(path, "Path cannot be null");
        return this.storage.set(path, true, value);
    }

    @Override
    public @UnmodifiableView @NotNull Set<String> getKeys(boolean deep) {
        return this.storage.getKeys(deep);
    }

    @Override
    @NotNull
    public Map<String, ?> getValues() {
        return this.storage.getValues();
    }

    @Override
    public boolean hasChild(@NotNull String path) {
        Validators.notNullArgs(path, "Path cannot be null");
        return this.getChild(path) != null;
    }

    @Override
    @NotNull
    public TcConfigSection createChild(@NotNull String path) throws TcConfigException {
        Validators.notNullArgs(path, "Path cannot be null");
        return this.storage.createSection(path, false, null);
    }

    @Override
    @NotNull
    public TcConfigSection createChild(@NotNull String path, Map<String, ?> values) throws TcConfigException {
        Validators.notNullArgs(path, "Path cannot be null");
        return this.storage.createSection(path, false, values);
    }

    @Override
    @Nullable
    public TcConfigSection getChild(@NotNull String path) {
        Validators.notNullArgs(path, "Path cannot be null");
        Object val = this.get(path);
        return val instanceof TcConfigSection ? (TcConfigSection)val : null;
    }

    @Override
    @Nullable
    public TcConfigSection getParent() {
        return this.parent;
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @NotNull
    public String getFullPath() {
        return this.fullPath;
    }

    @Override
    @NotNull
    public TcConfig getRoot() {
        return this.root;
    }
}

