/*
 * Decompiled with CFR 0.152.
 */
package xyz.tozymc.configuration.file.builder;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.tozymc.configuration.builder.AbstractConfigBuilder;
import xyz.tozymc.configuration.file.FileConfig;
import xyz.tozymc.configuration.file.option.ReloadableType;

public abstract class AbstractFileConfigBuilder<T extends FileConfig>
extends AbstractConfigBuilder<T> {
    private final Path configPath;
    private InputStream defaultStream;
    private ReloadableType reloadableType = ReloadableType.MANUALLY;

    protected AbstractFileConfigBuilder(Path configPath) {
        this.configPath = configPath;
    }

    @NotNull
    public Path configPath() {
        return this.configPath;
    }

    @Nullable
    public InputStream defaultStream() {
        return this.defaultStream;
    }

    @NotNull
    public AbstractFileConfigBuilder<T> defaultStream(@NotNull InputStream defaultStream) {
        this.defaultStream = defaultStream;
        return this;
    }

    @NotNull
    public AbstractFileConfigBuilder<T> defaultResource(@NotNull ClassLoader classLoader, @NotNull String name) {
        this.defaultStream = classLoader.getResourceAsStream(name);
        return this;
    }

    @NotNull
    public ReloadableType reloadType() {
        return this.reloadableType;
    }

    @NotNull
    public AbstractFileConfigBuilder<T> reloadType(@NotNull ReloadableType reloadableType) {
        this.reloadableType = reloadableType;
        return this;
    }

    @Override
    public T createConfig() {
        this.createFileIfNotExist();
        this.saveDefaultConfig();
        T config = this.buildConfig();
        ((FileConfig)config).getOptions().reloadType(this.reloadableType).pathSeparator(this.pathSeparator());
        return config;
    }

    private synchronized void createFileIfNotExist() {
        if (!Files.notExists(this.configPath, new LinkOption[0])) {
            return;
        }
        try {
            Files.createFile(this.configPath, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Error occurs when creating new file " + this.configPath.getFileName().toString(), e);
        }
    }

    private synchronized void saveDefaultConfig() {
        if (this.defaultStream == null) {
            return;
        }
        try (OutputStream out = Files.newOutputStream(this.configPath, new OpenOption[0]);){
            this.defaultStream.transferTo(out);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Error occurs when transfer default stream to file", e);
        }
    }

    protected abstract T buildConfig();
}

