/*
 * Decompiled with CFR 0.152.
 */
package xyz.tozymc.configuration;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnmodifiableView;
import xyz.tozymc.configuration.TcConfigSection;
import xyz.tozymc.configuration.exception.TcConfigSerializationException;
import xyz.tozymc.configuration.serialization.TcConfigSerializations;
import xyz.tozymc.configuration.util.NumberConversions;

public interface DataStorage {
    default public <T> boolean contains(@NotNull String path, @NotNull Class<T> type) {
        return type.isInstance(this.get(path));
    }

    default public boolean contains(@NotNull String path) {
        return this.get(path) != null;
    }

    @Nullable
    public <T> T get(@NotNull String var1, @NotNull Class<T> var2) throws TcConfigSerializationException;

    @Nullable
    public <T> T getOrDefault(@NotNull String var1, @NotNull Class<T> var2, @Nullable T var3) throws TcConfigSerializationException;

    @Nullable
    public Object get(@NotNull String var1);

    @Nullable
    public Object getOrDefault(@NotNull String var1, @Nullable Object var2);

    @NotNull
    default public <T> Optional<T> find(@NotNull String path, Class<T> type) {
        return Optional.ofNullable(this.get(path, type));
    }

    @NotNull
    default public Optional<?> find(@NotNull String path) {
        return Optional.ofNullable(this.get(path));
    }

    @Nullable
    public Object set(@NotNull String var1, @Nullable Object var2);

    @Nullable
    public Object setIfAbsent(@NotNull String var1, @Nullable Object var2);

    @Nullable
    default public Object remove(@NotNull String path) {
        return this.set(path, null);
    }

    default public boolean replace(@NotNull String path, @NotNull Object oldValue, @Nullable Object newValue) {
        Object curVal = this.get(path);
        if (oldValue.equals(curVal) || curVal == null) {
            return false;
        }
        this.set(path, newValue);
        return true;
    }

    @Nullable
    default public <T> T computeIfAbsent(@NotNull String path, @NotNull Class<T> type, @NotNull Function<String, ? extends T> mappingFn) {
        T newVal;
        T val = this.get(path, type);
        if (val != null && (newVal = mappingFn.apply(path)) != null) {
            this.set(path, newVal);
            return newVal;
        }
        return val;
    }

    @Nullable
    default public <T> T computeIfPresent(@NotNull String path, @NotNull Class<T> type, @NotNull BiFunction<String, ? super T, ? extends T> remappingFn) {
        T oldVal = this.get(path, type);
        if (oldVal == null) {
            return null;
        }
        T newVal = remappingFn.apply(path, (String)oldVal);
        this.set(path, newVal);
        return newVal;
    }

    @Nullable
    default public <T> T compute(@NotNull String path, @NotNull Class<T> type, @NotNull BiFunction<String, ? super T, ? extends T> remappingFn) {
        T oldVal = this.get(path, type);
        T newVal = remappingFn.apply(path, (String)oldVal);
        if (newVal != null) {
            this.set(path, newVal);
            return newVal;
        }
        if (oldVal != null) {
            this.remove(path);
        }
        return null;
    }

    @Nullable
    default public <T> T merge(@NotNull String path, @NotNull Class<T> type, @Nullable T value, @NotNull BiFunction<? super T, ? super T, ? extends T> remappingFn) {
        T oldVal = this.get(path, type);
        T newVal = oldVal == null ? value : remappingFn.apply(oldVal, value);
        this.set(path, newVal);
        return newVal;
    }

    default public @UnmodifiableView @NotNull Set<String> getKeys() {
        return this.getKeys(false);
    }

    public @UnmodifiableView @NotNull Set<String> getKeys(boolean var1);

    @NotNull
    public Map<String, ?> getValues();

    default public boolean isInt(@NotNull String path) {
        return this.contains(path, Integer.class);
    }

    default public int getInt(@NotNull String path) {
        return NumberConversions.toInt(this.get(path));
    }

    default public boolean isLong(@NotNull String path) {
        return this.contains(path, Long.class);
    }

    default public long getLong(@NotNull String path) {
        return NumberConversions.toLong(this.get(path));
    }

    default public boolean isDouble(@NotNull String path) {
        return this.contains(path, Double.class);
    }

    default public double getDouble(@NotNull String path) {
        return NumberConversions.toDouble(this.get(path));
    }

    default public boolean isBoolean(@NotNull String path) {
        return this.contains(path, Boolean.class);
    }

    default public boolean getBoolean(@NotNull String path) {
        Object val = this.get(path);
        if (val instanceof Boolean) {
            return (Boolean)val;
        }
        return val instanceof String && Boolean.parseBoolean(String.valueOf(val));
    }

    default public boolean isString(@NotNull String path) {
        return this.contains(path, String.class);
    }

    @NotNull
    default public String getString(@NotNull String path) {
        return String.valueOf(this.get(path));
    }

    default public boolean isList(@NotNull String path) {
        return this.contains(path, List.class);
    }

    default public @UnmodifiableView @NotNull List<?> getList(@NotNull String path) {
        Object val = this.get(path);
        if (val instanceof List) {
            return Collections.unmodifiableList((List)val);
        }
        return Collections.emptyList();
    }

    default public <T> @UnmodifiableView @NotNull List<T> getList(@NotNull String path, @NotNull Class<T> type) {
        Object val = this.get(path);
        if (val instanceof List) {
            return ((List)val).stream().map(e -> {
                if (e instanceof TcConfigSection) {
                    return TcConfigSerializations.deserializeObject(type, ((TcConfigSection)e).getValues());
                }
                if (e instanceof Map) {
                    return TcConfigSerializations.deserializeObject(type, (Map)e);
                }
                return type.cast(e);
            }).collect(Collectors.toUnmodifiableList());
        }
        return Collections.emptyList();
    }

    default public @UnmodifiableView @NotNull List<String> getStringList(@NotNull String path) {
        Object val = this.get(path);
        if (val instanceof List) {
            return ((List)val).stream().map(String::valueOf).collect(Collectors.toUnmodifiableList());
        }
        return Collections.emptyList();
    }

    default public @UnmodifiableView @NotNull List<Integer> getIntegerList(@NotNull String path) {
        Object val = this.get(path);
        if (val instanceof List) {
            return ((List)val).stream().map(NumberConversions::toInt).collect(Collectors.toUnmodifiableList());
        }
        return Collections.emptyList();
    }

    default public @UnmodifiableView @NotNull List<Double> getDoubleList(@NotNull String path) {
        Object val = this.get(path);
        if (val instanceof List) {
            return ((List)val).stream().map(NumberConversions::toDouble).collect(Collectors.toUnmodifiableList());
        }
        return Collections.emptyList();
    }

    default public @UnmodifiableView @NotNull List<Map<String, ?>> getMapList(@NotNull String path) {
        Object val = this.get(path);
        if (val instanceof List) {
            return ((List)val).stream().filter(Map.class::isInstance).map(e -> ((Map)e).entrySet().stream().map(entry -> Map.entry(String.valueOf(entry.getKey()), entry.getValue())).collect(Collectors.toUnmodifiableMap(Map.Entry::getKey, Map.Entry::getValue, (a, b) -> b))).collect(Collectors.toUnmodifiableList());
        }
        return Collections.emptyList();
    }
}

