/*
 * Decompiled with CFR 0.152.
 */
package xyz.tozymc.spigot.api.util.bukkit;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.md_5.bungee.api.ChatColor;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import xyz.tozymc.spigot.api.util.Lists;

public final class Colors {
    private static final Pattern HEX_PATTERN = Pattern.compile("&(#[a-fA-F0-9]{6})");
    private static final MethodHandle CHAT_COLOR_OF_METHOD;

    private Colors() {
    }

    @NotNull
    @Contract(value="_ -> new")
    public static String color(@NotNull String text) {
        return Colors.hex(text);
    }

    private static String hex(String text) {
        String coloredText = ChatColor.translateAlternateColorCodes((char)'&', (String)text);
        if (CHAT_COLOR_OF_METHOD == null) {
            return coloredText;
        }
        Matcher matcher = HEX_PATTERN.matcher(coloredText);
        StringBuffer buffer = new StringBuffer();
        while (matcher.find()) {
            Colors.replaceHex(buffer, matcher);
        }
        return matcher.appendTail(buffer).toString();
    }

    private static void replaceHex(StringBuffer buffer, Matcher matcher) {
        if (CHAT_COLOR_OF_METHOD == null) {
            matcher.appendReplacement(buffer, "");
            return;
        }
        try {
            matcher.appendReplacement(buffer, CHAT_COLOR_OF_METHOD.invoke(matcher.group(1)).toString());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Contract(value="_ -> param1")
    public static String[] color(String ... texts) {
        Arrays.setAll(texts, i -> Colors.color(texts[i]));
        return texts;
    }

    public static List<String> color(List<String> list) {
        Lists.setAll(list, Colors::color);
        return list;
    }

    static {
        MethodHandle chatColorOfMethod = null;
        try {
            chatColorOfMethod = MethodHandles.lookup().findStatic(ChatColor.class, "of", MethodType.methodType(ChatColor.class, String.class));
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            // empty catch block
        }
        CHAT_COLOR_OF_METHOD = chatColorOfMethod;
    }
}

