/*
 * Decompiled with CFR 0.152.
 */
package xyz.tozymc.spigot.api.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ListIterator;
import java.util.function.Function;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public final class Lists {
    private Lists() {
    }

    @SafeVarargs
    @NotNull
    @Contract(value="_ -> new")
    public static <E> ArrayList<E> newArrayList(E ... elements) {
        return new ArrayList<E>(Arrays.asList(elements));
    }

    @SafeVarargs
    @NotNull
    @Contract(value="_, _ -> param1")
    public static <E> List<E> addAll(@NotNull List<E> list, E ... elements) {
        list.addAll(Arrays.asList(elements));
        return list;
    }

    @NotNull
    @Contract(value="_, _ -> param1")
    public static <T> List<T> setAll(@NotNull List<T> list, Function<T, T> function) {
        if (function == null) {
            return list;
        }
        ListIterator<T> iterator = list.listIterator();
        while (iterator.hasNext()) {
            iterator.set(function.apply(iterator.next()));
        }
        return list;
    }
}

