/*
 * Decompiled with CFR 0.152.
 */
package xyz.tozymc.spigot.api.command.wrapper;

import java.util.ArrayList;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandMap;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.SimpleCommandMap;
import org.jetbrains.annotations.NotNull;
import xyz.tozymc.spigot.api.command.AbstractCommand;
import xyz.tozymc.spigot.api.command.Command;
import xyz.tozymc.spigot.api.command.CommandController;
import xyz.tozymc.spigot.api.command.util.Reflections;

public final class SimpleCommandMapWrapper {
    private final CommandController controller;
    private final String fallbackPrefix;
    private final SimpleCommandMap commandMap;
    private final Map<String, org.bukkit.command.Command> knownCommands;

    public SimpleCommandMapWrapper(@NotNull CommandController controller) {
        this.controller = controller;
        this.fallbackPrefix = controller.getFallbackPrefix();
        this.commandMap = Reflections.getCommandMap(Bukkit.getServer());
        this.knownCommands = Reflections.getKnownCommands(this.commandMap);
    }

    public boolean registerPluginCommand(@NotNull Command command) {
        if (this.knownCommands.containsValue(this.getPluginCommand(command))) {
            return false;
        }
        PluginCommand plCmd = AbstractCommand.asPluginCommandCopy(command, this.controller);
        return this.register(plCmd);
    }

    private boolean register(PluginCommand command) {
        return this.commandMap.register(this.fallbackPrefix, (org.bukkit.command.Command)command);
    }

    public boolean unregisterPluginCommand(Command command) {
        PluginCommand plCmd = this.getPluginCommand(command);
        if (!this.unregister(plCmd)) {
            return false;
        }
        return plCmd.unregister((CommandMap)this.commandMap);
    }

    private synchronized boolean unregister(PluginCommand command) {
        if (!this.knownCommands.containsValue(command)) {
            return false;
        }
        ArrayList registered = new ArrayList();
        this.knownCommands.forEach((label, comm) -> {
            if (comm.equals(command)) {
                registered.add(label);
            }
        });
        registered.forEach(this.knownCommands::remove);
        return !registered.isEmpty();
    }

    public PluginCommand getPluginCommand(@NotNull Command command) {
        return (PluginCommand)this.knownCommands.get(this.fallbackPrefix + ":" + command.getName());
    }
}

