/*
 * Decompiled with CFR 0.152.
 */
package xyz.tozymc.spigot.api.command;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.TabCompleter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.tozymc.spigot.api.command.Command;
import xyz.tozymc.spigot.api.command.CommandController;
import xyz.tozymc.spigot.api.command.util.Reflections;
import xyz.tozymc.spigot.api.util.Lists;

public abstract class AbstractCommand
implements Command {
    protected final Command root;
    protected final String name;
    private final List<String> aliases;

    public AbstractCommand(@Nullable Command root, @NotNull String name, @NotNull List<String> aliases) {
        this.root = root;
        this.name = name;
        this.aliases = Lists.addAll(aliases, name);
    }

    public AbstractCommand(@Nullable Command root, @NotNull String name, String ... aliases) {
        this(root, name, Lists.newArrayList(aliases));
    }

    public AbstractCommand(@NotNull Command root, @NotNull String name) {
        this(root, name, new ArrayList<String>());
    }

    public AbstractCommand(@NotNull String name) {
        this(null, name, new ArrayList<String>());
    }

    public AbstractCommand(@NotNull String name, String ... aliases) {
        this((Command)null, name, aliases);
    }

    public AbstractCommand(@NotNull String name, @NotNull List<String> aliases) {
        this(null, name, aliases);
    }

    @NotNull
    public static PluginCommand asPluginCommandCopy(@NotNull Command command, @NotNull CommandController controller) {
        PluginCommand plCmd = Reflections.newPluginCommand(command.getName(), controller.getPlugin());
        Preconditions.checkNotNull((Object)plCmd);
        plCmd.setDescription(command.getDescription());
        plCmd.setUsage(command.getSyntax());
        plCmd.setAliases(command.getAliases());
        plCmd.setExecutor((CommandExecutor)controller.getCommandHandler());
        plCmd.setTabCompleter((TabCompleter)controller.getTabHandler());
        return plCmd;
    }

    @Override
    @Nullable
    public Command getParent() {
        return this.getRoot();
    }

    @Override
    @Nullable
    public Command getRoot() {
        return this.root;
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @NotNull
    public List<String> getAliases() {
        return this.aliases;
    }

    @Override
    public String toString() {
        StringBuilder strBuilder = new StringBuilder(this.getClass().getSimpleName());
        strBuilder.append('(');
        if (this.root != null) {
            strBuilder.append("root=");
            strBuilder.append(this.root.getName());
            strBuilder.append(',');
        }
        strBuilder.append("name=");
        strBuilder.append(this.name);
        strBuilder.append(')');
        return strBuilder.toString();
    }
}

