/*
 * Decompiled with CFR 0.152.
 */
package org.littleshoot.proxy;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.net.InetSocketAddress;
import java.time.Duration;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.littleshoot.proxy.ActivityTracker;
import org.littleshoot.proxy.ChainedProxyManager;
import org.littleshoot.proxy.HostResolver;
import org.littleshoot.proxy.HttpFiltersSource;
import org.littleshoot.proxy.HttpProxyServer;
import org.littleshoot.proxy.MitmManager;
import org.littleshoot.proxy.ProxyAuthenticator;
import org.littleshoot.proxy.SslEngineSource;
import org.littleshoot.proxy.TransportProtocol;
import org.littleshoot.proxy.impl.ServerGroup;
import org.littleshoot.proxy.impl.ThreadPoolConfiguration;

@ParametersAreNonnullByDefault
public interface HttpProxyServerBootstrap {
    public HttpProxyServerBootstrap withName(String var1);

    public HttpProxyServerBootstrap withTransportProtocol(TransportProtocol var1);

    public HttpProxyServerBootstrap withAddress(InetSocketAddress var1);

    public HttpProxyServerBootstrap withPort(int var1);

    public HttpProxyServerBootstrap withAllowLocalOnly(boolean var1);

    @Deprecated
    public HttpProxyServerBootstrap withListenOnAllAddresses(boolean var1);

    public HttpProxyServerBootstrap withSslEngineSource(SslEngineSource var1);

    public HttpProxyServerBootstrap withAuthenticateSslClients(boolean var1);

    public HttpProxyServerBootstrap withProxyAuthenticator(ProxyAuthenticator var1);

    public HttpProxyServerBootstrap withChainProxyManager(ChainedProxyManager var1);

    public HttpProxyServerBootstrap withManInTheMiddle(MitmManager var1);

    public HttpProxyServerBootstrap withFiltersSource(HttpFiltersSource var1);

    @CanIgnoreReturnValue
    public HttpProxyServerBootstrap withUseDnsSec(boolean var1);

    public HttpProxyServerBootstrap withTransparent(boolean var1);

    public HttpProxyServerBootstrap withIdleConnectionTimeout(int var1);

    public HttpProxyServerBootstrap withIdleConnectionTimeout(Duration var1);

    public HttpProxyServerBootstrap withConnectTimeout(int var1);

    public HttpProxyServerBootstrap withServerResolver(HostResolver var1);

    public HttpProxyServerBootstrap withServerGroup(ServerGroup var1);

    public HttpProxyServerBootstrap plusActivityTracker(ActivityTracker var1);

    public HttpProxyServerBootstrap withThrottling(long var1, long var3);

    @Nonnull
    @CanIgnoreReturnValue
    public HttpProxyServerBootstrap withNetworkInterface(InetSocketAddress var1);

    public HttpProxyServerBootstrap withMaxInitialLineLength(int var1);

    public HttpProxyServerBootstrap withMaxHeaderSize(int var1);

    public HttpProxyServerBootstrap withMaxChunkSize(int var1);

    public HttpProxyServerBootstrap withAllowRequestToOriginServer(boolean var1);

    public HttpProxyServerBootstrap withProxyAlias(String var1);

    public HttpProxyServer start();

    public HttpProxyServerBootstrap withThreadPoolConfiguration(ThreadPoolConfiguration var1);

    public HttpProxyServerBootstrap withAcceptProxyProtocol(boolean var1);

    public HttpProxyServerBootstrap withSendProxyProtocol(boolean var1);
}

