/*
 * Decompiled with CFR 0.152.
 */
package xyz.quaver.hitomi;

import java.io.Closeable;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.UByteArray;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.collections.unsigned.UArraysKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.ranges.LongRange;
import kotlin.ranges.RangesKt;
import kotlin.text.Charsets;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import okhttp3.Request;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.quaver.UtilsKt;
import xyz.quaver.hitomi.Node;
import xyz.quaver.hitomi.SearchKt;
import xyz.quaver.hitomi.Suggestion;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000L\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\"\n\u0002\b\u000b\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\u001a9\u0010\u0011\u001a\u0010\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u00122\u0006\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b\u0019\u0010\u001a\u001a\u000e\u0010\u001b\u001a\u00020\u00182\u0006\u0010\u001c\u001a\u00020\u001d\u001a\u0014\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00010\u001f2\u0006\u0010 \u001a\u00020\u0003\u001a \u0010!\u001a\b\u0012\u0004\u0012\u00020\u00010\u001f2\u0012\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00010\u0012\u001a&\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00010\u001f2\b\u0010#\u001a\u0004\u0018\u00010\u00032\u0006\u0010$\u001a\u00020\u00032\u0006\u0010%\u001a\u00020\u0003\u001a\u000e\u0010&\u001a\u00020\u00032\u0006\u0010'\u001a\u00020\u0003\u001a\u0018\u0010(\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0014\u001a\u00020\u00032\u0006\u0010)\u001a\u00020\u0013\u001a\u0014\u0010*\u001a\b\u0012\u0004\u0012\u00020,0+2\u0006\u0010 \u001a\u00020\u0003\u001a(\u0010-\u001a\b\u0012\u0004\u0012\u00020,0+2\u0006\u0010\u0014\u001a\u00020\u00032\u0012\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00010\u0012\u001a\u0016\u0010.\u001a\u00020\u001d2\u0006\u0010/\u001a\u00020\u00032\u0006\u00100\u001a\u000201\u001a\u0016\u00102\u001a\u00020\u00162\u0006\u00103\u001a\u00020\u0003\u00f8\u0001\u0000\u00a2\u0006\u0002\u00104\u001a\u000e\u00105\u001a\u00020\u00032\u0006\u00106\u001a\u00020\u0003\u001a\u000e\u00107\u001a\u00020\u001d2\u0006\u0010\u001c\u001a\u00020\u001d\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0003X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0003X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0003X\u0086T\u00a2\u0006\u0002\n\u0000\"\u001b\u0010\u0006\u001a\u00020\u00038FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\b\"\u000e\u0010\u000b\u001a\u00020\u0003X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\f\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\r\u001a\u00020\u0003X\u0086T\u00a2\u0006\u0002\n\u0000\"\u001b\u0010\u000e\u001a\u00020\u00038FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\n\u001a\u0004\b\u000f\u0010\b\u0082\u0002\u000b\n\u0002\b\u0019\n\u0005\b\u00a1\u001e0\u0001\u00a8\u00068"}, d2={"B", "", "compressed_nozomi_prefix", "", "extension", "galleries_index_dir", "galleries_index_version", "getGalleries_index_version", "()Ljava/lang/String;", "galleries_index_version$delegate", "Lkotlin/Lazy;", "index_dir", "max_node_size", "separator", "tag_index_version", "getTag_index_version", "tag_index_version$delegate", "bSearch", "Lkotlin/Pair;", "", "field", "key", "Lkotlin/UByteArray;", "node", "Lxyz/quaver/hitomi/Node;", "bSearch-Coi6ktg", "(Ljava/lang/String;[BLxyz/quaver/hitomi/Node;)Lkotlin/Pair;", "decodeNode", "data", "", "getGalleryIDsForQuery", "", "query", "getGalleryIDsFromData", "getGalleryIDsFromNozomi", "area", "tag", "language", "getIndexVersion", "name", "getNodeAtAddress", "address", "getSuggestionsForQuery", "", "Lxyz/quaver/hitomi/Suggestion;", "getSuggestionsFromData", "getURLAtRange", "url", "range", "Lkotlin/ranges/LongRange;", "hashTerm", "term", "(Ljava/lang/String;)[B", "sanitize", "input", "sha256", "libpupil"})
public final class SearchKt {
    @NotNull
    public static final String separator = "-";
    @NotNull
    public static final String extension = ".html";
    @NotNull
    public static final String index_dir = "tagindex";
    @NotNull
    public static final String galleries_index_dir = "galleriesindex";
    public static final int max_node_size = 464;
    public static final int B = 16;
    @NotNull
    public static final String compressed_nozomi_prefix = "n";
    @NotNull
    private static final Lazy tag_index_version$delegate = LazyKt.lazy((Function0)tag_index_version.2.INSTANCE);
    @NotNull
    private static final Lazy galleries_index_version$delegate = LazyKt.lazy((Function0)galleries_index_version.2.INSTANCE);

    @NotNull
    public static final String getTag_index_version() {
        Lazy lazy = tag_index_version$delegate;
        Object var1_1 = null;
        boolean bl = false;
        return (String)lazy.getValue();
    }

    @NotNull
    public static final String getGalleries_index_version() {
        Lazy lazy = galleries_index_version$delegate;
        Object var1_1 = null;
        boolean bl = false;
        return (String)lazy.getValue();
    }

    @NotNull
    public static final byte[] sha256(@NotNull byte[] data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        byte[] byArray = MessageDigest.getInstance("SHA-256").digest(data);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getInstance(\"SHA-256\").digest(data)");
        return byArray;
    }

    @NotNull
    public static final byte[] hashTerm(@NotNull String term) {
        Intrinsics.checkNotNullParameter((Object)term, (String)"term");
        Object object = term;
        Charset charset = Charsets.UTF_8;
        boolean bl = false;
        byte[] byArray = ((String)object).getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        object = SearchKt.sha256(byArray);
        boolean bl2 = false;
        Object object2 = object;
        boolean bl3 = false;
        byte[] byArray2 = Arrays.copyOf((byte[])object2, ((Object)object2).length);
        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"java.util.Arrays.copyOf(this, size)");
        return UArraysKt.sliceArray-c0bezYM((byte[])UByteArray.constructor-impl((byte[])byArray2), (IntRange)RangesKt.until((int)0, (int)4));
    }

    @NotNull
    public static final String sanitize(@NotNull String input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        CharSequence charSequence = input;
        Regex regex = new Regex("[/#]");
        String string = "";
        boolean bl = false;
        return regex.replace(charSequence, string);
    }

    @NotNull
    public static final String getIndexVersion(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return UtilsKt.readText$default(new URL("https://ltn.hitomi.la/" + name + "/version?_=" + System.currentTimeMillis()), null, 1, null);
    }

    @NotNull
    public static final Set<Integer> getGalleryIDsForQuery(@NotNull String query) {
        String it;
        block14: {
            Intrinsics.checkNotNullParameter((Object)query, (String)"query");
            String string = StringsKt.replace$default((String)query, (String)"_", (String)" ", (boolean)false, (int)4, null);
            boolean bl = false;
            boolean bl2 = false;
            it = string;
            boolean bl3 = false;
            if (StringsKt.indexOf$default((CharSequence)it, (char)':', (int)0, (boolean)false, (int)6, null) <= -1) break block14;
            String[] stringArray = new String[]{":"};
            List sides = StringsKt.split$default((CharSequence)it, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            String ns = (String)sides.get(0);
            String tag = (String)sides.get(1);
            String area = ns;
            String language2 = "all";
            switch (ns) {
                case "female": 
                case "male": {
                    area = "tag";
                    tag = it;
                    break;
                }
                case "language": {
                    area = null;
                    language2 = tag;
                    tag = "index";
                }
            }
            return SearchKt.getGalleryIDsFromNozomi(area, tag, language2);
        }
        byte[] key = SearchKt.hashTerm(it);
        String field = "galleries";
        Node area = SearchKt.getNodeAtAddress(field, 0L);
        if (area == null) {
            return SetsKt.emptySet();
        }
        Node node = area;
        Pair<Long, Integer> data = SearchKt.bSearch-Coi6ktg(field, key, node);
        if (data != null) {
            return SearchKt.getGalleryIDsFromData(data);
        }
        return SetsKt.emptySet();
    }

    @NotNull
    public static final List<Suggestion> getSuggestionsForQuery(@NotNull String query) {
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        String string = StringsKt.replace$default((String)query, (char)'_', (char)' ', (boolean)false, (int)4, null);
        boolean bl = false;
        boolean bl2 = false;
        String it = string;
        boolean bl3 = false;
        String field = "global";
        String term = it;
        if (StringsKt.indexOf$default((CharSequence)term, (char)':', (int)0, (boolean)false, (int)6, null) > -1) {
            char[] cArray = new char[]{':'};
            List sides = StringsKt.split$default((CharSequence)it, (char[])cArray, (boolean)false, (int)0, (int)6, null);
            field = (String)sides.get(0);
            term = (String)sides.get(1);
        }
        byte[] key = SearchKt.hashTerm(term);
        Node node = SearchKt.getNodeAtAddress(field, 0L);
        if (node == null) {
            return CollectionsKt.emptyList();
        }
        Node node2 = node;
        Pair<Long, Integer> data = SearchKt.bSearch-Coi6ktg(field, key, node2);
        if (data != null) {
            return SearchKt.getSuggestionsFromData(field, data);
        }
        return CollectionsKt.emptyList();
    }

    @NotNull
    public static final List<Suggestion> getSuggestionsFromData(@NotNull String field, @NotNull Pair<Long, Integer> data) {
        ArrayList<Suggestion> suggestions;
        block15: {
            Intrinsics.checkNotNullParameter((Object)field, (String)"field");
            Intrinsics.checkNotNullParameter(data, (String)"data");
            String url = "https://ltn.hitomi.la/tagindex/" + field + '.' + SearchKt.getTag_index_version() + ".data";
            Pair<Long, Integer> pair = data;
            long offset = ((Number)pair.component1()).longValue();
            int length = ((Number)pair.component2()).intValue();
            if (length > 10000 || length <= 0) {
                throw new Exception("length " + length + " is too long");
            }
            byte[] inbuf = SearchKt.getURLAtRange(url, RangesKt.until((long)offset, (long)(offset + (long)length)));
            suggestions = new ArrayList<Suggestion>();
            ByteBuffer buffer = ByteBuffer.wrap(inbuf).order(ByteOrder.BIG_ENDIAN);
            int numberOfSuggestions = buffer.getInt();
            if (numberOfSuggestions > 100 || numberOfSuggestions <= 0) {
                throw new Exception("number of suggestions " + numberOfSuggestions + " is too long");
            }
            int n = 0;
            if (n >= numberOfSuggestions) break block15;
            do {
                String string;
                int i = n++;
                int top = buffer.getInt();
                byte[] byArray = ArraysKt.sliceArray((byte[])inbuf, (IntRange)RangesKt.until((int)buffer.position(), (int)(buffer.position() + top)));
                Object object = "UTF-8";
                boolean bl = false;
                Charset charset = Charset.forName((String)object);
                Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"Charset.forName(charsetName)");
                object = charset;
                bl = false;
                boolean bl2 = false;
                String ns = new String(byArray, (Charset)object);
                buffer.position(buffer.position() + top);
                top = buffer.getInt();
                object = ArraysKt.sliceArray((byte[])inbuf, (IntRange)RangesKt.until((int)buffer.position(), (int)(buffer.position() + top)));
                Object object2 = "UTF-8";
                bl2 = false;
                Charset charset2 = Charset.forName((String)object2);
                Intrinsics.checkNotNullExpressionValue((Object)charset2, (String)"Charset.forName(charsetName)");
                object2 = charset2;
                bl2 = false;
                boolean bl3 = false;
                String tag = new String((byte[])object, (Charset)object2);
                buffer.position(buffer.position() + top);
                int count = buffer.getInt();
                String tagname = SearchKt.sanitize(tag);
                switch (ns) {
                    case "female": 
                    case "male": {
                        string = "/tag/" + ns + ':' + tagname + "-1.html";
                        break;
                    }
                    case "language": {
                        string = "/index-" + tagname + "-1.html";
                        break;
                    }
                    default: {
                        string = '/' + ns + '/' + tagname + "-all-1.html";
                    }
                }
                String u = string;
                suggestions.add(new Suggestion(tag, count, u, ns));
            } while (n < numberOfSuggestions);
        }
        return suggestions;
    }

    @NotNull
    public static final Set<Integer> getGalleryIDsFromNozomi(@Nullable String area, @NotNull String tag, @NotNull String language2) {
        byte[] byArray;
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)language2, (String)"language");
        String string = area;
        String nozomiAddress = string == null ? "https://ltn.hitomi.la/n/" + tag + '-' + language2 + ".nozomi" : "https://ltn.hitomi.la/n/" + area + '/' + tag + '-' + language2 + ".nozomi";
        try {
            byArray = UtilsKt.readBytes$default(new URL(nozomiAddress), null, 1, null);
        }
        catch (Exception e) {
            return SetsKt.emptySet();
        }
        byte[] bytes = byArray;
        boolean e = false;
        Set nozomi = new LinkedHashSet();
        ByteBuffer arrayBuffer = ByteBuffer.wrap(bytes).order(ByteOrder.BIG_ENDIAN);
        while (arrayBuffer.hasRemaining()) {
            nozomi.add(arrayBuffer.getInt());
        }
        return nozomi;
    }

    @NotNull
    public static final Set<Integer> getGalleryIDsFromData(@NotNull Pair<Long, Integer> data) {
        Intrinsics.checkNotNullParameter(data, (String)"data");
        String url = "https://ltn.hitomi.la/galleriesindex/galleries." + SearchKt.getGalleries_index_version() + ".data";
        Pair<Long, Integer> pair = data;
        long offset = ((Number)pair.component1()).longValue();
        int length = ((Number)pair.component2()).intValue();
        if (length > 100000000 || length <= 0) {
            throw new Exception("length " + length + " is too long");
        }
        byte[] inbuf = SearchKt.getURLAtRange(url, RangesKt.until((long)offset, (long)(offset + (long)length)));
        boolean bl = false;
        Set galleryIDs = new LinkedHashSet();
        ByteBuffer buffer = ByteBuffer.wrap(inbuf).order(ByteOrder.BIG_ENDIAN);
        int numberOfGalleryIDs = buffer.getInt();
        int expectedLength = numberOfGalleryIDs * 4 + 4;
        if (numberOfGalleryIDs > 10000000 || numberOfGalleryIDs <= 0) {
            throw new Exception("number_of_galleryids " + numberOfGalleryIDs + " is too long");
        }
        if (inbuf.length != expectedLength) {
            throw new Exception("inbuf.byteLength " + inbuf.length + " != expected_length " + expectedLength);
        }
        int n = 0;
        if (n < numberOfGalleryIDs) {
            do {
                int i = n++;
                galleryIDs.add(buffer.getInt());
            } while (n < numberOfGalleryIDs);
        }
        return galleryIDs;
    }

    @Nullable
    public static final Node getNodeAtAddress(@NotNull String field, long address) {
        String string;
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        switch (field) {
            case "galleries": {
                string = "https://ltn.hitomi.la/galleriesindex/galleries." + SearchKt.getGalleries_index_version() + ".index";
                break;
            }
            case "languages": {
                string = "https://ltn.hitomi.la/galleriesindex/languages." + SearchKt.getGalleries_index_version() + ".index";
                break;
            }
            case "nozomiurl": {
                string = "https://ltn.hitomi.la/galleriesindex/nozomiurl." + SearchKt.getGalleries_index_version() + ".index";
                break;
            }
            default: {
                string = "https://ltn.hitomi.la/tagindex/" + field + '.' + SearchKt.getTag_index_version() + ".index";
            }
        }
        String url = string;
        byte[] nodedata = SearchKt.getURLAtRange(url, RangesKt.until((long)address, (long)(address + (long)464)));
        return SearchKt.decodeNode(nodedata);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final byte[] getURLAtRange(@NotNull String url, @NotNull LongRange range) {
        byte[] byArray;
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        Request request = new Request.Builder().url(url).header("Range", "bytes=" + range.getFirst() + '-' + range.getLast()).build();
        ResponseBody responseBody = UtilsKt.getClient().newCall(request).execute().body();
        if (responseBody == null) {
            byArray = null;
        } else {
            Closeable closeable = (Closeable)responseBody;
            boolean bl = false;
            boolean bl2 = false;
            Throwable throwable = null;
            try {
                ResponseBody it = (ResponseBody)closeable;
                boolean bl3 = false;
                byte[] byArray2 = it.bytes();
                byArray = byArray2;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        byte[] byArray3 = byArray;
        return byArray3 == null ? new byte[]{} : byArray3;
    }

    @NotNull
    public static final Node decodeNode(@NotNull byte[] data) {
        int keySize;
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        ByteBuffer buffer = ByteBuffer.wrap(data).order(ByteOrder.BIG_ENDIAN);
        byte[] byArray = data;
        boolean bl = false;
        byte[] byArray2 = byArray;
        boolean bl2 = false;
        byte[] byArray3 = Arrays.copyOf(byArray2, byArray2.length);
        Intrinsics.checkNotNullExpressionValue((Object)byArray3, (String)"java.util.Arrays.copyOf(this, size)");
        byte[] uData = UByteArray.constructor-impl((byte[])byArray3);
        int numberOfKeys = buffer.getInt();
        ArrayList<UByteArray> keys = new ArrayList<UByteArray>();
        int n = 0;
        if (n < numberOfKeys) {
            do {
                int i = n++;
                keySize = buffer.getInt();
                if (keySize == 0 || keySize > 32) {
                    throw new Exception("fatal: !keySize || keySize > 32");
                }
                keys.add(UByteArray.box-impl((byte[])UArraysKt.sliceArray-c0bezYM((byte[])uData, (IntRange)RangesKt.until((int)buffer.position(), (int)(buffer.position() + keySize)))));
                buffer.position(buffer.position() + keySize);
            } while (n < numberOfKeys);
        }
        int numberOfDatas = buffer.getInt();
        ArrayList<Pair> datas = new ArrayList<Pair>();
        keySize = 0;
        if (keySize < numberOfDatas) {
            do {
                int i = keySize++;
                long offset = buffer.getLong();
                int length = buffer.getInt();
                datas.add(new Pair((Object)offset, (Object)length));
            } while (keySize < numberOfDatas);
        }
        int numberOfSubNodeAddresses = 17;
        ArrayList<Long> subNodeAddresses = new ArrayList<Long>();
        int n2 = 0;
        do {
            int i = n2++;
            long subNodeAddress = buffer.getLong();
            subNodeAddresses.add(subNodeAddress);
        } while (n2 < numberOfSubNodeAddresses);
        return new Node((List<UByteArray>)keys, (List<Pair<Long, Integer>>)datas, (List<Long>)subNodeAddresses);
    }

    @Nullable
    public static final Pair<Long, Integer> bSearch-Coi6ktg(@NotNull String field, @NotNull byte[] key, @NotNull Node node) {
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        if (node.getKeys().isEmpty()) {
            return null;
        }
        Pair<Boolean, Integer> pair = SearchKt.bSearch_Coi6ktg$locateKey_rto03Yo(key, node);
        boolean there = (Boolean)pair.component1();
        int where = ((Number)pair.component2()).intValue();
        if (there) {
            return node.getDatas().get(where);
        }
        if (SearchKt.bSearch_Coi6ktg$isLeaf(node)) {
            return null;
        }
        Node node2 = SearchKt.getNodeAtAddress(field, ((Number)node.getSubNodeAddresses().get(where)).longValue());
        if (node2 == null) {
            return null;
        }
        Node nextNode = node2;
        return SearchKt.bSearch-Coi6ktg(field, key, nextNode);
    }

    private static final int bSearch_Coi6ktg$compareArrayBuffers_uo5YlkA(byte[] dv1, byte[] dv2) {
        int n = 0;
        int top = Integer.min(UByteArray.getSize-impl((byte[])dv1), UByteArray.getSize-impl((byte[])dv2));
        if (n < top) {
            do {
                int i = n++;
                byte by = UByteArray.get-w2LRezQ((byte[])dv1, (int)i);
                byte by2 = UByteArray.get-w2LRezQ((byte[])dv2, (int)i);
                boolean bl = false;
                byte by3 = by;
                boolean bl2 = false;
                int n2 = by3 & 0xFF;
                by3 = by2;
                bl2 = false;
                if (Intrinsics.compare((int)n2, (int)(by3 & 0xFF)) < 0) {
                    return -1;
                }
                by = UByteArray.get-w2LRezQ((byte[])dv1, (int)i);
                by2 = UByteArray.get-w2LRezQ((byte[])dv2, (int)i);
                bl = false;
                by3 = by;
                bl2 = false;
                int n3 = by3 & 0xFF;
                by3 = by2;
                bl2 = false;
                if (Intrinsics.compare((int)n3, (int)(by3 & 0xFF)) <= 0) continue;
                return 1;
            } while (n < top);
        }
        return 0;
    }

    private static final Pair<Boolean, Integer> bSearch_Coi6ktg$locateKey_rto03Yo(byte[] key, Node node) {
        int n = 0;
        int n2 = node.getKeys().size() + -1;
        if (n <= n2) {
            do {
                int i = n++;
                int cmpResult = SearchKt.bSearch_Coi6ktg$compareArrayBuffers_uo5YlkA(key, node.getKeys().get(i).unbox-impl());
                if (cmpResult > 0) continue;
                return new Pair((Object)(cmpResult == 0 ? 1 : 0), (Object)i);
            } while (n <= n2);
        }
        return new Pair((Object)false, (Object)node.getKeys().size());
    }

    private static final boolean bSearch_Coi6ktg$isLeaf(Node node) {
        Iterator<Long> iterator = node.getSubNodeAddresses().iterator();
        while (iterator.hasNext()) {
            long subnode = ((Number)iterator.next()).longValue();
            if (subnode == 0L) continue;
            return false;
        }
        return true;
    }
}

