/*
 * Decompiled with CFR 0.152.
 */
package xyz.quaver.io.util;

import android.annotation.SuppressLint;
import android.content.Context;
import androidx.annotation.RequiresApi;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import kotlin.Metadata;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FileAlreadyExistsException;
import kotlin.io.FileSystemException;
import kotlin.io.FilesKt;
import kotlin.io.NoSuchFileException;
import kotlin.io.OnErrorAction;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import xyz.quaver.io.FileX;
import xyz.quaver.io.FileXKt;
import xyz.quaver.io.RawFileX;
import xyz.quaver.io.SAFileX;
import xyz.quaver.io.util.DocumentUtilKt;
import xyz.quaver.io.util.FileXReadWriteKt;
import xyz.quaver.io.util.FileXUtilKt;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u00002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\u001a8\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00022\b\b\u0002\u0010\u0004\u001a\u00020\u00012\u001a\b\u0002\u0010\u0005\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0006\u001a&\u0010\n\u001a\u00020\u0002*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00022\b\b\u0002\u0010\u0004\u001a\u00020\u00012\b\b\u0002\u0010\u000b\u001a\u00020\f\u001a\f\u0010\r\u001a\u00020\u0001*\u00020\u0002H\u0007\u001a\u001c\u0010\u000e\u001a\u00020\u0002*\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u00102\b\b\u0002\u0010\u0011\u001a\u00020\u0001\u001a\u001e\u0010\u0012\u001a\u00020\u0002*\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u00102\b\b\u0002\u0010\u0011\u001a\u00020\u0001H\u0007\u00a8\u0006\u0013"}, d2={"copyRecursively", "", "Lxyz/quaver/io/FileX;", "target", "overwrite", "onError", "Lkotlin/Function2;", "Ljava/io/File;", "Ljava/io/IOException;", "Lkotlin/io/OnErrorAction;", "copyTo", "bufferSize", "", "deleteRecursively", "getChild", "fileName", "", "cached", "getNeighbor", "library_release"})
public final class FileXUtilKt {
    @NotNull
    public static final FileX getChild(@NotNull FileX $this$getChild, @NotNull String fileName, boolean cached) {
        Intrinsics.checkNotNullParameter((Object)$this$getChild, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        return FileXKt.FileX($this$getChild.getContext$library_release(), $this$getChild, fileName, cached);
    }

    public static /* synthetic */ FileX getChild$default(FileX fileX, String string, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return FileXUtilKt.getChild(fileX, string, bl);
    }

    @RequiresApi(value=21)
    @NotNull
    public static final FileX getNeighbor(@NotNull FileX $this$getNeighbor, @NotNull String fileName, boolean cached) {
        Intrinsics.checkNotNullParameter((Object)$this$getNeighbor, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        return FileXKt.FileX$default($this$getNeighbor.getContext$library_release(), DocumentUtilKt.getNeighborUri($this$getNeighbor.getUri(), fileName), null, cached, 4, null);
    }

    public static /* synthetic */ FileX getNeighbor$default(FileX fileX, String string, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return FileXUtilKt.getNeighbor(fileX, string, bl);
    }

    @SuppressLint(value={"NewApi"})
    public static final boolean deleteRecursively(@NotNull FileX $this$deleteRecursively) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$deleteRecursively, (String)"<this>");
        FileX fileX = $this$deleteRecursively;
        if (fileX instanceof SAFileX) {
            bl = DocumentUtilKt.delete($this$deleteRecursively.getUri(), $this$deleteRecursively.getContext$library_release());
        } else if (fileX instanceof RawFileX) {
            bl = FilesKt.deleteRecursively((File)new File(((RawFileX)$this$deleteRecursively).getPath()));
        } else {
            throw new UnsupportedOperationException();
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final FileX copyTo(@NotNull FileX $this$copyTo, @NotNull FileX target, boolean overwrite, int bufferSize) {
        Intrinsics.checkNotNullParameter((Object)$this$copyTo, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        if (!$this$copyTo.exists()) {
            throw new NoSuchFileException((File)$this$copyTo, null, "The source file doesn't exist", 2, null);
        }
        if (target.exists()) {
            if (!overwrite) {
                throw new FileAlreadyExistsException((File)$this$copyTo, (File)target, "The destination file already exists.");
            }
            if (!target.delete()) {
                throw new FileAlreadyExistsException((File)$this$copyTo, (File)target, "Tried to overwrite the destination, but failed to delete it.");
            }
        }
        if ($this$copyTo.isDirectory()) {
            if (!target.mkdirs()) {
                throw new FileSystemException((File)$this$copyTo, (File)target, "Failed to create target directory.");
            }
        } else {
            Object object = target.getParentFile();
            if (object != null) {
                ((File)object).mkdirs();
            }
            if (!target.exists()) {
                target.createNewFile();
            }
            object = FileXReadWriteKt.inputStream($this$copyTo);
            boolean bl = false;
            boolean bl2 = false;
            Throwable throwable = null;
            try {
                long l;
                FileInputStream input = (FileInputStream)object;
                boolean bl3 = false;
                Closeable closeable = input;
                if (closeable == null) {
                    throw new IOException(Intrinsics.stringPlus((String)"Failed to open inputStream of file ", (Object)$this$copyTo));
                }
                closeable = FileXReadWriteKt.outputStream$default(target, null, 1, null);
                boolean bl4 = false;
                boolean bl5 = false;
                Throwable throwable2 = null;
                try {
                    FileOutputStream output = (FileOutputStream)closeable;
                    boolean bl6 = false;
                    FileOutputStream fileOutputStream = output;
                    if (fileOutputStream == null) {
                        throw new IOException(Intrinsics.stringPlus((String)"Failed to open outputStream of file ", (Object)target));
                    }
                    output.getChannel().truncate(0L);
                    l = ByteStreamsKt.copyTo((InputStream)input, (OutputStream)output, (int)bufferSize);
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable2);
                }
                long l2 = l;
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
            }
        }
        return target;
    }

    public static /* synthetic */ FileX copyTo$default(FileX fileX, FileX fileX2, boolean bl, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            bl = false;
        }
        if ((n2 & 4) != 0) {
            n = 8192;
        }
        return FileXUtilKt.copyTo(fileX, fileX2, bl, n);
    }

    public static final boolean copyRecursively(@NotNull FileX $this$copyRecursively, @NotNull FileX target, boolean overwrite, @NotNull Function2<? super File, ? super IOException, ? extends OnErrorAction> onError) {
        Intrinsics.checkNotNullParameter((Object)$this$copyRecursively, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Intrinsics.checkNotNullParameter(onError, (String)"onError");
        if ($this$copyRecursively instanceof RawFileX && target instanceof RawFileX) {
            return FilesKt.copyRecursively((File)new File(((RawFileX)$this$copyRecursively).getPath()), (File)target, (boolean)overwrite, onError);
        }
        if (!$this$copyRecursively.exists()) {
            return onError.invoke((Object)$this$copyRecursively, (Object)new NoSuchFileException((File)$this$copyRecursively, null, "The source file doesn't exist.", 2, null)) != OnErrorAction.TERMINATE;
        }
        if (target.exists() && !target.isDirectory()) {
            throw new IOException("Target is not a folder");
        }
        target.mkdirs();
        File[] fileArray = $this$copyRecursively.listFiles();
        if (fileArray == null) {
            return false;
        }
        File[] fileArray2 = fileArray;
        int n = 0;
        int n2 = fileArray2.length;
        while (n < n2) {
            File src = fileArray2[n];
            ++n;
            Context context = $this$copyRecursively.getContext$library_release();
            Intrinsics.checkNotNullExpressionValue((Object)src, (String)"src");
            FileX src2 = FileXKt.FileX$default(context, src, null, false, 12, null);
            if (!src2.exists() && onError.invoke((Object)src2, (Object)new NoSuchFileException((File)src2, null, "The source file doesn't exist.", 2, null)) == OnErrorAction.TERMINATE) {
                return false;
            }
            FileX dstFile = FileXKt.FileX$default($this$copyRecursively.getContext$library_release(), target, src2.getName(), false, 8, null);
            if (!(!dstFile.exists() || src2.isDirectory() && dstFile.isDirectory())) {
                boolean stillExists;
                boolean bl = !overwrite ? true : (stillExists = !FileXUtilKt.deleteRecursively(dstFile));
                if (stillExists) {
                    if (onError.invoke((Object)dstFile, (Object)new FileAlreadyExistsException((File)src2, (File)dstFile, "The destination file already exists.")) != OnErrorAction.TERMINATE) continue;
                    return false;
                }
            }
            if (src2.isDirectory()) {
                dstFile.mkdirs();
                if (FileXUtilKt.copyRecursively(src2, dstFile, overwrite, onError)) continue;
                return false;
            }
            if (FileXUtilKt.copyTo$default(src2, dstFile, overwrite, 0, 4, null).length() == src2.length() || onError.invoke((Object)src2, (Object)new IOException("Source file wasn't copied completely, length of destination file differs.")) != OnErrorAction.TERMINATE) continue;
            return false;
        }
        return true;
    }

    public static /* synthetic */ boolean copyRecursively$default(FileX fileX, FileX fileX2, boolean bl, Function2 function2, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 4) != 0) {
            function2 = copyRecursively.1.INSTANCE;
        }
        return FileXUtilKt.copyRecursively(fileX, fileX2, bl, (Function2<? super File, ? super IOException, ? extends OnErrorAction>)function2);
    }
}

