/*
 * Decompiled with CFR 0.152.
 */
package xyz.pinaki.android.wheelticker;

import android.animation.ObjectAnimator;
import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.ScrollView;
import android.widget.TextView;

class VerticalSpinner
extends ScrollView {
    private static final int SPIN_ANIMATION_TIME_MILLISEC = 1000;
    private static final int DEFAULT_TEXT_SIZE_DP = 30;
    private int itemHeight = 0;
    private int currentIndex = 0;
    private int textSize = 30;
    private LinearLayout textViewList;

    public VerticalSpinner(Context context, String[] items, int textSize) {
        super(context);
        this.init(context, items, textSize);
    }

    public VerticalSpinner(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, null, 30);
    }

    public VerticalSpinner(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init(context, null, 30);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        this.setMeasuredDimension(this.getMeasuredWidth(), this.itemHeight);
    }

    private void init(Context context, String[] items, int textSize) {
        this.textSize = textSize;
        this.setVerticalScrollBarEnabled(false);
        this.textViewList = new LinearLayout(context);
        this.textViewList.setOrientation(1);
        this.textViewList.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        this.addView((View)this.textViewList);
        this.addItems(items, context);
    }

    private void addItems(String[] items, Context context) {
        for (String item : items) {
            this.textViewList.addView((View)this.createView(item, context));
        }
        this.smoothScrollTo(0, 0);
    }

    private TextView createView(String item, Context context) {
        TextView textView = new TextView(context);
        textView.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-2, -2));
        textView.setSingleLine(true);
        textView.setTextSize(1, (float)this.textSize);
        textView.setText((CharSequence)item);
        textView.setGravity(17);
        if (this.itemHeight == 0) {
            this.itemHeight = this.getViewMeasuredHeight((View)textView);
        }
        return textView;
    }

    private int getViewMeasuredHeight(View view) {
        int width = View.MeasureSpec.makeMeasureSpec((int)0, (int)0);
        int expandSpec = View.MeasureSpec.makeMeasureSpec((int)0x1FFFFFFF, (int)Integer.MIN_VALUE);
        view.measure(width, expandSpec);
        return view.getMeasuredHeight();
    }

    public void spinToIndex(int newIndex) {
        int delta = newIndex - this.currentIndex;
        ObjectAnimator objectAnimator = ObjectAnimator.ofInt((Object)((Object)this), (String)"scrollY", (int[])new int[]{this.getScrollY() + delta * this.itemHeight});
        objectAnimator.setDuration(1000L);
        objectAnimator.start();
        this.currentIndex = newIndex;
    }

    public String getCurrentText() {
        TextView tv = (TextView)this.textViewList.getChildAt(this.currentIndex);
        return tv.getText().toString();
    }
}

