/*
 * Decompiled with CFR 0.152.
 */
package xyz.pinaki.android.wheelticker;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.View;
import android.widget.TableLayout;
import android.widget.TableRow;
import xyz.pinaki.android.wheelticker.NumberSpinner;
import xyz.pinaki.android.wheelticker.R;

public class Odometer
extends TableLayout {
    private static final int DEFAULT_DIGIT_SIZE_DP = 30;
    private static final int DEFAULT_NUM_DIGITS = 2;
    private NumberSpinner num1;
    private NumberSpinner num10;
    private NumberSpinner num100;
    private NumberSpinner num1K;
    private NumberSpinner num10K;
    private NumberSpinner num100K;
    private NumberSpinner num1M;
    private int numDigits = 2;
    private int digitSize = 30;
    private int currentValue = 0;

    public Odometer(Context context, int numberSize) {
        super(context);
        this.digitSize = numberSize;
        this.init(context);
    }

    public Odometer(Context context) {
        this(context, 30);
    }

    public Odometer(Context context, AttributeSet attrs) {
        super(context, attrs);
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.Odometer);
        this.numDigits = typedArray.getInteger(R.styleable.Odometer_num_digits, 2);
        this.digitSize = typedArray.getInteger(R.styleable.Odometer_digit_size, 30);
        typedArray.recycle();
        this.init(context);
    }

    private void init(Context context) {
        TableRow tableRow = new TableRow(context);
        tableRow.setGravity(17);
        this.num1M = new NumberSpinner(context, this.digitSize);
        this.num100K = new NumberSpinner(context, this.digitSize);
        this.num10K = new NumberSpinner(context, this.digitSize);
        this.num1K = new NumberSpinner(context, this.digitSize);
        this.num100 = new NumberSpinner(context, this.digitSize);
        this.num10 = new NumberSpinner(context, this.digitSize);
        this.num1 = new NumberSpinner(context, this.digitSize);
        if (this.numDigits >= 7) {
            tableRow.addView((View)this.num1M);
        }
        if (this.numDigits >= 6) {
            tableRow.addView((View)this.num100K);
        }
        if (this.numDigits >= 5) {
            tableRow.addView((View)this.num10K);
        }
        if (this.numDigits >= 4) {
            tableRow.addView((View)this.num1K);
        }
        if (this.numDigits >= 3) {
            tableRow.addView((View)this.num100);
        }
        if (this.numDigits >= 2) {
            tableRow.addView((View)this.num10);
        }
        tableRow.addView((View)this.num1);
        this.num1M.setAlpha(0.0f);
        this.num100K.setAlpha(0.0f);
        this.num10K.setAlpha(0.0f);
        this.num1K.setAlpha(0.0f);
        this.num100.setAlpha(0.0f);
        this.num10.setAlpha(0.0f);
        this.setGravity(17);
        this.addView((View)tableRow);
    }

    public void spinTo(int num) {
        if (num < 0 || (double)num >= 1.0E7) {
            throw new RuntimeException("Num should be within 0 and 10M: " + num);
        }
        this.makeRelevantDigitsVisible(num);
        int dividend = num;
        this.num1.spinTo(dividend % 10);
        this.num10.spinTo((dividend /= 10) % 10);
        this.num100.spinTo((dividend /= 10) % 10);
        this.num1K.spinTo((dividend /= 10) % 10);
        this.num10K.spinTo((dividend /= 10) % 10);
        this.num100K.spinTo((dividend /= 10) % 10);
        this.num1M.spinTo((dividend /= 10) % 10);
        this.animateHigherOrderZeroesToInvisible(num);
        this.currentValue = num;
    }

    private void makeRelevantDigitsVisible(int num) {
        if (num >= 1000000) {
            this.num1M.setAlpha(1.0f);
        }
        if (num >= 100000) {
            this.num100K.setAlpha(1.0f);
        }
        if (num >= 10000) {
            this.num10K.setAlpha(1.0f);
        }
        if (num >= 1000) {
            this.num1K.setAlpha(1.0f);
        }
        if (num >= 100) {
            this.num100.setAlpha(1.0f);
        }
        if (num >= 10) {
            this.num10.setAlpha(1.0f);
        }
    }

    private void animateHigherOrderZeroesToInvisible(int num) {
        if (num < 1000000 && (double)this.num1M.getAlpha() > 0.0) {
            Odometer.animateToInvisible((View)this.num1M);
        }
        if (num < 100000 && (double)this.num100K.getAlpha() > 0.0) {
            Odometer.animateToInvisible((View)this.num100K);
        }
        if (num < 10000 && (double)this.num10K.getAlpha() > 0.0) {
            Odometer.animateToInvisible((View)this.num10K);
        }
        if (num < 1000 && (double)this.num1K.getAlpha() > 0.0) {
            Odometer.animateToInvisible((View)this.num1K);
        }
        if (num < 100 && (double)this.num100.getAlpha() > 0.0) {
            Odometer.animateToInvisible((View)this.num100);
        }
        if (num < 10 && (double)this.num10.getAlpha() > 0.0) {
            Odometer.animateToInvisible((View)this.num10);
        }
    }

    private static void animateToInvisible(View view) {
        view.setAlpha(0.0f);
    }

    public int getCurrentValue() {
        return this.currentValue;
    }
}

