/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.reflectionremapper.internal.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UncheckedIOException;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.function.UnaryOperator;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.framework.qual.DefaultQualifier;
import xyz.jpenilla.reflectionremapper.proxy.annotation.Proxies;

@DefaultQualifier(value=NonNull.class)
public final class Util {
    private static final @Nullable Method PRIVATE_LOOKUP_IN = Util.findMethod(MethodHandles.class, "privateLookupIn", Class.class, MethodHandles.Lookup.class);
    private static final @Nullable Method DESCRIPTOR_STRING = Util.findMethod(Class.class, "descriptorString", new Class[0]);

    private Util() {
    }

    public static boolean mojangMapped() {
        return Util.classExists("net.minecraft.server.level.ServerPlayer");
    }

    public static boolean classExists(String className) {
        try {
            Class.forName(className);
            return true;
        }
        catch (ClassNotFoundException ex) {
            return false;
        }
    }

    public static <E extends Throwable> E sneakyThrow(Throwable ex) throws E {
        throw ex;
    }

    public static <T> T sneakyThrows(ThrowingSupplier<T> supplier) {
        try {
            return supplier.get();
        }
        catch (Throwable ex) {
            throw (RuntimeException)Util.sneakyThrow(ex);
        }
    }

    public static boolean isSynthetic(int modifiers) {
        return (modifiers & 0x1000) != 0;
    }

    public static Class<?> findProxiedClass(Class<?> proxyInterface, UnaryOperator<String> classMapper) {
        if (!proxyInterface.isInterface()) {
            throw new IllegalArgumentException(proxyInterface.getTypeName() + " is not an interface annotated with @Proxies.");
        }
        @Nullable Proxies proxies = proxyInterface.getDeclaredAnnotation(Proxies.class);
        if (proxies == null) {
            throw new IllegalArgumentException("interface " + proxyInterface.getTypeName() + " is not annotated with @Proxies.");
        }
        if (proxies.value() == Object.class && proxies.className().isEmpty()) {
            throw new IllegalArgumentException("@Proxies annotation must either have value() or className() set. Interface: " + proxyInterface.getTypeName());
        }
        if (proxies.value() != Object.class) {
            return proxies.value();
        }
        try {
            return Class.forName((String)classMapper.apply(proxies.className()));
        }
        catch (ClassNotFoundException ex) {
            throw new IllegalArgumentException("Could not find class for @Proxied className() " + proxies.className() + ".");
        }
    }

    private static @Nullable Method findMethod(Class<?> holder, String name, Class<?> ... paramTypes) {
        try {
            return holder.getDeclaredMethod(name, paramTypes);
        }
        catch (ReflectiveOperationException ex) {
            return null;
        }
    }

    public static MethodHandle handleForDefaultMethod(Class<?> interfaceClass, Method method) throws Throwable {
        if (PRIVATE_LOOKUP_IN == null) {
            Constructor constructor = MethodHandles.Lookup.class.getDeclaredConstructor(Class.class);
            constructor.setAccessible(true);
            return ((MethodHandles.Lookup)constructor.newInstance(interfaceClass)).in(interfaceClass).unreflectSpecial(method, interfaceClass);
        }
        return ((MethodHandles.Lookup)PRIVATE_LOOKUP_IN.invoke(null, interfaceClass, MethodHandles.lookup())).findSpecial(interfaceClass, method.getName(), MethodType.methodType(method.getReturnType(), method.getParameterTypes()), interfaceClass);
    }

    public static List<Class<?>> topDownInterfaceHierarchy(Class<?> cls) {
        if (!cls.isInterface()) {
            throw new IllegalStateException("Expected an interface, got " + cls);
        }
        LinkedHashSet set = new LinkedHashSet();
        set.add(cls);
        Util.interfaces(cls, set);
        ArrayList list = new ArrayList(set);
        Collections.reverse(list);
        return Collections.unmodifiableList(list);
    }

    private static void interfaces(Class<?> cls, Collection<Class<?>> list) {
        for (Class<?> iface : cls.getInterfaces()) {
            list.add(iface);
            Util.interfaces(iface, list);
        }
    }

    public static String descriptorString(Class<?> clazz) {
        if (DESCRIPTOR_STRING != null) {
            try {
                return (String)DESCRIPTOR_STRING.invoke(clazz, new Object[0]);
            }
            catch (ReflectiveOperationException ex) {
                throw new RuntimeException("Failed to call Class#descriptorString", ex);
            }
        }
        if (clazz == Long.TYPE) {
            return "J";
        }
        if (clazz == Integer.TYPE) {
            return "I";
        }
        if (clazz == Character.TYPE) {
            return "C";
        }
        if (clazz == Short.TYPE) {
            return "S";
        }
        if (clazz == Byte.TYPE) {
            return "B";
        }
        if (clazz == Double.TYPE) {
            return "D";
        }
        if (clazz == Float.TYPE) {
            return "F";
        }
        if (clazz == Boolean.TYPE) {
            return "Z";
        }
        if (clazz == Void.TYPE) {
            return "V";
        }
        if (clazz.isArray()) {
            return "[" + Util.descriptorString(clazz.getComponentType());
        }
        return 'L' + clazz.getName().replace('.', '/') + ';';
    }

    public static String firstLine(InputStream mappings) {
        try {
            mappings.mark(1024);
            BufferedReader reader = new BufferedReader(new InputStreamReader(mappings, StandardCharsets.UTF_8));
            String line = reader.readLine();
            mappings.reset();
            return line;
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to read first line of input stream", e);
        }
    }

    @FunctionalInterface
    public static interface ThrowingSupplier<T> {
        public T get() throws Throwable;
    }
}

