/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.reflectionremapper.proxy;

import java.lang.reflect.Proxy;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.framework.qual.DefaultQualifier;
import xyz.jpenilla.reflectionremapper.ReflectionRemapper;
import xyz.jpenilla.reflectionremapper.proxy.ReflectionProxyInvocationHandler;

@DefaultQualifier(value=NonNull.class)
public final class ReflectionProxyFactory {
    private final ReflectionRemapper reflectionRemapper;
    private final ClassLoader classLoader;

    private ReflectionProxyFactory(ReflectionRemapper reflectionRemapper, ClassLoader classLoader) {
        this.reflectionRemapper = reflectionRemapper;
        this.classLoader = classLoader;
    }

    public <I> I reflectionProxy(Class<I> proxyInterface) {
        return (I)Proxy.newProxyInstance(this.classLoader, new Class[]{proxyInterface}, new ReflectionProxyInvocationHandler<I>(proxyInterface, this.reflectionRemapper));
    }

    public static ReflectionProxyFactory create(ReflectionRemapper reflectionRemapper, ClassLoader classLoader) {
        return new ReflectionProxyFactory(reflectionRemapper, classLoader);
    }
}

