/*
 * Decompiled with CFR 0.152.
 */
package xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.wallet.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;

@Schema(description="User Fee Delegation contract execution request schema")
public class FDUserContractExecutionTransactionRequest {
    @SerializedName(value="from")
    private String from = null;
    @SerializedName(value="value")
    private String value = null;
    @SerializedName(value="to")
    private String to = null;
    @SerializedName(value="input")
    private String input = null;
    @SerializedName(value="nonce")
    private Long nonce = null;
    @SerializedName(value="gas")
    private Long gas = 100000L;
    @SerializedName(value="submit")
    private Boolean submit = null;
    @SerializedName(value="feePayer")
    private String feePayer = null;
    @SerializedName(value="feeRatio")
    private Long feeRatio = null;

    public FDUserContractExecutionTransactionRequest from(String from) {
        this.from = from;
        return this;
    }

    @Schema(example="552714228230442729489415054454372803633806727088", required=true, description="Klaytn transaction address to send transaction")
    public String getFrom() {
        return this.from;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public FDUserContractExecutionTransactionRequest value(String value) {
        this.value = value;
        return this;
    }

    @Schema(example="0", description="KLAY converted into PEB")
    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public FDUserContractExecutionTransactionRequest to(String to) {
        this.to = to;
        return this;
    }

    @Schema(example="83007404990358537451688933974741230887684232817", required=true, description="Contract address")
    public String getTo() {
        return this.to;
    }

    public void setTo(String to) {
        this.to = to;
    }

    public FDUserContractExecutionTransactionRequest input(String input) {
        this.input = input;
        return this;
    }

    @Schema(example="291", required=true, description="Data that is sent along with the transaction and is used for execution.")
    public String getInput() {
        return this.input;
    }

    public void setInput(String input) {
        this.input = input;
    }

    public FDUserContractExecutionTransactionRequest nonce(Long nonce) {
        this.nonce = nonce;
        return this;
    }

    @Schema(example="0", description="Unique identifier for the transactions being sent (By entering 0, the nonce will be automatically determined)")
    public Long getNonce() {
        return this.nonce;
    }

    public void setNonce(Long nonce) {
        this.nonce = nonce;
    }

    public FDUserContractExecutionTransactionRequest gas(Long gas) {
        this.gas = gas;
        return this;
    }

    @Schema(example="0", description="Maximum gas fee to be used for sending the transaction (By entering 0, it will be set to default value)")
    public Long getGas() {
        return this.gas;
    }

    public void setGas(Long gas) {
        this.gas = gas;
    }

    public FDUserContractExecutionTransactionRequest submit(Boolean submit) {
        this.submit = submit;
        return this;
    }

    @Schema(example="true", description="Shows whether to send the transaction to Klaytn")
    public Boolean isSubmit() {
        return this.submit;
    }

    public void setSubmit(Boolean submit) {
        this.submit = submit;
    }

    public FDUserContractExecutionTransactionRequest feePayer(String feePayer) {
        this.feePayer = feePayer;
        return this;
    }

    @Schema(example="415487481437216765516808935831180170585317837885", required=true, description="Account address for user fee delegation")
    public String getFeePayer() {
        return this.feePayer;
    }

    public void setFeePayer(String feePayer) {
        this.feePayer = feePayer;
    }

    public FDUserContractExecutionTransactionRequest feeRatio(Long feeRatio) {
        this.feeRatio = feeRatio;
        return this;
    }

    @Schema(example="20", description="The ratio of the gas fee to be delegated. When it's empty or 0, the entire fee will be delegated.")
    public Long getFeeRatio() {
        return this.feeRatio;
    }

    public void setFeeRatio(Long feeRatio) {
        this.feeRatio = feeRatio;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FDUserContractExecutionTransactionRequest fdUserContractExecutionTransactionRequest = (FDUserContractExecutionTransactionRequest)o;
        return Objects.equals(this.from, fdUserContractExecutionTransactionRequest.from) && Objects.equals(this.value, fdUserContractExecutionTransactionRequest.value) && Objects.equals(this.to, fdUserContractExecutionTransactionRequest.to) && Objects.equals(this.input, fdUserContractExecutionTransactionRequest.input) && Objects.equals(this.nonce, fdUserContractExecutionTransactionRequest.nonce) && Objects.equals(this.gas, fdUserContractExecutionTransactionRequest.gas) && Objects.equals(this.submit, fdUserContractExecutionTransactionRequest.submit) && Objects.equals(this.feePayer, fdUserContractExecutionTransactionRequest.feePayer) && Objects.equals(this.feeRatio, fdUserContractExecutionTransactionRequest.feeRatio);
    }

    public int hashCode() {
        return Objects.hash(this.from, this.value, this.to, this.input, this.nonce, this.gas, this.submit, this.feePayer, this.feeRatio);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FDUserContractExecutionTransactionRequest {\n");
        sb.append("    from: ").append(this.toIndentedString(this.from)).append("\n");
        sb.append("    value: ").append(this.toIndentedString(this.value)).append("\n");
        sb.append("    to: ").append(this.toIndentedString(this.to)).append("\n");
        sb.append("    input: ").append(this.toIndentedString(this.input)).append("\n");
        sb.append("    nonce: ").append(this.toIndentedString(this.nonce)).append("\n");
        sb.append("    gas: ").append(this.toIndentedString(this.gas)).append("\n");
        sb.append("    submit: ").append(this.toIndentedString(this.submit)).append("\n");
        sb.append("    feePayer: ").append(this.toIndentedString(this.feePayer)).append("\n");
        sb.append("    feeRatio: ").append(this.toIndentedString(this.feeRatio)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

