/*
 * Decompiled with CFR 0.152.
 */
package xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.wallet.api;

import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.ApiCallback;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.ApiClient;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.ApiException;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.ApiResponse;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.Configuration;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.Pair;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.ProgressRequestBody;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.ProgressResponseBody;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.wallet.model.FDTransactionWithCurrencyResult;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.wallet.model.FDTransactionWithCurrencyResultList;

public class TxHistoryApi {
    private ApiClient apiClient;

    public TxHistoryApi() {
        this(Configuration.getDefaultApiClient());
    }

    public TxHistoryApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call getV2HistoryFdTxCall(String xChainId, String from, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/v2/history/fd/tx";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (from != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("from", from));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xChainId != null) {
            localVarHeaderParams.put("x-chain-id", this.apiClient.parameterToString(xChainId));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"basic"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getV2HistoryFdTxValidateBeforeCall(String xChainId, String from, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (xChainId == null) {
            throw new ApiException("Missing the required parameter 'xChainId' when calling getV2HistoryFdTx(Async)");
        }
        Call call = this.getV2HistoryFdTxCall(xChainId, from, progressListener, progressRequestListener);
        return call;
    }

    public FDTransactionWithCurrencyResultList getV2HistoryFdTx(String xChainId, String from) throws ApiException {
        ApiResponse<FDTransactionWithCurrencyResultList> resp = this.getV2HistoryFdTxWithHttpInfo(xChainId, from);
        return resp.getData();
    }

    public ApiResponse<FDTransactionWithCurrencyResultList> getV2HistoryFdTxWithHttpInfo(String xChainId, String from) throws ApiException {
        Call call = this.getV2HistoryFdTxValidateBeforeCall(xChainId, from, null, null);
        Type localVarReturnType = new TypeToken<FDTransactionWithCurrencyResultList>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getV2HistoryFdTxAsync(String xChainId, String from, final ApiCallback<FDTransactionWithCurrencyResultList> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getV2HistoryFdTxValidateBeforeCall(xChainId, from, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<FDTransactionWithCurrencyResultList>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getV2HistoryFdTxTransactionHashCall(String transactionHash, String xChainId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/v2/history/fd/tx/{transaction-hash}".replaceAll("\\{transaction-hash\\}", this.apiClient.escapeString(transactionHash.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xChainId != null) {
            localVarHeaderParams.put("x-chain-id", this.apiClient.parameterToString(xChainId));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"basic"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getV2HistoryFdTxTransactionHashValidateBeforeCall(String transactionHash, String xChainId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (transactionHash == null) {
            throw new ApiException("Missing the required parameter 'transactionHash' when calling getV2HistoryFdTxTransactionHash(Async)");
        }
        if (xChainId == null) {
            throw new ApiException("Missing the required parameter 'xChainId' when calling getV2HistoryFdTxTransactionHash(Async)");
        }
        Call call = this.getV2HistoryFdTxTransactionHashCall(transactionHash, xChainId, progressListener, progressRequestListener);
        return call;
    }

    public FDTransactionWithCurrencyResult getV2HistoryFdTxTransactionHash(String transactionHash, String xChainId) throws ApiException {
        ApiResponse<FDTransactionWithCurrencyResult> resp = this.getV2HistoryFdTxTransactionHashWithHttpInfo(transactionHash, xChainId);
        return resp.getData();
    }

    public ApiResponse<FDTransactionWithCurrencyResult> getV2HistoryFdTxTransactionHashWithHttpInfo(String transactionHash, String xChainId) throws ApiException {
        Call call = this.getV2HistoryFdTxTransactionHashValidateBeforeCall(transactionHash, xChainId, null, null);
        Type localVarReturnType = new TypeToken<FDTransactionWithCurrencyResult>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getV2HistoryFdTxTransactionHashAsync(String transactionHash, String xChainId, final ApiCallback<FDTransactionWithCurrencyResult> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getV2HistoryFdTxTransactionHashValidateBeforeCall(transactionHash, xChainId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<FDTransactionWithCurrencyResult>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

