/*
 * Decompiled with CFR 0.152.
 */
package xyz.groundx.caver_ext_kas.kas.wallet;

import java.security.InvalidParameterException;
import xyz.groundx.caver_ext_kas.kas.tokenhistory.TokenHistoryQueryOptions;
import xyz.groundx.caver_ext_kas.kas.utils.KASUtils;

public class WalletQueryOptions {
    Long size;
    String cursor;
    Long fromTimestamp;
    Long toTimestamp;
    String status;

    public WalletQueryOptions() {
    }

    public WalletQueryOptions(Long size, String cursor, Long fromTimestamp, Long toTimestamp) {
        this.size = size;
        this.cursor = cursor;
        this.fromTimestamp = fromTimestamp;
        this.toTimestamp = toTimestamp;
    }

    public Long getSize() {
        return this.size;
    }

    public String getCursor() {
        return this.cursor;
    }

    public Long getFromTimestamp() {
        return this.fromTimestamp;
    }

    public Long getToTimestamp() {
        return this.toTimestamp;
    }

    public String getStatus() {
        return this.status;
    }

    public void setSize(Long size) {
        this.size = size;
    }

    public void setCursor(String cursor) {
        this.cursor = cursor;
    }

    public void setFromTimestamp(String fromDate) {
        long date = Long.parseLong(KASUtils.convertDateToTimestamp(fromDate));
        this.setFromTimestamp(date);
    }

    public void setFromTimestamp(Long fromTimestamp) {
        this.fromTimestamp = fromTimestamp;
    }

    public void setToTimestamp(String toDate) {
        long date = Long.parseLong(KASUtils.convertDateToTimestamp(toDate));
        this.setToTimestamp(date);
    }

    public void setToTimestamp(Long toTimestamp) {
        this.toTimestamp = toTimestamp;
    }

    public void setStatus(String status) {
        if (!ACCOUNT_STATUS.isExist(status)) {
            throw new InvalidParameterException("The status parameter have one of the following: [" + ACCOUNT_STATUS.getAllStatus() + "]");
        }
        this.status = status;
    }

    public void setStatus(ACCOUNT_STATUS status) {
        this.status = status.getStatus();
    }

    static enum ACCOUNT_STATUS {
        ALL("all"),
        ENABLED("enabled"),
        DISABLE("disable"),
        CORRUPTED("corrupted");

        String status;

        private ACCOUNT_STATUS(String status) {
            this.status = status;
        }

        public static boolean isExist(String status) {
            for (ACCOUNT_STATUS labelStatus : ACCOUNT_STATUS.values()) {
                if (!labelStatus.getStatus().equals(status)) continue;
                return true;
            }
            return false;
        }

        public static String getAllStatus() {
            String result = "";
            for (int i = 0; i < ACCOUNT_STATUS.values().length; ++i) {
                ACCOUNT_STATUS status = ACCOUNT_STATUS.values()[i];
                result = result + "'" + status.getStatus() + "'";
                if (i == TokenHistoryQueryOptions.LABEL_STATUS.values().length - 1) continue;
                result = result + ", ";
            }
            return result;
        }

        public String getStatus() {
            return this.status;
        }
    }
}

