/*
 * Decompiled with CFR 0.152.
 */
package xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.wallet.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;

@Schema(description="RLP transaction request schema")
public class ProcessRLPRequest {
    @SerializedName(value="rlp")
    private String rlp = null;
    @SerializedName(value="submit")
    private Boolean submit = null;
    @SerializedName(value="from")
    private String from = null;

    public ProcessRLPRequest rlp(String rlp) {
        this.rlp = rlp;
        return this;
    }

    @Schema(example="0x28f901ac8205708505d21dba008389544080809460d0902c428d0e197f97a756011fd4893c1e57b0b9013a60806040526000805534801561001457600080fd5b50610116806100246000396000f3006080604052600436106053576000357c0100000000000000000000000000000000000000000000000000000000900463ffffffff16806306661abd14605857806342cbb15c146080578063d14e62b81460a8575b600080fd5b348015606357600080fd5b50606a60d2565b6040518082815260200191505060405180910390f35b348015608b57600080fd5b50609260d8565b6040518082815260200191505060405180910390f35b34801560b357600080fd5b5060d06004803603810190808035906020019092919050505060e0565b005b60005481565b600043905090565b80600081905550505600a165627a7a7230582059344095f4f4ad6d1a407f2f20de3e3e65e8ead0c1aaf64728546db62db6f76f00298080f847f8458207f6a0504972c81de9c036b251fa1b56cc8c0872e61dcc97293d0ac4adeb677b8a05cea03c5c47a6a518f99a36b9ebd5e9c4d043d9953e23f1f6351832ed483ddc615644", required=true, description="The Klaytn RLP formats SigRLP or TxHashRLP are accepted as RLP values and only legacy and basic transactions are allowed.")
    public String getRlp() {
        return this.rlp;
    }

    public void setRlp(String rlp) {
        this.rlp = rlp;
    }

    public ProcessRLPRequest submit(Boolean submit) {
        this.submit = submit;
        return this;
    }

    @Schema(example="true", description="Shows whether to send the transaction to Klaytn")
    public Boolean isSubmit() {
        return this.submit;
    }

    public void setSubmit(Boolean submit) {
        this.submit = submit;
    }

    public ProcessRLPRequest from(String from) {
        this.from = from;
        return this;
    }

    @Schema(description="From Klaytn account address. This field is required only when sending legacy transaction")
    public String getFrom() {
        return this.from;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProcessRLPRequest processRLPRequest = (ProcessRLPRequest)o;
        return Objects.equals(this.rlp, processRLPRequest.rlp) && Objects.equals(this.submit, processRLPRequest.submit) && Objects.equals(this.from, processRLPRequest.from);
    }

    public int hashCode() {
        return Objects.hash(this.rlp, this.submit, this.from);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ProcessRLPRequest {\n");
        sb.append("    rlp: ").append(this.toIndentedString(this.rlp)).append("\n");
        sb.append("    submit: ").append(this.toIndentedString(this.submit)).append("\n");
        sb.append("    from: ").append(this.toIndentedString(this.from)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

