/*
 * Decompiled with CFR 0.152.
 */
package xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.wallet.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.wallet.model.MultisigAddress;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.wallet.model.TxData;

@Schema(description="Pending transaction")
public class PendedTransaction {
    @SerializedName(value="address")
    private String address = null;
    @SerializedName(value="chainId")
    private Long chainId = null;
    @SerializedName(value="createdAt")
    private Long createdAt = null;
    @SerializedName(value="multiSigKeys")
    private List<MultisigAddress> multiSigKeys = null;
    @SerializedName(value="status")
    private Long status = null;
    @SerializedName(value="threshold")
    private Long threshold = null;
    @SerializedName(value="transactionId")
    private String transactionId = null;
    @SerializedName(value="txData")
    private TxData txData = null;
    @SerializedName(value="type")
    private String type = null;
    @SerializedName(value="updatedAt")
    private Long updatedAt = null;

    public PendedTransaction address(String address) {
        this.address = address;
        return this;
    }

    @Schema(example="0x68311224a5d693E93B64E5B9b9935bAFa0a1B916", required=true, description="Multisig account or signer account")
    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public PendedTransaction chainId(Long chainId) {
        this.chainId = chainId;
        return this;
    }

    @Schema(example="1001", required=true, description="Klaytn Chain ID")
    public Long getChainId() {
        return this.chainId;
    }

    public void setChainId(Long chainId) {
        this.chainId = chainId;
    }

    public PendedTransaction createdAt(Long createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @Schema(example="1616131131", required=true, description="Transaction request time")
    public Long getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(Long createdAt) {
        this.createdAt = createdAt;
    }

    public PendedTransaction multiSigKeys(List<MultisigAddress> multiSigKeys) {
        this.multiSigKeys = multiSigKeys;
        return this;
    }

    public PendedTransaction addMultiSigKeysItem(MultisigAddress multiSigKeysItem) {
        if (this.multiSigKeys == null) {
            this.multiSigKeys = new ArrayList<MultisigAddress>();
        }
        this.multiSigKeys.add(multiSigKeysItem);
        return this;
    }

    @Schema(description="")
    public List<MultisigAddress> getMultiSigKeys() {
        return this.multiSigKeys;
    }

    public void setMultiSigKeys(List<MultisigAddress> multiSigKeys) {
        this.multiSigKeys = multiSigKeys;
    }

    public PendedTransaction status(Long status) {
        this.status = status;
        return this;
    }

    @Schema(example="2", required=true, description="Current status of transaction.")
    public Long getStatus() {
        return this.status;
    }

    public void setStatus(Long status) {
        this.status = status;
    }

    public PendedTransaction threshold(Long threshold) {
        this.threshold = threshold;
        return this;
    }

    @Schema(example="4", required=true, description="Threshold required for sending the transaction.")
    public Long getThreshold() {
        return this.threshold;
    }

    public void setThreshold(Long threshold) {
        this.threshold = threshold;
    }

    public PendedTransaction transactionId(String transactionId) {
        this.transactionId = transactionId;
        return this;
    }

    @Schema(example="0xdaa6296ca623514bca7f109bfe1193203f4cc3922ecc6e250c33adcc3e38ab42", required=true, description="ID for sign transactions.")
    public String getTransactionId() {
        return this.transactionId;
    }

    public void setTransactionId(String transactionId) {
        this.transactionId = transactionId;
    }

    public PendedTransaction txData(TxData txData) {
        this.txData = txData;
        return this;
    }

    @Schema(required=true, description="")
    public TxData getTxData() {
        return this.txData;
    }

    public void setTxData(TxData txData) {
        this.txData = txData;
    }

    public PendedTransaction type(String type) {
        this.type = type;
        return this;
    }

    @Schema(example="TX", description="Transaction types (TX)")
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public PendedTransaction updatedAt(Long updatedAt) {
        this.updatedAt = updatedAt;
        return this;
    }

    @Schema(example="1616131131", required=true, description="The time of the latest update of transaction")
    public Long getUpdatedAt() {
        return this.updatedAt;
    }

    public void setUpdatedAt(Long updatedAt) {
        this.updatedAt = updatedAt;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PendedTransaction pendedTransaction = (PendedTransaction)o;
        return Objects.equals(this.address, pendedTransaction.address) && Objects.equals(this.chainId, pendedTransaction.chainId) && Objects.equals(this.createdAt, pendedTransaction.createdAt) && Objects.equals(this.multiSigKeys, pendedTransaction.multiSigKeys) && Objects.equals(this.status, pendedTransaction.status) && Objects.equals(this.threshold, pendedTransaction.threshold) && Objects.equals(this.transactionId, pendedTransaction.transactionId) && Objects.equals(this.txData, pendedTransaction.txData) && Objects.equals(this.type, pendedTransaction.type) && Objects.equals(this.updatedAt, pendedTransaction.updatedAt);
    }

    public int hashCode() {
        return Objects.hash(this.address, this.chainId, this.createdAt, this.multiSigKeys, this.status, this.threshold, this.transactionId, this.txData, this.type, this.updatedAt);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PendedTransaction {\n");
        sb.append("    address: ").append(this.toIndentedString(this.address)).append("\n");
        sb.append("    chainId: ").append(this.toIndentedString(this.chainId)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    multiSigKeys: ").append(this.toIndentedString(this.multiSigKeys)).append("\n");
        sb.append("    status: ").append(this.toIndentedString(this.status)).append("\n");
        sb.append("    threshold: ").append(this.toIndentedString(this.threshold)).append("\n");
        sb.append("    transactionId: ").append(this.toIndentedString(this.transactionId)).append("\n");
        sb.append("    txData: ").append(this.toIndentedString(this.txData)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    updatedAt: ").append(this.toIndentedString(this.updatedAt)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

