/*
 * Decompiled with CFR 0.152.
 */
package xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.wallet.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.math.BigDecimal;
import java.util.Objects;

@Schema(description="Result fee delegation transactions and KLAY converted into different currencies based on the rates at the time of sending the transaction.")
public class FDTransactionWithCurrencyResult {
    @SerializedName(value="chainId")
    private BigDecimal chainId = null;
    @SerializedName(value="chargedByKlay")
    private String chargedByKlay = null;
    @SerializedName(value="chargedByKrw")
    private String chargedByKrw = null;
    @SerializedName(value="chargedByPeb")
    private String chargedByPeb = null;
    @SerializedName(value="chargedByUsd")
    private String chargedByUsd = null;
    @SerializedName(value="feePayer")
    private String feePayer = null;
    @SerializedName(value="from")
    private String from = null;
    @SerializedName(value="gasPrice")
    private String gasPrice = null;
    @SerializedName(value="gasUsed")
    private String gasUsed = null;
    @SerializedName(value="krw")
    private BigDecimal krw = null;
    @SerializedName(value="status")
    private String status = null;
    @SerializedName(value="timestamp")
    private BigDecimal timestamp = null;
    @SerializedName(value="transactionHash")
    private String transactionHash = null;
    @SerializedName(value="typeInt")
    private BigDecimal typeInt = null;
    @SerializedName(value="usd")
    private BigDecimal usd = null;
    @SerializedName(value="to")
    private String to = null;
    @SerializedName(value="feeRatio")
    private String feeRatio = null;

    public FDTransactionWithCurrencyResult chainId(BigDecimal chainId) {
        this.chainId = chainId;
        return this;
    }

    @Schema(required=true, description="")
    public BigDecimal getChainId() {
        return this.chainId;
    }

    public void setChainId(BigDecimal chainId) {
        this.chainId = chainId;
    }

    public FDTransactionWithCurrencyResult chargedByKlay(String chargedByKlay) {
        this.chargedByKlay = chargedByKlay;
        return this;
    }

    @Schema(required=true, description="Fee delegation cost in KLAY")
    public String getChargedByKlay() {
        return this.chargedByKlay;
    }

    public void setChargedByKlay(String chargedByKlay) {
        this.chargedByKlay = chargedByKlay;
    }

    public FDTransactionWithCurrencyResult chargedByKrw(String chargedByKrw) {
        this.chargedByKrw = chargedByKrw;
        return this;
    }

    @Schema(required=true, description="Fee delegation cost in KRW")
    public String getChargedByKrw() {
        return this.chargedByKrw;
    }

    public void setChargedByKrw(String chargedByKrw) {
        this.chargedByKrw = chargedByKrw;
    }

    public FDTransactionWithCurrencyResult chargedByPeb(String chargedByPeb) {
        this.chargedByPeb = chargedByPeb;
        return this;
    }

    @Schema(required=true, description="Fee delegation cost in Peb")
    public String getChargedByPeb() {
        return this.chargedByPeb;
    }

    public void setChargedByPeb(String chargedByPeb) {
        this.chargedByPeb = chargedByPeb;
    }

    public FDTransactionWithCurrencyResult chargedByUsd(String chargedByUsd) {
        this.chargedByUsd = chargedByUsd;
        return this;
    }

    @Schema(required=true, description="Fee delegation cost in USD")
    public String getChargedByUsd() {
        return this.chargedByUsd;
    }

    public void setChargedByUsd(String chargedByUsd) {
        this.chargedByUsd = chargedByUsd;
    }

    public FDTransactionWithCurrencyResult feePayer(String feePayer) {
        this.feePayer = feePayer;
        return this;
    }

    @Schema(required=true, description="FeePayer's Klaytn account address")
    public String getFeePayer() {
        return this.feePayer;
    }

    public void setFeePayer(String feePayer) {
        this.feePayer = feePayer;
    }

    public FDTransactionWithCurrencyResult from(String from) {
        this.from = from;
        return this;
    }

    @Schema(required=true, description="Transaction sender's Klaytn account address")
    public String getFrom() {
        return this.from;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public FDTransactionWithCurrencyResult gasPrice(String gasPrice) {
        this.gasPrice = gasPrice;
        return this;
    }

    @Schema(required=true, description="The cost of gas used for sending the transaction")
    public String getGasPrice() {
        return this.gasPrice;
    }

    public void setGasPrice(String gasPrice) {
        this.gasPrice = gasPrice;
    }

    public FDTransactionWithCurrencyResult gasUsed(String gasUsed) {
        this.gasUsed = gasUsed;
        return this;
    }

    @Schema(required=true, description="Amount of gas used for sending the transaction")
    public String getGasUsed() {
        return this.gasUsed;
    }

    public void setGasUsed(String gasUsed) {
        this.gasUsed = gasUsed;
    }

    public FDTransactionWithCurrencyResult krw(BigDecimal krw) {
        this.krw = krw;
        return this;
    }

    @Schema(required=true, description="KLAY/KRW rate at the time of sending the transaction (previous close)")
    public BigDecimal getKrw() {
        return this.krw;
    }

    public void setKrw(BigDecimal krw) {
        this.krw = krw;
    }

    public FDTransactionWithCurrencyResult status(String status) {
        this.status = status;
        return this;
    }

    @Schema(required=true, description="Transaction status")
    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public FDTransactionWithCurrencyResult timestamp(BigDecimal timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    @Schema(required=true, description="Timestamp of when the transaction was processed (in sec.)")
    public BigDecimal getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(BigDecimal timestamp) {
        this.timestamp = timestamp;
    }

    public FDTransactionWithCurrencyResult transactionHash(String transactionHash) {
        this.transactionHash = transactionHash;
        return this;
    }

    @Schema(required=true, description="Transaction hash")
    public String getTransactionHash() {
        return this.transactionHash;
    }

    public void setTransactionHash(String transactionHash) {
        this.transactionHash = transactionHash;
    }

    public FDTransactionWithCurrencyResult typeInt(BigDecimal typeInt) {
        this.typeInt = typeInt;
        return this;
    }

    @Schema(required=true, description="The number to indicate the transaction type. For more details on transaction types, refer to [link](https://docs.klaytn.com/klaytn/design/transactions).")
    public BigDecimal getTypeInt() {
        return this.typeInt;
    }

    public void setTypeInt(BigDecimal typeInt) {
        this.typeInt = typeInt;
    }

    public FDTransactionWithCurrencyResult usd(BigDecimal usd) {
        this.usd = usd;
        return this;
    }

    @Schema(required=true, description="KLAY/USD rate at the time of sending the transaction (previous close)")
    public BigDecimal getUsd() {
        return this.usd;
    }

    public void setUsd(BigDecimal usd) {
        this.usd = usd;
    }

    public FDTransactionWithCurrencyResult to(String to) {
        this.to = to;
        return this;
    }

    @Schema(description="KLAY recipient's Klaytn account address or contract address")
    public String getTo() {
        return this.to;
    }

    public void setTo(String to) {
        this.to = to;
    }

    public FDTransactionWithCurrencyResult feeRatio(String feeRatio) {
        this.feeRatio = feeRatio;
        return this;
    }

    @Schema(description="The ratio of fee paid by FeePayer from the total transaction fee. If the FeePayer pays all, this field can be left blank.")
    public String getFeeRatio() {
        return this.feeRatio;
    }

    public void setFeeRatio(String feeRatio) {
        this.feeRatio = feeRatio;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FDTransactionWithCurrencyResult fdTransactionWithCurrencyResult = (FDTransactionWithCurrencyResult)o;
        return Objects.equals(this.chainId, fdTransactionWithCurrencyResult.chainId) && Objects.equals(this.chargedByKlay, fdTransactionWithCurrencyResult.chargedByKlay) && Objects.equals(this.chargedByKrw, fdTransactionWithCurrencyResult.chargedByKrw) && Objects.equals(this.chargedByPeb, fdTransactionWithCurrencyResult.chargedByPeb) && Objects.equals(this.chargedByUsd, fdTransactionWithCurrencyResult.chargedByUsd) && Objects.equals(this.feePayer, fdTransactionWithCurrencyResult.feePayer) && Objects.equals(this.from, fdTransactionWithCurrencyResult.from) && Objects.equals(this.gasPrice, fdTransactionWithCurrencyResult.gasPrice) && Objects.equals(this.gasUsed, fdTransactionWithCurrencyResult.gasUsed) && Objects.equals(this.krw, fdTransactionWithCurrencyResult.krw) && Objects.equals(this.status, fdTransactionWithCurrencyResult.status) && Objects.equals(this.timestamp, fdTransactionWithCurrencyResult.timestamp) && Objects.equals(this.transactionHash, fdTransactionWithCurrencyResult.transactionHash) && Objects.equals(this.typeInt, fdTransactionWithCurrencyResult.typeInt) && Objects.equals(this.usd, fdTransactionWithCurrencyResult.usd) && Objects.equals(this.to, fdTransactionWithCurrencyResult.to) && Objects.equals(this.feeRatio, fdTransactionWithCurrencyResult.feeRatio);
    }

    public int hashCode() {
        return Objects.hash(this.chainId, this.chargedByKlay, this.chargedByKrw, this.chargedByPeb, this.chargedByUsd, this.feePayer, this.from, this.gasPrice, this.gasUsed, this.krw, this.status, this.timestamp, this.transactionHash, this.typeInt, this.usd, this.to, this.feeRatio);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FDTransactionWithCurrencyResult {\n");
        sb.append("    chainId: ").append(this.toIndentedString(this.chainId)).append("\n");
        sb.append("    chargedByKlay: ").append(this.toIndentedString(this.chargedByKlay)).append("\n");
        sb.append("    chargedByKrw: ").append(this.toIndentedString(this.chargedByKrw)).append("\n");
        sb.append("    chargedByPeb: ").append(this.toIndentedString(this.chargedByPeb)).append("\n");
        sb.append("    chargedByUsd: ").append(this.toIndentedString(this.chargedByUsd)).append("\n");
        sb.append("    feePayer: ").append(this.toIndentedString(this.feePayer)).append("\n");
        sb.append("    from: ").append(this.toIndentedString(this.from)).append("\n");
        sb.append("    gasPrice: ").append(this.toIndentedString(this.gasPrice)).append("\n");
        sb.append("    gasUsed: ").append(this.toIndentedString(this.gasUsed)).append("\n");
        sb.append("    krw: ").append(this.toIndentedString(this.krw)).append("\n");
        sb.append("    status: ").append(this.toIndentedString(this.status)).append("\n");
        sb.append("    timestamp: ").append(this.toIndentedString(this.timestamp)).append("\n");
        sb.append("    transactionHash: ").append(this.toIndentedString(this.transactionHash)).append("\n");
        sb.append("    typeInt: ").append(this.toIndentedString(this.typeInt)).append("\n");
        sb.append("    usd: ").append(this.toIndentedString(this.usd)).append("\n");
        sb.append("    to: ").append(this.toIndentedString(this.to)).append("\n");
        sb.append("    feeRatio: ").append(this.toIndentedString(this.feeRatio)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

