/*
 * Decompiled with CFR 0.152.
 */
package xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.wallet.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.wallet.model.OneOfAccountUpdateTransactionRequestAccountKey;

@Schema(description="Account update transaction request schema")
public class AccountUpdateTransactionRequest {
    @SerializedName(value="from")
    private String from = null;
    @SerializedName(value="accountKey")
    private OneOfAccountUpdateTransactionRequestAccountKey accountKey = null;
    @SerializedName(value="nonce")
    private Long nonce = null;
    @SerializedName(value="gas")
    private Long gas = 100000L;
    @SerializedName(value="submit")
    private Boolean submit = null;

    public AccountUpdateTransactionRequest from(String from) {
        this.from = from;
        return this;
    }

    @Schema(example="1367406353790006380197033674014448293581197999071", required=true, description="Klaytn transaction address to send transaction")
    public String getFrom() {
        return this.from;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public AccountUpdateTransactionRequest accountKey(OneOfAccountUpdateTransactionRequestAccountKey accountKey) {
        this.accountKey = accountKey;
        return this;
    }

    @Schema(description="")
    public OneOfAccountUpdateTransactionRequestAccountKey getAccountKey() {
        return this.accountKey;
    }

    public void setAccountKey(OneOfAccountUpdateTransactionRequestAccountKey accountKey) {
        this.accountKey = accountKey;
    }

    public AccountUpdateTransactionRequest nonce(Long nonce) {
        this.nonce = nonce;
        return this;
    }

    @Schema(example="0", description="Unique identifier for the transactions being sent (By entering 0, the nonce will be automatically determined)")
    public Long getNonce() {
        return this.nonce;
    }

    public void setNonce(Long nonce) {
        this.nonce = nonce;
    }

    public AccountUpdateTransactionRequest gas(Long gas) {
        this.gas = gas;
        return this;
    }

    @Schema(example="0", description="Maximum gas fee to be used for sending the transaction (By entering 0, it will be set to default value))")
    public Long getGas() {
        return this.gas;
    }

    public void setGas(Long gas) {
        this.gas = gas;
    }

    public AccountUpdateTransactionRequest submit(Boolean submit) {
        this.submit = submit;
        return this;
    }

    @Schema(example="true", description="Shows whether to send the transaction to Klaytn")
    public Boolean isSubmit() {
        return this.submit;
    }

    public void setSubmit(Boolean submit) {
        this.submit = submit;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AccountUpdateTransactionRequest accountUpdateTransactionRequest = (AccountUpdateTransactionRequest)o;
        return Objects.equals(this.from, accountUpdateTransactionRequest.from) && Objects.equals(this.accountKey, accountUpdateTransactionRequest.accountKey) && Objects.equals(this.nonce, accountUpdateTransactionRequest.nonce) && Objects.equals(this.gas, accountUpdateTransactionRequest.gas) && Objects.equals(this.submit, accountUpdateTransactionRequest.submit);
    }

    public int hashCode() {
        return Objects.hash(this.from, this.accountKey, this.nonce, this.gas, this.submit);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AccountUpdateTransactionRequest {\n");
        sb.append("    from: ").append(this.toIndentedString(this.from)).append("\n");
        sb.append("    accountKey: ").append(this.toIndentedString(this.accountKey)).append("\n");
        sb.append("    nonce: ").append(this.toIndentedString(this.nonce)).append("\n");
        sb.append("    gas: ").append(this.toIndentedString(this.gas)).append("\n");
        sb.append("    submit: ").append(this.toIndentedString(this.submit)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

