/*
 * Decompiled with CFR 0.152.
 */
package xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.wallet.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@Schema(description="Logs emitted by the transaction")
public class EventLog {
    @SerializedName(value="address")
    private String address = null;
    @SerializedName(value="blockHash")
    private String blockHash = null;
    @SerializedName(value="blockNumber")
    private String blockNumber = null;
    @SerializedName(value="data")
    private String data = null;
    @SerializedName(value="logIndex")
    private String logIndex = null;
    @SerializedName(value="removed")
    private Boolean removed = null;
    @SerializedName(value="topics")
    private List<String> topics = null;
    @SerializedName(value="transactionHash")
    private String transactionHash = null;
    @SerializedName(value="transactionIndex")
    private String transactionIndex = null;

    public EventLog address(String address) {
        this.address = address;
        return this;
    }

    @Schema(example="0xdcd62c57182e780e23d2313c4782709da85b9d6c", required=true, description="Klaytn account address")
    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public EventLog blockHash(String blockHash) {
        this.blockHash = blockHash;
        return this;
    }

    @Schema(example="0xb714b09a463d32cf309a6e9e0f4d1a1738be5373c584cefeeb781343c208e36d", required=true, description="Block hash including the transaction")
    public String getBlockHash() {
        return this.blockHash;
    }

    public void setBlockHash(String blockHash) {
        this.blockHash = blockHash;
    }

    public EventLog blockNumber(String blockNumber) {
        this.blockNumber = blockNumber;
        return this;
    }

    @Schema(example="0x28aead8", required=true, description="Block number including the transaction")
    public String getBlockNumber() {
        return this.blockNumber;
    }

    public void setBlockNumber(String blockNumber) {
        this.blockNumber = blockNumber;
    }

    public EventLog data(String data) {
        this.data = data;
        return this;
    }

    @Schema(example="0x0000000000000000000000000000000000000000000000008ac7230489e80000", required=true, description="Transaction data")
    public String getData() {
        return this.data;
    }

    public void setData(String data) {
        this.data = data;
    }

    public EventLog logIndex(String logIndex) {
        this.logIndex = logIndex;
        return this;
    }

    @Schema(example="0x2", required=true, description="Index of log")
    public String getLogIndex() {
        return this.logIndex;
    }

    public void setLogIndex(String logIndex) {
        this.logIndex = logIndex;
    }

    public EventLog removed(Boolean removed) {
        this.removed = removed;
        return this;
    }

    @Schema(example="false", required=true, description="Whether to remove log")
    public Boolean isRemoved() {
        return this.removed;
    }

    public void setRemoved(Boolean removed) {
        this.removed = removed;
    }

    public EventLog topics(List<String> topics) {
        this.topics = topics;
        return this;
    }

    public EventLog addTopicsItem(String topicsItem) {
        if (this.topics == null) {
            this.topics = new ArrayList<String>();
        }
        this.topics.add(topicsItem);
        return this;
    }

    @Schema(description="")
    public List<String> getTopics() {
        return this.topics;
    }

    public void setTopics(List<String> topics) {
        this.topics = topics;
    }

    public EventLog transactionHash(String transactionHash) {
        this.transactionHash = transactionHash;
        return this;
    }

    @Schema(example="0x8becaceca227568ef2afb94d85a4ee34c0b5b67a45517a6655c6eb5faee66d29", required=true, description="Transaction hash value")
    public String getTransactionHash() {
        return this.transactionHash;
    }

    public void setTransactionHash(String transactionHash) {
        this.transactionHash = transactionHash;
    }

    public EventLog transactionIndex(String transactionIndex) {
        this.transactionIndex = transactionIndex;
        return this;
    }

    @Schema(example="0x3", required=true, description="Index of the transaction")
    public String getTransactionIndex() {
        return this.transactionIndex;
    }

    public void setTransactionIndex(String transactionIndex) {
        this.transactionIndex = transactionIndex;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EventLog eventLog = (EventLog)o;
        return Objects.equals(this.address, eventLog.address) && Objects.equals(this.blockHash, eventLog.blockHash) && Objects.equals(this.blockNumber, eventLog.blockNumber) && Objects.equals(this.data, eventLog.data) && Objects.equals(this.logIndex, eventLog.logIndex) && Objects.equals(this.removed, eventLog.removed) && Objects.equals(this.topics, eventLog.topics) && Objects.equals(this.transactionHash, eventLog.transactionHash) && Objects.equals(this.transactionIndex, eventLog.transactionIndex);
    }

    public int hashCode() {
        return Objects.hash(this.address, this.blockHash, this.blockNumber, this.data, this.logIndex, this.removed, this.topics, this.transactionHash, this.transactionIndex);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class EventLog {\n");
        sb.append("    address: ").append(this.toIndentedString(this.address)).append("\n");
        sb.append("    blockHash: ").append(this.toIndentedString(this.blockHash)).append("\n");
        sb.append("    blockNumber: ").append(this.toIndentedString(this.blockNumber)).append("\n");
        sb.append("    data: ").append(this.toIndentedString(this.data)).append("\n");
        sb.append("    logIndex: ").append(this.toIndentedString(this.logIndex)).append("\n");
        sb.append("    removed: ").append(this.toIndentedString(this.removed)).append("\n");
        sb.append("    topics: ").append(this.toIndentedString(this.topics)).append("\n");
        sb.append("    transactionHash: ").append(this.toIndentedString(this.transactionHash)).append("\n");
        sb.append("    transactionIndex: ").append(this.toIndentedString(this.transactionIndex)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

