/*
 * Decompiled with CFR 0.152.
 */
package xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.wallet.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.wallet.model.MultisigKey;

@Schema(description="Data on multisig accounts")
public class MultisigAccount {
    @SerializedName(value="address")
    private String address = null;
    @SerializedName(value="krn")
    private String krn = null;
    @SerializedName(value="multiSigKeys")
    private List<MultisigKey> multiSigKeys = null;
    @SerializedName(value="threshold")
    private Long threshold = null;
    @SerializedName(value="transactionHash")
    private String transactionHash = null;
    @SerializedName(value="updatedAt")
    private Long updatedAt = null;

    public MultisigAccount address(String address) {
        this.address = address;
        return this;
    }

    @Schema(example="0xa809284C83b901eD106Aba4Ccda14628Af128e14", required=true, description="Klaytn account address")
    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public MultisigAccount krn(String krn) {
        this.krn = krn;
        return this;
    }

    @Schema(example="krn:1001:wallet:68ec0e4b-0f61-4e6f-ae35-be865ab23187:account-pool:default", required=true, description="KAS KRN")
    public String getKrn() {
        return this.krn;
    }

    public void setKrn(String krn) {
        this.krn = krn;
    }

    public MultisigAccount multiSigKeys(List<MultisigKey> multiSigKeys) {
        this.multiSigKeys = multiSigKeys;
        return this;
    }

    public MultisigAccount addMultiSigKeysItem(MultisigKey multiSigKeysItem) {
        if (this.multiSigKeys == null) {
            this.multiSigKeys = new ArrayList<MultisigKey>();
        }
        this.multiSigKeys.add(multiSigKeysItem);
        return this;
    }

    @Schema(description="")
    public List<MultisigKey> getMultiSigKeys() {
        return this.multiSigKeys;
    }

    public void setMultiSigKeys(List<MultisigKey> multiSigKeys) {
        this.multiSigKeys = multiSigKeys;
    }

    public MultisigAccount threshold(Long threshold) {
        this.threshold = threshold;
        return this;
    }

    @Schema(example="4", required=true, description="Threshold of total weighted values required to create a multisig transaction.")
    public Long getThreshold() {
        return this.threshold;
    }

    public void setThreshold(Long threshold) {
        this.threshold = threshold;
    }

    public MultisigAccount transactionHash(String transactionHash) {
        this.transactionHash = transactionHash;
        return this;
    }

    @Schema(example="0xcd6c6a785bccbbb821e7fb0b3e1c15c0d35d6017706f843dd9cf7f3f4d3a452a", required=true, description="Transaction hash for account data update")
    public String getTransactionHash() {
        return this.transactionHash;
    }

    public void setTransactionHash(String transactionHash) {
        this.transactionHash = transactionHash;
    }

    public MultisigAccount updatedAt(Long updatedAt) {
        this.updatedAt = updatedAt;
        return this;
    }

    @Schema(example="1599187391", required=true, description="The time of the latest update of account data")
    public Long getUpdatedAt() {
        return this.updatedAt;
    }

    public void setUpdatedAt(Long updatedAt) {
        this.updatedAt = updatedAt;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MultisigAccount multisigAccount = (MultisigAccount)o;
        return Objects.equals(this.address, multisigAccount.address) && Objects.equals(this.krn, multisigAccount.krn) && Objects.equals(this.multiSigKeys, multisigAccount.multiSigKeys) && Objects.equals(this.threshold, multisigAccount.threshold) && Objects.equals(this.transactionHash, multisigAccount.transactionHash) && Objects.equals(this.updatedAt, multisigAccount.updatedAt);
    }

    public int hashCode() {
        return Objects.hash(this.address, this.krn, this.multiSigKeys, this.threshold, this.transactionHash, this.updatedAt);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MultisigAccount {\n");
        sb.append("    address: ").append(this.toIndentedString(this.address)).append("\n");
        sb.append("    krn: ").append(this.toIndentedString(this.krn)).append("\n");
        sb.append("    multiSigKeys: ").append(this.toIndentedString(this.multiSigKeys)).append("\n");
        sb.append("    threshold: ").append(this.toIndentedString(this.threshold)).append("\n");
        sb.append("    transactionHash: ").append(this.toIndentedString(this.transactionHash)).append("\n");
        sb.append("    updatedAt: ").append(this.toIndentedString(this.updatedAt)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

