/*
 * Decompiled with CFR 0.152.
 */
package xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.wallet.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;

@Schema(description="Fee Delegation anchor transaction request schema")
public class FDAnchorTransactionRequest {
    @SerializedName(value="from")
    private String from = null;
    @SerializedName(value="input")
    private String input = null;
    @SerializedName(value="nonce")
    private Long nonce = null;
    @SerializedName(value="gas")
    private Long gas = 100000L;
    @SerializedName(value="submit")
    private Boolean submit = null;
    @SerializedName(value="feeRatio")
    private Long feeRatio = null;

    public FDAnchorTransactionRequest from(String from) {
        this.from = from;
        return this;
    }

    @Schema(example="0x60d0902c428D0E197F97a756011Fd4893C1E57B0", required=true, description="Klaytn transaction address to send transaction")
    public String getFrom() {
        return this.from;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public FDAnchorTransactionRequest input(String input) {
        this.input = input;
        return this;
    }

    @Schema(example="0x123", required=true, description="Data that is attached to the transaction. Here, it is the data that is being anchored to the main chain.")
    public String getInput() {
        return this.input;
    }

    public void setInput(String input) {
        this.input = input;
    }

    public FDAnchorTransactionRequest nonce(Long nonce) {
        this.nonce = nonce;
        return this;
    }

    @Schema(example="0", description="Unique identifier for the transactions being sent (By entering 0, the nonce will be automatically determined)")
    public Long getNonce() {
        return this.nonce;
    }

    public void setNonce(Long nonce) {
        this.nonce = nonce;
    }

    public FDAnchorTransactionRequest gas(Long gas) {
        this.gas = gas;
        return this;
    }

    @Schema(example="0", description="Maximum gas fee to be used for sending the transaction (By entering 0, it will be set to default value))")
    public Long getGas() {
        return this.gas;
    }

    public void setGas(Long gas) {
        this.gas = gas;
    }

    public FDAnchorTransactionRequest submit(Boolean submit) {
        this.submit = submit;
        return this;
    }

    @Schema(example="true", description="Shows whether to send the transaction to Klaytn")
    public Boolean isSubmit() {
        return this.submit;
    }

    public void setSubmit(Boolean submit) {
        this.submit = submit;
    }

    public FDAnchorTransactionRequest feeRatio(Long feeRatio) {
        this.feeRatio = feeRatio;
        return this;
    }

    @Schema(example="20", description="The ratio of the gas fee to be delegated. When it's empty or 0, the entire fee will be delegated.")
    public Long getFeeRatio() {
        return this.feeRatio;
    }

    public void setFeeRatio(Long feeRatio) {
        this.feeRatio = feeRatio;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FDAnchorTransactionRequest fdAnchorTransactionRequest = (FDAnchorTransactionRequest)o;
        return Objects.equals(this.from, fdAnchorTransactionRequest.from) && Objects.equals(this.input, fdAnchorTransactionRequest.input) && Objects.equals(this.nonce, fdAnchorTransactionRequest.nonce) && Objects.equals(this.gas, fdAnchorTransactionRequest.gas) && Objects.equals(this.submit, fdAnchorTransactionRequest.submit) && Objects.equals(this.feeRatio, fdAnchorTransactionRequest.feeRatio);
    }

    public int hashCode() {
        return Objects.hash(this.from, this.input, this.nonce, this.gas, this.submit, this.feeRatio);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FDAnchorTransactionRequest {\n");
        sb.append("    from: ").append(this.toIndentedString(this.from)).append("\n");
        sb.append("    input: ").append(this.toIndentedString(this.input)).append("\n");
        sb.append("    nonce: ").append(this.toIndentedString(this.nonce)).append("\n");
        sb.append("    gas: ").append(this.toIndentedString(this.gas)).append("\n");
        sb.append("    submit: ").append(this.toIndentedString(this.submit)).append("\n");
        sb.append("    feeRatio: ").append(this.toIndentedString(this.feeRatio)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

