/*
 * Decompiled with CFR 0.152.
 */
package xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.anchor.api;

import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.ApiCallback;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.ApiClient;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.ApiException;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.ApiResponse;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.Configuration;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.Pair;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.ProgressRequestBody;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.ProgressResponseBody;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.anchor.model.AnchorBlockRequest;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.anchor.model.AnchorBlockStatus;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.anchor.model.AnchorTransactionDetail;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.anchor.model.AnchorTransactions;

public class DataAnchoringTransactionApi {
    private ApiClient apiClient;

    public DataAnchoringTransactionApi() {
        this(Configuration.getDefaultApiClient());
    }

    public DataAnchoringTransactionApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call anchorBlockCall(String xChainId, AnchorBlockRequest body, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        AnchorBlockRequest localVarPostBody = body;
        String localVarPath = "/v1/anchor";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xChainId != null) {
            localVarHeaderParams.put("x-chain-id", this.apiClient.parameterToString(xChainId));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"basic"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call anchorBlockValidateBeforeCall(String xChainId, AnchorBlockRequest body, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (xChainId == null) {
            throw new ApiException("Missing the required parameter 'xChainId' when calling anchorBlock(Async)");
        }
        Call call = this.anchorBlockCall(xChainId, body, progressListener, progressRequestListener);
        return call;
    }

    public AnchorBlockStatus anchorBlock(String xChainId, AnchorBlockRequest body) throws ApiException {
        ApiResponse<AnchorBlockStatus> resp = this.anchorBlockWithHttpInfo(xChainId, body);
        return resp.getData();
    }

    public ApiResponse<AnchorBlockStatus> anchorBlockWithHttpInfo(String xChainId, AnchorBlockRequest body) throws ApiException {
        Call call = this.anchorBlockValidateBeforeCall(xChainId, body, null, null);
        Type localVarReturnType = new TypeToken<AnchorBlockStatus>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call anchorBlockAsync(String xChainId, AnchorBlockRequest body, final ApiCallback<AnchorBlockStatus> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.anchorBlockValidateBeforeCall(xChainId, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<AnchorBlockStatus>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getAnchorBlockByPayloadIDCall(String xChainId, String operatorId, String payloadId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/v1/operator/{operator-id}/payload/{payload-id}".replaceAll("\\{operator-id\\}", this.apiClient.escapeString(operatorId.toString())).replaceAll("\\{payload-id\\}", this.apiClient.escapeString(payloadId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xChainId != null) {
            localVarHeaderParams.put("x-chain-id", this.apiClient.parameterToString(xChainId));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"basic"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getAnchorBlockByPayloadIDValidateBeforeCall(String xChainId, String operatorId, String payloadId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (xChainId == null) {
            throw new ApiException("Missing the required parameter 'xChainId' when calling getAnchorBlockByPayloadID(Async)");
        }
        if (operatorId == null) {
            throw new ApiException("Missing the required parameter 'operatorId' when calling getAnchorBlockByPayloadID(Async)");
        }
        if (payloadId == null) {
            throw new ApiException("Missing the required parameter 'payloadId' when calling getAnchorBlockByPayloadID(Async)");
        }
        Call call = this.getAnchorBlockByPayloadIDCall(xChainId, operatorId, payloadId, progressListener, progressRequestListener);
        return call;
    }

    public AnchorTransactionDetail getAnchorBlockByPayloadID(String xChainId, String operatorId, String payloadId) throws ApiException {
        ApiResponse<AnchorTransactionDetail> resp = this.getAnchorBlockByPayloadIDWithHttpInfo(xChainId, operatorId, payloadId);
        return resp.getData();
    }

    public ApiResponse<AnchorTransactionDetail> getAnchorBlockByPayloadIDWithHttpInfo(String xChainId, String operatorId, String payloadId) throws ApiException {
        Call call = this.getAnchorBlockByPayloadIDValidateBeforeCall(xChainId, operatorId, payloadId, null, null);
        Type localVarReturnType = new TypeToken<AnchorTransactionDetail>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getAnchorBlockByPayloadIDAsync(String xChainId, String operatorId, String payloadId, final ApiCallback<AnchorTransactionDetail> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getAnchorBlockByPayloadIDValidateBeforeCall(xChainId, operatorId, payloadId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<AnchorTransactionDetail>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getAnchorBlockByTxCall(String xChainId, String operatorId, String transactionHash, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/v1/operator/{operator-id}/tx/{transaction-hash}".replaceAll("\\{operator-id\\}", this.apiClient.escapeString(operatorId.toString())).replaceAll("\\{transaction-hash\\}", this.apiClient.escapeString(transactionHash.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xChainId != null) {
            localVarHeaderParams.put("x-chain-id", this.apiClient.parameterToString(xChainId));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"basic"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getAnchorBlockByTxValidateBeforeCall(String xChainId, String operatorId, String transactionHash, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (xChainId == null) {
            throw new ApiException("Missing the required parameter 'xChainId' when calling getAnchorBlockByTx(Async)");
        }
        if (operatorId == null) {
            throw new ApiException("Missing the required parameter 'operatorId' when calling getAnchorBlockByTx(Async)");
        }
        if (transactionHash == null) {
            throw new ApiException("Missing the required parameter 'transactionHash' when calling getAnchorBlockByTx(Async)");
        }
        Call call = this.getAnchorBlockByTxCall(xChainId, operatorId, transactionHash, progressListener, progressRequestListener);
        return call;
    }

    public AnchorTransactionDetail getAnchorBlockByTx(String xChainId, String operatorId, String transactionHash) throws ApiException {
        ApiResponse<AnchorTransactionDetail> resp = this.getAnchorBlockByTxWithHttpInfo(xChainId, operatorId, transactionHash);
        return resp.getData();
    }

    public ApiResponse<AnchorTransactionDetail> getAnchorBlockByTxWithHttpInfo(String xChainId, String operatorId, String transactionHash) throws ApiException {
        Call call = this.getAnchorBlockByTxValidateBeforeCall(xChainId, operatorId, transactionHash, null, null);
        Type localVarReturnType = new TypeToken<AnchorTransactionDetail>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getAnchorBlockByTxAsync(String xChainId, String operatorId, String transactionHash, final ApiCallback<AnchorTransactionDetail> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getAnchorBlockByTxValidateBeforeCall(xChainId, operatorId, transactionHash, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<AnchorTransactionDetail>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call retrieveAnchorBlockCall(String xChainId, String operatorId, Long size, String cursor, Long fromTimestamp, Long toTimestamp, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/v1/operator/{operator-id}/tx".replaceAll("\\{operator-id\\}", this.apiClient.escapeString(operatorId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (size != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("size", size));
        }
        if (cursor != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("cursor", cursor));
        }
        if (fromTimestamp != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("from-timestamp", fromTimestamp));
        }
        if (toTimestamp != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("to-timestamp", toTimestamp));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xChainId != null) {
            localVarHeaderParams.put("x-chain-id", this.apiClient.parameterToString(xChainId));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"basic"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call retrieveAnchorBlockValidateBeforeCall(String xChainId, String operatorId, Long size, String cursor, Long fromTimestamp, Long toTimestamp, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (xChainId == null) {
            throw new ApiException("Missing the required parameter 'xChainId' when calling retrieveAnchorBlock(Async)");
        }
        if (operatorId == null) {
            throw new ApiException("Missing the required parameter 'operatorId' when calling retrieveAnchorBlock(Async)");
        }
        Call call = this.retrieveAnchorBlockCall(xChainId, operatorId, size, cursor, fromTimestamp, toTimestamp, progressListener, progressRequestListener);
        return call;
    }

    public AnchorTransactions retrieveAnchorBlock(String xChainId, String operatorId, Long size, String cursor, Long fromTimestamp, Long toTimestamp) throws ApiException {
        ApiResponse<AnchorTransactions> resp = this.retrieveAnchorBlockWithHttpInfo(xChainId, operatorId, size, cursor, fromTimestamp, toTimestamp);
        return resp.getData();
    }

    public ApiResponse<AnchorTransactions> retrieveAnchorBlockWithHttpInfo(String xChainId, String operatorId, Long size, String cursor, Long fromTimestamp, Long toTimestamp) throws ApiException {
        Call call = this.retrieveAnchorBlockValidateBeforeCall(xChainId, operatorId, size, cursor, fromTimestamp, toTimestamp, null, null);
        Type localVarReturnType = new TypeToken<AnchorTransactions>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call retrieveAnchorBlockAsync(String xChainId, String operatorId, Long size, String cursor, Long fromTimestamp, Long toTimestamp, final ApiCallback<AnchorTransactions> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.retrieveAnchorBlockValidateBeforeCall(xChainId, operatorId, size, cursor, fromTimestamp, toTimestamp, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<AnchorTransactions>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

