/*
 * Decompiled with CFR 0.152.
 */
package xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.wallet.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;

@Schema(description="Cancellation Transaction Request Scheme")
public class CancelTransactionRequest {
    @SerializedName(value="from")
    private String from = null;
    @SerializedName(value="transactionHash")
    private String transactionHash = null;
    @SerializedName(value="nonce")
    private Long nonce = null;
    @SerializedName(value="gas")
    private Long gas = 100000L;
    @SerializedName(value="submit")
    private Boolean submit = null;

    public CancelTransactionRequest from(String from) {
        this.from = from;
        return this;
    }

    @Schema(example="0x5bb85d4032354E88020595AFAFC081C24098202e", required=true, description="Klaytn account address sending a transaction")
    public String getFrom() {
        return this.from;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public CancelTransactionRequest transactionHash(String transactionHash) {
        this.transactionHash = transactionHash;
        return this;
    }

    @Schema(example="0x02e13becf638cac359381fa5dfc3ef8f598a90cceb9842eb714019bcd883fd59", description="Transaction hash value")
    public String getTransactionHash() {
        return this.transactionHash;
    }

    public void setTransactionHash(String transactionHash) {
        this.transactionHash = transactionHash;
    }

    public CancelTransactionRequest nonce(Long nonce) {
        this.nonce = nonce;
        return this;
    }

    @Schema(example="0", description="Unique value of the outgoing transaction")
    public Long getNonce() {
        return this.nonce;
    }

    public void setNonce(Long nonce) {
        this.nonce = nonce;
    }

    public CancelTransactionRequest gas(Long gas) {
        this.gas = gas;
        return this;
    }

    @Schema(example="1000000", description="Max. transaction fee (gas) for sending the transaction")
    public Long getGas() {
        return this.gas;
    }

    public void setGas(Long gas) {
        this.gas = gas;
    }

    public CancelTransactionRequest submit(Boolean submit) {
        this.submit = submit;
        return this;
    }

    @Schema(example="true", description="Whether to send the transaction to Klaytn")
    public Boolean isSubmit() {
        return this.submit;
    }

    public void setSubmit(Boolean submit) {
        this.submit = submit;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CancelTransactionRequest cancelTransactionRequest = (CancelTransactionRequest)o;
        return Objects.equals(this.from, cancelTransactionRequest.from) && Objects.equals(this.transactionHash, cancelTransactionRequest.transactionHash) && Objects.equals(this.nonce, cancelTransactionRequest.nonce) && Objects.equals(this.gas, cancelTransactionRequest.gas) && Objects.equals(this.submit, cancelTransactionRequest.submit);
    }

    public int hashCode() {
        return Objects.hash(this.from, this.transactionHash, this.nonce, this.gas, this.submit);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CancelTransactionRequest {\n");
        sb.append("    from: ").append(this.toIndentedString(this.from)).append("\n");
        sb.append("    transactionHash: ").append(this.toIndentedString(this.transactionHash)).append("\n");
        sb.append("    nonce: ").append(this.toIndentedString(this.nonce)).append("\n");
        sb.append("    gas: ").append(this.toIndentedString(this.gas)).append("\n");
        sb.append("    submit: ").append(this.toIndentedString(this.submit)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

