/*
 * Decompiled with CFR 0.152.
 */
package xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.wallet.api;

import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.ApiCallback;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.ApiClient;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.ApiException;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.ApiResponse;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.Configuration;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.Pair;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.ProgressRequestBody;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.ProgressResponseBody;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.wallet.model.Account;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.wallet.model.AccountStatus;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.wallet.model.AccountSummary;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.wallet.model.Accounts;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.wallet.model.AccountsByPubkey;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.wallet.model.MultisigAccount;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.wallet.model.MultisigAccountUpdateRequest;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.wallet.model.Signature;

public class AccountApi {
    private ApiClient apiClient;

    public AccountApi() {
        this(Configuration.getDefaultApiClient());
    }

    public AccountApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call activateAccountCall(String xChainId, String address, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/v2/account/{address}/enable".replaceAll("\\{address\\}", this.apiClient.escapeString(address.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xChainId != null) {
            localVarHeaderParams.put("x-chain-id", this.apiClient.parameterToString(xChainId));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"basic"};
        return this.apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call activateAccountValidateBeforeCall(String xChainId, String address, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (xChainId == null) {
            throw new ApiException("Missing the required parameter 'xChainId' when calling activateAccount(Async)");
        }
        if (address == null) {
            throw new ApiException("Missing the required parameter 'address' when calling activateAccount(Async)");
        }
        Call call = this.activateAccountCall(xChainId, address, progressListener, progressRequestListener);
        return call;
    }

    public AccountSummary activateAccount(String xChainId, String address) throws ApiException {
        ApiResponse<AccountSummary> resp = this.activateAccountWithHttpInfo(xChainId, address);
        return resp.getData();
    }

    public ApiResponse<AccountSummary> activateAccountWithHttpInfo(String xChainId, String address) throws ApiException {
        Call call = this.activateAccountValidateBeforeCall(xChainId, address, null, null);
        Type localVarReturnType = new TypeToken<AccountSummary>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call activateAccountAsync(String xChainId, String address, final ApiCallback<AccountSummary> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.activateAccountValidateBeforeCall(xChainId, address, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<AccountSummary>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call createAccountCall(String xChainId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/v2/account";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xChainId != null) {
            localVarHeaderParams.put("x-chain-id", this.apiClient.parameterToString(xChainId));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"basic"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call createAccountValidateBeforeCall(String xChainId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (xChainId == null) {
            throw new ApiException("Missing the required parameter 'xChainId' when calling createAccount(Async)");
        }
        Call call = this.createAccountCall(xChainId, progressListener, progressRequestListener);
        return call;
    }

    public Account createAccount(String xChainId) throws ApiException {
        ApiResponse<Account> resp = this.createAccountWithHttpInfo(xChainId);
        return resp.getData();
    }

    public ApiResponse<Account> createAccountWithHttpInfo(String xChainId) throws ApiException {
        Call call = this.createAccountValidateBeforeCall(xChainId, null, null);
        Type localVarReturnType = new TypeToken<Account>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call createAccountAsync(String xChainId, final ApiCallback<Account> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.createAccountValidateBeforeCall(xChainId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Account>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call deactivateAccountCall(String xChainId, String address, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/v2/account/{address}/disable".replaceAll("\\{address\\}", this.apiClient.escapeString(address.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xChainId != null) {
            localVarHeaderParams.put("x-chain-id", this.apiClient.parameterToString(xChainId));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"basic"};
        return this.apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call deactivateAccountValidateBeforeCall(String xChainId, String address, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (xChainId == null) {
            throw new ApiException("Missing the required parameter 'xChainId' when calling deactivateAccount(Async)");
        }
        if (address == null) {
            throw new ApiException("Missing the required parameter 'address' when calling deactivateAccount(Async)");
        }
        Call call = this.deactivateAccountCall(xChainId, address, progressListener, progressRequestListener);
        return call;
    }

    public AccountSummary deactivateAccount(String xChainId, String address) throws ApiException {
        ApiResponse<AccountSummary> resp = this.deactivateAccountWithHttpInfo(xChainId, address);
        return resp.getData();
    }

    public ApiResponse<AccountSummary> deactivateAccountWithHttpInfo(String xChainId, String address) throws ApiException {
        Call call = this.deactivateAccountValidateBeforeCall(xChainId, address, null, null);
        Type localVarReturnType = new TypeToken<AccountSummary>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call deactivateAccountAsync(String xChainId, String address, final ApiCallback<AccountSummary> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.deactivateAccountValidateBeforeCall(xChainId, address, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<AccountSummary>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call deleteAccountCall(String xChainId, String address, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/v2/account/{address}".replaceAll("\\{address\\}", this.apiClient.escapeString(address.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xChainId != null) {
            localVarHeaderParams.put("x-chain-id", this.apiClient.parameterToString(xChainId));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"basic"};
        return this.apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call deleteAccountValidateBeforeCall(String xChainId, String address, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (xChainId == null) {
            throw new ApiException("Missing the required parameter 'xChainId' when calling deleteAccount(Async)");
        }
        if (address == null) {
            throw new ApiException("Missing the required parameter 'address' when calling deleteAccount(Async)");
        }
        Call call = this.deleteAccountCall(xChainId, address, progressListener, progressRequestListener);
        return call;
    }

    public AccountStatus deleteAccount(String xChainId, String address) throws ApiException {
        ApiResponse<AccountStatus> resp = this.deleteAccountWithHttpInfo(xChainId, address);
        return resp.getData();
    }

    public ApiResponse<AccountStatus> deleteAccountWithHttpInfo(String xChainId, String address) throws ApiException {
        Call call = this.deleteAccountValidateBeforeCall(xChainId, address, null, null);
        Type localVarReturnType = new TypeToken<AccountStatus>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call deleteAccountAsync(String xChainId, String address, final ApiCallback<AccountStatus> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.deleteAccountValidateBeforeCall(xChainId, address, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<AccountStatus>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call multisigAccountUpdateCall(String xChainId, String address, MultisigAccountUpdateRequest body, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        MultisigAccountUpdateRequest localVarPostBody = body;
        String localVarPath = "/v2/account/{address}/multisig".replaceAll("\\{address\\}", this.apiClient.escapeString(address.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xChainId != null) {
            localVarHeaderParams.put("x-chain-id", this.apiClient.parameterToString(xChainId));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"basic"};
        return this.apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call multisigAccountUpdateValidateBeforeCall(String xChainId, String address, MultisigAccountUpdateRequest body, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (xChainId == null) {
            throw new ApiException("Missing the required parameter 'xChainId' when calling multisigAccountUpdate(Async)");
        }
        if (address == null) {
            throw new ApiException("Missing the required parameter 'address' when calling multisigAccountUpdate(Async)");
        }
        Call call = this.multisigAccountUpdateCall(xChainId, address, body, progressListener, progressRequestListener);
        return call;
    }

    public MultisigAccount multisigAccountUpdate(String xChainId, String address, MultisigAccountUpdateRequest body) throws ApiException {
        ApiResponse<MultisigAccount> resp = this.multisigAccountUpdateWithHttpInfo(xChainId, address, body);
        return resp.getData();
    }

    public ApiResponse<MultisigAccount> multisigAccountUpdateWithHttpInfo(String xChainId, String address, MultisigAccountUpdateRequest body) throws ApiException {
        Call call = this.multisigAccountUpdateValidateBeforeCall(xChainId, address, body, null, null);
        Type localVarReturnType = new TypeToken<MultisigAccount>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call multisigAccountUpdateAsync(String xChainId, String address, MultisigAccountUpdateRequest body, final ApiCallback<MultisigAccount> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.multisigAccountUpdateValidateBeforeCall(xChainId, address, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<MultisigAccount>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call retrieveAccountCall(String xChainId, String address, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/v2/account/{address}".replaceAll("\\{address\\}", this.apiClient.escapeString(address.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xChainId != null) {
            localVarHeaderParams.put("x-chain-id", this.apiClient.parameterToString(xChainId));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"basic"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call retrieveAccountValidateBeforeCall(String xChainId, String address, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (xChainId == null) {
            throw new ApiException("Missing the required parameter 'xChainId' when calling retrieveAccount(Async)");
        }
        if (address == null) {
            throw new ApiException("Missing the required parameter 'address' when calling retrieveAccount(Async)");
        }
        Call call = this.retrieveAccountCall(xChainId, address, progressListener, progressRequestListener);
        return call;
    }

    public Account retrieveAccount(String xChainId, String address) throws ApiException {
        ApiResponse<Account> resp = this.retrieveAccountWithHttpInfo(xChainId, address);
        return resp.getData();
    }

    public ApiResponse<Account> retrieveAccountWithHttpInfo(String xChainId, String address) throws ApiException {
        Call call = this.retrieveAccountValidateBeforeCall(xChainId, address, null, null);
        Type localVarReturnType = new TypeToken<Account>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call retrieveAccountAsync(String xChainId, String address, final ApiCallback<Account> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.retrieveAccountValidateBeforeCall(xChainId, address, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Account>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call retrieveAccountsCall(String xChainId, Long size, String cursor, Long toTimestamp, Long fromTimestamp, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/v2/account";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (size != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("size", size));
        }
        if (cursor != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("cursor", cursor));
        }
        if (toTimestamp != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("to-timestamp", toTimestamp));
        }
        if (fromTimestamp != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("from-timestamp", fromTimestamp));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xChainId != null) {
            localVarHeaderParams.put("x-chain-id", this.apiClient.parameterToString(xChainId));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"basic"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call retrieveAccountsValidateBeforeCall(String xChainId, Long size, String cursor, Long toTimestamp, Long fromTimestamp, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (xChainId == null) {
            throw new ApiException("Missing the required parameter 'xChainId' when calling retrieveAccounts(Async)");
        }
        Call call = this.retrieveAccountsCall(xChainId, size, cursor, toTimestamp, fromTimestamp, progressListener, progressRequestListener);
        return call;
    }

    public Accounts retrieveAccounts(String xChainId, Long size, String cursor, Long toTimestamp, Long fromTimestamp) throws ApiException {
        ApiResponse<Accounts> resp = this.retrieveAccountsWithHttpInfo(xChainId, size, cursor, toTimestamp, fromTimestamp);
        return resp.getData();
    }

    public ApiResponse<Accounts> retrieveAccountsWithHttpInfo(String xChainId, Long size, String cursor, Long toTimestamp, Long fromTimestamp) throws ApiException {
        Call call = this.retrieveAccountsValidateBeforeCall(xChainId, size, cursor, toTimestamp, fromTimestamp, null, null);
        Type localVarReturnType = new TypeToken<Accounts>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call retrieveAccountsAsync(String xChainId, Long size, String cursor, Long toTimestamp, Long fromTimestamp, final ApiCallback<Accounts> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.retrieveAccountsValidateBeforeCall(xChainId, size, cursor, toTimestamp, fromTimestamp, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Accounts>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call retrieveAccountsByPubkeyCall(String xChainId, String publicKey, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/v2/pubkey/{public-key}/account".replaceAll("\\{public-key\\}", this.apiClient.escapeString(publicKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xChainId != null) {
            localVarHeaderParams.put("x-chain-id", this.apiClient.parameterToString(xChainId));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"basic"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call retrieveAccountsByPubkeyValidateBeforeCall(String xChainId, String publicKey, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (xChainId == null) {
            throw new ApiException("Missing the required parameter 'xChainId' when calling retrieveAccountsByPubkey(Async)");
        }
        if (publicKey == null) {
            throw new ApiException("Missing the required parameter 'publicKey' when calling retrieveAccountsByPubkey(Async)");
        }
        Call call = this.retrieveAccountsByPubkeyCall(xChainId, publicKey, progressListener, progressRequestListener);
        return call;
    }

    public AccountsByPubkey retrieveAccountsByPubkey(String xChainId, String publicKey) throws ApiException {
        ApiResponse<AccountsByPubkey> resp = this.retrieveAccountsByPubkeyWithHttpInfo(xChainId, publicKey);
        return resp.getData();
    }

    public ApiResponse<AccountsByPubkey> retrieveAccountsByPubkeyWithHttpInfo(String xChainId, String publicKey) throws ApiException {
        Call call = this.retrieveAccountsByPubkeyValidateBeforeCall(xChainId, publicKey, null, null);
        Type localVarReturnType = new TypeToken<AccountsByPubkey>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call retrieveAccountsByPubkeyAsync(String xChainId, String publicKey, final ApiCallback<AccountsByPubkey> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.retrieveAccountsByPubkeyValidateBeforeCall(xChainId, publicKey, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<AccountsByPubkey>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call signTransactionIDResponseCall(String xChainId, String address, String transactionId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/v2/account/{address}/tx/{transaction-id}/sign".replaceAll("\\{address\\}", this.apiClient.escapeString(address.toString())).replaceAll("\\{transaction-id\\}", this.apiClient.escapeString(transactionId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xChainId != null) {
            localVarHeaderParams.put("x-chain-id", this.apiClient.parameterToString(xChainId));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"basic"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call signTransactionIDResponseValidateBeforeCall(String xChainId, String address, String transactionId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (xChainId == null) {
            throw new ApiException("Missing the required parameter 'xChainId' when calling signTransactionIDResponse(Async)");
        }
        if (address == null) {
            throw new ApiException("Missing the required parameter 'address' when calling signTransactionIDResponse(Async)");
        }
        if (transactionId == null) {
            throw new ApiException("Missing the required parameter 'transactionId' when calling signTransactionIDResponse(Async)");
        }
        Call call = this.signTransactionIDResponseCall(xChainId, address, transactionId, progressListener, progressRequestListener);
        return call;
    }

    public Signature signTransactionIDResponse(String xChainId, String address, String transactionId) throws ApiException {
        ApiResponse<Signature> resp = this.signTransactionIDResponseWithHttpInfo(xChainId, address, transactionId);
        return resp.getData();
    }

    public ApiResponse<Signature> signTransactionIDResponseWithHttpInfo(String xChainId, String address, String transactionId) throws ApiException {
        Call call = this.signTransactionIDResponseValidateBeforeCall(xChainId, address, transactionId, null, null);
        Type localVarReturnType = new TypeToken<Signature>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call signTransactionIDResponseAsync(String xChainId, String address, String transactionId, final ApiCallback<Signature> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.signTransactionIDResponseValidateBeforeCall(xChainId, address, transactionId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Signature>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

