/*
 * Decompiled with CFR 0.152.
 */
package org.luaj.vm2.luajc;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.Hashtable;
import org.luaj.vm2.Lua;
import org.luaj.vm2.LuaString;
import org.luaj.vm2.Print;
import org.luaj.vm2.Prototype;
import org.luaj.vm2.Upvaldesc;
import org.luaj.vm2.luajc.BasicBlock;
import org.luaj.vm2.luajc.UpvalInfo;
import org.luaj.vm2.luajc.VarInfo;

public class ProtoInfo {
    public final String name;
    public final Prototype prototype;
    public final ProtoInfo[] subprotos;
    public final BasicBlock[] blocks;
    public final BasicBlock[] blocklist;
    public final VarInfo[] params;
    public final VarInfo[][] vars;
    public final UpvalInfo[] upvals;
    public final UpvalInfo[][] openups;

    public ProtoInfo(Prototype prototype, String string) {
        this(prototype, string, null);
    }

    private ProtoInfo(Prototype prototype, String string, UpvalInfo[] upvalInfoArray) {
        UpvalInfo[] upvalInfoArray2;
        this.name = string;
        this.prototype = prototype;
        if (upvalInfoArray != null) {
            upvalInfoArray2 = upvalInfoArray;
        } else {
            UpvalInfo[] upvalInfoArray3 = new UpvalInfo[1];
            upvalInfoArray2 = upvalInfoArray3;
            upvalInfoArray3[0] = new UpvalInfo(this);
        }
        this.upvals = upvalInfoArray2;
        this.subprotos = prototype.p != null && prototype.p.length > 0 ? new ProtoInfo[prototype.p.length] : null;
        this.blocks = BasicBlock.findBasicBlocks(prototype);
        this.blocklist = BasicBlock.findLiveBlocks(this.blocks);
        this.params = new VarInfo[prototype.maxstacksize];
        for (int j = 0; j < prototype.maxstacksize; ++j) {
            VarInfo varInfo;
            this.params[j] = varInfo = VarInfo.PARAM(j);
        }
        this.vars = this.findVariables();
        this.replaceTrivialPhiVariables();
        this.openups = new UpvalInfo[prototype.maxstacksize][];
        this.findUpvalues();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        int n;
        int n2;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("proto '" + this.name + "'\n");
        int n3 = n2 = this.upvals != null ? this.upvals.length : 0;
        for (n = 0; n < n2; ++n) {
            stringBuffer.append(" up[" + n + "]: " + this.upvals[n] + "\n");
        }
        for (n = 0; n < this.blocklist.length; ++n) {
            BasicBlock basicBlock = this.blocklist[n];
            int n4 = basicBlock.pc0;
            stringBuffer.append("  block " + basicBlock.toString());
            this.appendOpenUps(stringBuffer, -1);
            for (int j = n4; j <= basicBlock.pc1; ++j) {
                Object object;
                this.appendOpenUps(stringBuffer, j);
                stringBuffer.append("     ");
                for (int k = 0; k < this.prototype.maxstacksize; ++k) {
                    object = this.vars[k][j];
                    String string = object == null ? "" : (((VarInfo)object).upvalue != null ? (!((VarInfo)object).upvalue.rw ? "[C] " : (((VarInfo)object).allocupvalue && ((VarInfo)object).pc == j ? "[*] " : "[]  ")) : "    ");
                    String string2 = object == null ? "null   " : String.valueOf(object);
                    stringBuffer.append(string2 + string);
                }
                stringBuffer.append("  ");
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                object = Print.ps;
                Print.ps = new PrintStream(byteArrayOutputStream);
                try {
                    Print.printOpCode(this.prototype, j);
                }
                finally {
                    Print.ps.close();
                    Print.ps = object;
                }
                stringBuffer.append(byteArrayOutputStream.toString());
                stringBuffer.append("\n");
            }
        }
        int n5 = n2 = this.subprotos != null ? this.subprotos.length : 0;
        for (n = 0; n < n2; ++n) {
            stringBuffer.append(this.subprotos[n].toString());
        }
        return stringBuffer.toString();
    }

    private void appendOpenUps(StringBuffer stringBuffer, int n) {
        for (int j = 0; j < this.prototype.maxstacksize; ++j) {
            VarInfo varInfo;
            VarInfo varInfo2 = varInfo = n < 0 ? this.params[j] : this.vars[j][n];
            if (varInfo == null || varInfo.pc != n || !varInfo.allocupvalue) continue;
            stringBuffer.append("    open: " + varInfo.upvalue + "\n");
        }
    }

    private VarInfo[][] findVariables() {
        int n;
        int n2 = this.prototype.code.length;
        int n3 = this.prototype.maxstacksize;
        VarInfo[][] varInfoArray = new VarInfo[n3][];
        for (n = 0; n < varInfoArray.length; ++n) {
            varInfoArray[n] = new VarInfo[n2];
        }
        for (n = 0; n < this.blocklist.length; ++n) {
            int n4;
            int n5;
            BasicBlock basicBlock = this.blocklist[n];
            int n6 = basicBlock.prev != null ? basicBlock.prev.length : 0;
            for (n5 = 0; n5 < n3; ++n5) {
                VarInfo varInfo = null;
                if (n6 == 0) {
                    varInfo = this.params[n5];
                } else if (n6 == 1) {
                    varInfo = varInfoArray[n5][basicBlock.prev[0].pc1];
                } else {
                    for (n4 = 0; n4 < n6; ++n4) {
                        BasicBlock basicBlock2 = basicBlock.prev[n4];
                        if (varInfoArray[n5][basicBlock2.pc1] != VarInfo.INVALID) continue;
                        varInfo = VarInfo.INVALID;
                    }
                }
                if (varInfo == null) {
                    varInfo = VarInfo.PHI(this, n5, basicBlock.pc0);
                }
                varInfoArray[n5][basicBlock.pc0] = varInfo;
            }
            block29: for (n5 = basicBlock.pc0; n5 <= basicBlock.pc1; ++n5) {
                if (n5 > basicBlock.pc0) {
                    ProtoInfo.propogateVars(varInfoArray, n5 - 1, n5);
                }
                int n7 = this.prototype.code[n5];
                int n8 = Lua.GET_OPCODE(n7);
                switch (n8) {
                    case 1: 
                    case 3: 
                    case 5: 
                    case 11: {
                        int n9 = Lua.GETARG_A(n7);
                        varInfoArray[n9][n5] = new VarInfo(n9, n5);
                        continue block29;
                    }
                    case 0: 
                    case 19: 
                    case 20: 
                    case 21: 
                    case 28: {
                        int n9 = Lua.GETARG_A(n7);
                        n4 = Lua.GETARG_B(n7);
                        varInfoArray[n4][n5].isreferenced = true;
                        varInfoArray[n9][n5] = new VarInfo(n9, n5);
                        continue block29;
                    }
                    case 13: 
                    case 14: 
                    case 15: 
                    case 16: 
                    case 17: 
                    case 18: {
                        int n9 = Lua.GETARG_A(n7);
                        n4 = Lua.GETARG_B(n7);
                        int n10 = Lua.GETARG_C(n7);
                        if (!Lua.ISK(n4)) {
                            varInfoArray[n4][n5].isreferenced = true;
                        }
                        if (!Lua.ISK(n10)) {
                            varInfoArray[n10][n5].isreferenced = true;
                        }
                        varInfoArray[n9][n5] = new VarInfo(n9, n5);
                        continue block29;
                    }
                    case 10: {
                        int n9 = Lua.GETARG_A(n7);
                        n4 = Lua.GETARG_B(n7);
                        int n10 = Lua.GETARG_C(n7);
                        varInfoArray[n9][n5].isreferenced = true;
                        if (!Lua.ISK(n4)) {
                            varInfoArray[n4][n5].isreferenced = true;
                        }
                        if (Lua.ISK(n10)) continue block29;
                        varInfoArray[n10][n5].isreferenced = true;
                        continue block29;
                    }
                    case 8: {
                        n4 = Lua.GETARG_B(n7);
                        int n10 = Lua.GETARG_C(n7);
                        if (!Lua.ISK(n4)) {
                            varInfoArray[n4][n5].isreferenced = true;
                        }
                        if (Lua.ISK(n10)) continue block29;
                        varInfoArray[n10][n5].isreferenced = true;
                        continue block29;
                    }
                    case 22: {
                        int n9 = Lua.GETARG_A(n7);
                        int n10 = Lua.GETARG_C(n7);
                        for (n4 = Lua.GETARG_B(n7); n4 <= n10; ++n4) {
                            varInfoArray[n4][n5].isreferenced = true;
                        }
                        varInfoArray[n9][n5] = new VarInfo(n9, n5);
                        continue block29;
                    }
                    case 33: {
                        int n9 = Lua.GETARG_A(n7);
                        varInfoArray[n9 + 2][n5].isreferenced = true;
                        varInfoArray[n9][n5] = new VarInfo(n9, n5);
                        continue block29;
                    }
                    case 7: {
                        int n9 = Lua.GETARG_A(n7);
                        n4 = Lua.GETARG_B(n7);
                        int n10 = Lua.GETARG_C(n7);
                        varInfoArray[n4][n5].isreferenced = true;
                        if (!Lua.ISK(n10)) {
                            varInfoArray[n10][n5].isreferenced = true;
                        }
                        varInfoArray[n9][n5] = new VarInfo(n9, n5);
                        continue block29;
                    }
                    case 6: {
                        int n9 = Lua.GETARG_A(n7);
                        int n10 = Lua.GETARG_C(n7);
                        if (!Lua.ISK(n10)) {
                            varInfoArray[n10][n5].isreferenced = true;
                        }
                        varInfoArray[n9][n5] = new VarInfo(n9, n5);
                        continue block29;
                    }
                    case 12: {
                        int n9 = Lua.GETARG_A(n7);
                        n4 = Lua.GETARG_B(n7);
                        int n10 = Lua.GETARG_C(n7);
                        varInfoArray[n4][n5].isreferenced = true;
                        if (!Lua.ISK(n10)) {
                            varInfoArray[n10][n5].isreferenced = true;
                        }
                        varInfoArray[n9][n5] = new VarInfo(n9, n5);
                        varInfoArray[n9 + 1][n5] = new VarInfo(n9 + 1, n5);
                        continue block29;
                    }
                    case 32: {
                        int n9 = Lua.GETARG_A(n7);
                        varInfoArray[n9][n5].isreferenced = true;
                        varInfoArray[n9 + 2][n5].isreferenced = true;
                        varInfoArray[n9][n5] = new VarInfo(n9, n5);
                        varInfoArray[n9][n5].isreferenced = true;
                        varInfoArray[n9 + 1][n5].isreferenced = true;
                        varInfoArray[n9 + 3][n5] = new VarInfo(n9 + 3, n5);
                        continue block29;
                    }
                    case 4: {
                        int n9 = Lua.GETARG_A(n7);
                        n4 = Lua.GETARG_B(n7);
                        while (n4-- >= 0) {
                            varInfoArray[n9][n5] = new VarInfo(n9, n5);
                            ++n9;
                        }
                        continue block29;
                    }
                    case 38: {
                        int n9 = Lua.GETARG_A(n7);
                        n4 = Lua.GETARG_B(n7);
                        int n11 = 1;
                        while (n11 < n4) {
                            varInfoArray[n9][n5] = new VarInfo(n9, n5);
                            ++n11;
                            ++n9;
                        }
                        if (n4 != 0) continue block29;
                        while (n9 < n3) {
                            varInfoArray[n9][n5] = VarInfo.INVALID;
                            ++n9;
                        }
                        continue block29;
                    }
                    case 29: {
                        int n12;
                        int n9 = Lua.GETARG_A(n7);
                        n4 = Lua.GETARG_B(n7);
                        int n10 = Lua.GETARG_C(n7);
                        varInfoArray[n9][n5].isreferenced = true;
                        varInfoArray[n9][n5].isreferenced = true;
                        for (n12 = 1; n12 <= n4 - 1; ++n12) {
                            varInfoArray[n9 + n12][n5].isreferenced = true;
                        }
                        n12 = 0;
                        while (n12 <= n10 - 2) {
                            varInfoArray[n9][n5] = new VarInfo(n9, n5);
                            ++n12;
                            ++n9;
                        }
                        while (n9 < n3) {
                            varInfoArray[n9][n5] = VarInfo.INVALID;
                            ++n9;
                        }
                        continue block29;
                    }
                    case 34: {
                        int n9 = Lua.GETARG_A(n7);
                        int n10 = Lua.GETARG_C(n7);
                        varInfoArray[n9++][n5].isreferenced = true;
                        varInfoArray[n9++][n5].isreferenced = true;
                        varInfoArray[n9++][n5].isreferenced = true;
                        int n13 = 0;
                        while (n13 < n10) {
                            varInfoArray[n9][n5] = new VarInfo(n9, n5);
                            ++n13;
                            ++n9;
                        }
                        while (n9 < n3) {
                            varInfoArray[n9][n5] = VarInfo.INVALID;
                            ++n9;
                        }
                        continue block29;
                    }
                    case 35: {
                        int n9 = Lua.GETARG_A(n7);
                        varInfoArray[n9 + 1][n5].isreferenced = true;
                        varInfoArray[n9][n5] = new VarInfo(n9, n5);
                        continue block29;
                    }
                    case 30: {
                        int n9 = Lua.GETARG_A(n7);
                        n4 = Lua.GETARG_B(n7);
                        varInfoArray[n9][n5].isreferenced = true;
                        for (int j = 1; j <= n4 - 1; ++j) {
                            varInfoArray[n9 + j][n5].isreferenced = true;
                        }
                        continue block29;
                    }
                    case 31: {
                        int n9 = Lua.GETARG_A(n7);
                        n4 = Lua.GETARG_B(n7);
                        for (int j = 0; j <= n4 - 2; ++j) {
                            varInfoArray[n9 + j][n5].isreferenced = true;
                        }
                        continue block29;
                    }
                    case 37: {
                        int n9 = Lua.GETARG_A(n7);
                        n4 = Lua.GETARG_Bx(n7);
                        Upvaldesc[] upvaldescArray = this.prototype.p[n4].upvalues;
                        int n14 = upvaldescArray.length;
                        for (int j = 0; j < n14; ++j) {
                            if (!upvaldescArray[j].instack) continue;
                            varInfoArray[upvaldescArray[j].idx][n5].isreferenced = true;
                        }
                        varInfoArray[n9][n5] = new VarInfo(n9, n5);
                        continue block29;
                    }
                    case 36: {
                        int n9 = Lua.GETARG_A(n7);
                        n4 = Lua.GETARG_B(n7);
                        varInfoArray[n9][n5].isreferenced = true;
                        for (int j = 1; j <= n4; ++j) {
                            varInfoArray[n9 + j][n5].isreferenced = true;
                        }
                        continue block29;
                    }
                    case 9: 
                    case 27: {
                        int n9 = Lua.GETARG_A(n7);
                        varInfoArray[n9][n5].isreferenced = true;
                        continue block29;
                    }
                    case 24: 
                    case 25: 
                    case 26: {
                        n4 = Lua.GETARG_B(n7);
                        int n10 = Lua.GETARG_C(n7);
                        if (!Lua.ISK(n4)) {
                            varInfoArray[n4][n5].isreferenced = true;
                        }
                        if (Lua.ISK(n10)) continue block29;
                        varInfoArray[n10][n5].isreferenced = true;
                        continue block29;
                    }
                    case 23: {
                        int n9 = Lua.GETARG_A(n7);
                        if (n9 <= 0) continue block29;
                        --n9;
                        while (n9 < n3) {
                            varInfoArray[n9][n5] = VarInfo.INVALID;
                            ++n9;
                        }
                        continue block29;
                    }
                    default: {
                        throw new IllegalStateException("unhandled opcode: " + n7);
                    }
                }
            }
        }
        return varInfoArray;
    }

    private static void propogateVars(VarInfo[][] varInfoArray, int n, int n2) {
        int n3 = varInfoArray.length;
        for (int j = 0; j < n3; ++j) {
            varInfoArray[j][n2] = varInfoArray[j][n];
        }
    }

    private void replaceTrivialPhiVariables() {
        for (int j = 0; j < this.blocklist.length; ++j) {
            BasicBlock basicBlock = this.blocklist[j];
            for (int k = 0; k < this.prototype.maxstacksize; ++k) {
                VarInfo varInfo = this.vars[k][basicBlock.pc0];
                VarInfo varInfo2 = varInfo.resolvePhiVariableValues();
                if (varInfo2 == null) continue;
                this.substituteVariable(k, varInfo, varInfo2);
            }
        }
    }

    private void substituteVariable(int n, VarInfo varInfo, VarInfo varInfo2) {
        int n2 = this.prototype.code.length;
        for (int j = 0; j < n2; ++j) {
            this.replaceAll(this.vars[n], this.vars[n].length, varInfo, varInfo2);
        }
    }

    private void replaceAll(VarInfo[] varInfoArray, int n, VarInfo varInfo, VarInfo varInfo2) {
        for (int j = 0; j < n; ++j) {
            if (varInfoArray[j] != varInfo) continue;
            varInfoArray[j] = varInfo2;
        }
    }

    private void findUpvalues() {
        int n;
        int[] nArray = this.prototype.code;
        int n2 = nArray.length;
        String[] stringArray = this.findInnerprotoNames();
        for (n = 0; n < n2; ++n) {
            if (Lua.GET_OPCODE(nArray[n]) != 37) continue;
            int n3 = Lua.GETARG_Bx(nArray[n]);
            Prototype prototype = this.prototype.p[n3];
            UpvalInfo[] upvalInfoArray = new UpvalInfo[prototype.upvalues.length];
            String string = this.name + "$" + stringArray[n3];
            for (int j = 0; j < prototype.upvalues.length; ++j) {
                Upvaldesc upvaldesc = prototype.upvalues[j];
                upvalInfoArray[j] = upvaldesc.instack ? this.findOpenUp(n, upvaldesc.idx) : this.upvals[upvaldesc.idx];
            }
            this.subprotos[n3] = new ProtoInfo(prototype, string, upvalInfoArray);
        }
        for (n = 0; n < n2; ++n) {
            if (Lua.GET_OPCODE(nArray[n]) != 9) continue;
            this.upvals[Lua.GETARG_B((int)nArray[n])].rw = true;
        }
    }

    private UpvalInfo findOpenUp(int n, int n2) {
        if (this.openups[n2] == null) {
            this.openups[n2] = new UpvalInfo[this.prototype.code.length];
        }
        if (this.openups[n2][n] != null) {
            return this.openups[n2][n];
        }
        UpvalInfo upvalInfo = new UpvalInfo(this, n, n2);
        int n3 = this.prototype.code.length;
        for (int j = 0; j < n3; ++j) {
            if (this.vars[n2][j] == null || this.vars[n2][j].upvalue != upvalInfo) continue;
            this.openups[n2][j] = upvalInfo;
        }
        return upvalInfo;
    }

    public boolean isUpvalueAssign(int n, int n2) {
        VarInfo varInfo = n < 0 ? this.params[n2] : this.vars[n2][n];
        return varInfo != null && varInfo.upvalue != null && varInfo.upvalue.rw;
    }

    public boolean isUpvalueCreate(int n, int n2) {
        VarInfo varInfo = n < 0 ? this.params[n2] : this.vars[n2][n];
        return varInfo != null && varInfo.upvalue != null && varInfo.upvalue.rw && varInfo.allocupvalue && n == varInfo.pc;
    }

    public boolean isUpvalueRefer(int n, int n2) {
        if (n > 0 && this.vars[n2][n] != null && this.vars[n2][n].pc == n && this.vars[n2][n - 1] != null) {
            --n;
        }
        VarInfo varInfo = n < 0 ? this.params[n2] : this.vars[n2][n];
        return varInfo != null && varInfo.upvalue != null && varInfo.upvalue.rw;
    }

    public boolean isInitialValueUsed(int n) {
        VarInfo varInfo = this.params[n];
        return varInfo.isreferenced;
    }

    public boolean isReadWriteUpvalue(UpvalInfo upvalInfo) {
        return upvalInfo.rw;
    }

    private String[] findInnerprotoNames() {
        if (this.prototype.p.length <= 0) {
            return null;
        }
        String[] stringArray = new String[this.prototype.p.length];
        Hashtable<String, Boolean> hashtable = new Hashtable<String, Boolean>();
        int[] nArray = this.prototype.code;
        int n = nArray.length;
        for (int j = 0; j < n; ++j) {
            if (Lua.GET_OPCODE(nArray[j]) != 37) continue;
            int n2 = Lua.GETARG_Bx(nArray[j]);
            String string = null;
            int n3 = nArray[j + 1];
            switch (Lua.GET_OPCODE(n3)) {
                case 8: 
                case 10: {
                    int n4 = Lua.GETARG_B(n3);
                    if (!Lua.ISK(n4)) break;
                    string = this.prototype.k[n4 & 0xFF].tojstring();
                    break;
                }
                case 9: {
                    int n4 = Lua.GETARG_B(n3);
                    LuaString luaString = this.prototype.upvalues[n4].name;
                    if (luaString == null) break;
                    string = luaString.tojstring();
                    break;
                }
                default: {
                    int n4 = Lua.GETARG_A(nArray[j]);
                    LuaString luaString = this.prototype.getlocalname(n4 + 1, j + 1);
                    if (luaString == null) break;
                    string = luaString.tojstring();
                }
            }
            String string2 = string = string != null ? ProtoInfo.toJavaClassPart(string) : String.valueOf(n2);
            if (hashtable.containsKey(string)) {
                String string3 = string;
                int n5 = 1;
                while (hashtable.containsKey(string = string3 + '$' + n5++)) {
                }
            }
            hashtable.put(string, Boolean.TRUE);
            stringArray[n2] = string;
        }
        return stringArray;
    }

    private static String toJavaClassPart(String string) {
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(n);
        for (int j = 0; j < n; ++j) {
            stringBuffer.append(Character.isJavaIdentifierPart(string.charAt(j)) ? string.charAt(j) : (char)'_');
        }
        return stringBuffer.toString();
    }
}

