/*
 * Decompiled with CFR 0.152.
 */
package nonapi.io.github.classgraph.classpath;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import nonapi.io.github.classgraph.utils.LogNode;
import nonapi.io.github.classgraph.utils.VersionFinder;

class CallStackReader {
    private static Class<?>[] callStack;

    private CallStackReader() {
    }

    private static Class<?>[] getCallStackViaStackWalker() {
        try {
            Class<?> consumerClass = Class.forName("java.util.function.Consumer");
            final ArrayList stackFrameClasses = new ArrayList();
            Class<?> stackWalkerOptionClass = Class.forName("java.lang.StackWalker$Option");
            Object retainClassReference = Class.forName("java.lang.Enum").getMethod("valueOf", Class.class, String.class).invoke(null, stackWalkerOptionClass, "RETAIN_CLASS_REFERENCE");
            Class<?> stackWalkerClass = Class.forName("java.lang.StackWalker");
            Object stackWalkerInstance = stackWalkerClass.getMethod("getInstance", stackWalkerOptionClass).invoke(null, retainClassReference);
            final Method stackFrameGetDeclaringClassMethod = Class.forName("java.lang.StackWalker$StackFrame").getMethod("getDeclaringClass", new Class[0]);
            stackWalkerClass.getMethod("forEach", consumerClass).invoke(stackWalkerInstance, Proxy.newProxyInstance(consumerClass.getClassLoader(), new Class[]{consumerClass}, new InvocationHandler(){

                @Override
                public Object invoke(Object proxy, Method method, Object[] args2) throws Throwable {
                    Class declaringClass = (Class)stackFrameGetDeclaringClassMethod.invoke(args2[0], new Object[0]);
                    stackFrameClasses.add(declaringClass);
                    return null;
                }
            }));
            return stackFrameClasses.toArray(new Class[0]);
        }
        catch (Exception | LinkageError e) {
            return null;
        }
    }

    private static Class<?>[] getCallStackViaSecurityManager(LogNode log2) {
        try {
            return new CallerResolver().getClassContext();
        }
        catch (SecurityException e) {
            if (log2 != null) {
                log2.log("Exception while trying to obtain call stack via SecurityManager", e);
            }
            return null;
        }
    }

    static Class<?>[] getClassContext(final LogNode log2) {
        if (callStack == null) {
            if (VersionFinder.JAVA_MAJOR_VERSION == 11 && (VersionFinder.JAVA_MINOR_VERSION >= 1 || VersionFinder.JAVA_SUB_VERSION >= 4) && !VersionFinder.JAVA_IS_EA_VERSION || VersionFinder.JAVA_MAJOR_VERSION == 12 && (VersionFinder.JAVA_MINOR_VERSION >= 1 || VersionFinder.JAVA_SUB_VERSION >= 2) && !VersionFinder.JAVA_IS_EA_VERSION || VersionFinder.JAVA_MAJOR_VERSION == 13 && !VersionFinder.JAVA_IS_EA_VERSION || VersionFinder.JAVA_MAJOR_VERSION > 13) {
                callStack = AccessController.doPrivileged(new PrivilegedAction<Class<?>[]>(){

                    @Override
                    public Class<?>[] run() {
                        return CallStackReader.getCallStackViaStackWalker();
                    }
                });
            }
            if (callStack == null || callStack.length == 0) {
                callStack = AccessController.doPrivileged(new PrivilegedAction<Class<?>[]>(){

                    @Override
                    public Class<?>[] run() {
                        return CallStackReader.getCallStackViaSecurityManager(log2);
                    }
                });
            }
            if (callStack == null || callStack.length == 0) {
                StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
                if (stackTrace == null || stackTrace.length == 0) {
                    try {
                        throw new Exception();
                    }
                    catch (Exception e) {
                        stackTrace = e.getStackTrace();
                    }
                }
                ArrayList stackClassesList = new ArrayList();
                for (StackTraceElement elt : stackTrace) {
                    try {
                        stackClassesList.add(Class.forName(elt.getClassName()));
                    }
                    catch (ClassNotFoundException | LinkageError throwable) {
                        // empty catch block
                    }
                }
                callStack = !stackClassesList.isEmpty() ? stackClassesList.toArray(new Class[0]) : new Class[]{CallStackReader.class};
            }
        }
        return callStack;
    }

    private static final class CallerResolver
    extends SecurityManager {
        private CallerResolver() {
        }

        @Override
        protected Class<?>[] getClassContext() {
            return super.getClassContext();
        }
    }
}

