/*
 * Decompiled with CFR 0.152.
 */
package io.jpower.kcp.netty;

import io.jpower.kcp.netty.Kcp;
import io.jpower.kcp.netty.KcpOutput;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.io.IOException;
import java.util.List;

public class Ukcp {
    private static final InternalLogger log = InternalLoggerFactory.getInstance(Ukcp.class);
    private Kcp kcp;
    private boolean fastFlush = true;
    private boolean mergeSegmentBuf = true;
    private int tsUpdate;
    private volatile boolean active;

    public Ukcp(long conv, KcpOutput output) {
        Kcp kcp;
        this.kcp = kcp = new Kcp(conv, output);
        this.active = true;
    }

    public void receive(ByteBuf buf) throws IOException {
        int ret = this.kcp.recv(buf);
        switch (ret) {
            case -3: {
                throw new IOException("Received Data exceeds maxCapacity of buf");
            }
        }
    }

    public void receive(List<ByteBuf> bufList) {
        this.kcp.recv(bufList);
    }

    public void handleEnet(ByteBuf data) {
        if (data == null || data.readableBytes() != 20) {
            return;
        }
        int code = data.readInt();
        data.readUnsignedInt();
        data.readUnsignedInt();
        int enet = data.readInt();
        data.readUnsignedInt();
        switch (code) {
            case 255: {
                if (this.getConv() != 0L) break;
                this.sendHandshakeRsp(enet);
                break;
            }
            case 404: {
                this.sendDisconnectPacket(this.getConv(), 1);
                this.channel().close();
            }
        }
    }

    private void sendHandshakeRsp(int enet) {
        this.kcp.generateConv();
        ByteBuf packet = Unpooled.buffer(20);
        packet.writeInt(325);
        packet.writeIntLE(this.kcp.getConv1());
        packet.writeIntLE(this.kcp.getConv2());
        packet.writeInt(enet);
        packet.writeInt(0x14514545);
        Kcp.output(packet, this.kcp);
    }

    public void sendDisconnectPacket(long conv, int code) {
        ByteBuf packet = Unpooled.buffer(20);
        packet.writeInt(404);
        packet.writeIntLE((int)(conv >> 32));
        packet.writeIntLE((int)(conv & 0xFFFFFFFFL));
        packet.writeInt(code);
        packet.writeInt(0x19419494);
        Kcp.output(packet, this.kcp);
    }

    public void input(ByteBuf data) throws IOException {
        if (data.readableBytes() == 20) {
            this.handleEnet(data);
            return;
        }
        int ret = this.kcp.input(data);
        switch (ret) {
            case -1: {
                throw new IOException("No enough bytes of head");
            }
            case -2: {
                throw new IOException("No enough bytes of data");
            }
            case -3: {
                this.sendDisconnectPacket(data.getLong(0), 5);
                throw new IOException("Mismatch cmd");
            }
            case -4: {
                this.sendDisconnectPacket(data.getLong(0), 5);
                throw new IOException("Conv inconsistency");
            }
        }
    }

    public void send(ByteBuf buf) throws IOException {
        int ret = this.kcp.send(buf);
        switch (ret) {
            case -2: {
                throw new IOException("Too many fragments");
            }
        }
    }

    public int peekSize() {
        return this.kcp.peekSize();
    }

    public boolean canRecv() {
        return this.kcp.canRecv();
    }

    public boolean canSend(boolean curCanSend) {
        int max2 = this.kcp.getSndWnd() * 2;
        int waitSnd = this.kcp.waitSnd();
        if (curCanSend) {
            return waitSnd < max2;
        }
        int threshold = Math.max(1, max2 / 2);
        return waitSnd < threshold;
    }

    public int update(int current) {
        this.kcp.update(current);
        int nextTsUp = this.check(current);
        this.setTsUpdate(nextTsUp);
        return nextTsUp;
    }

    public int check(int current) {
        return this.kcp.check(current);
    }

    public boolean checkFlush() {
        return this.kcp.checkFlush();
    }

    public void nodelay(boolean nodelay, int interval, int resend, boolean nc) {
        this.kcp.nodelay(nodelay, interval, resend, nc);
    }

    public long getConv() {
        return this.kcp.getConv();
    }

    public void setConv(int conv) {
        this.kcp.setConv(conv);
    }

    public boolean isNodelay() {
        return this.kcp.isNodelay();
    }

    public Ukcp setNodelay(boolean nodelay) {
        this.kcp.setNodelay(nodelay);
        return this;
    }

    public int getInterval() {
        return this.kcp.getInterval();
    }

    public Ukcp setInterval(int interval) {
        this.kcp.setInterval(interval);
        return this;
    }

    public int getFastResend() {
        return this.kcp.getFastresend();
    }

    public Ukcp setFastResend(int fastResend) {
        this.kcp.setFastresend(fastResend);
        return this;
    }

    public int getFastLimit() {
        return this.kcp.getFastlimit();
    }

    public Ukcp setFastLimit(int fastLimit) {
        this.kcp.setFastlimit(fastLimit);
        return this;
    }

    public boolean isNocwnd() {
        return this.kcp.isNocwnd();
    }

    public Ukcp setNocwnd(boolean nocwnd) {
        this.kcp.setNocwnd(nocwnd);
        return this;
    }

    public int getMinRto() {
        return this.kcp.getRxMinrto();
    }

    public Ukcp setMinRto(int minRto) {
        this.kcp.setRxMinrto(minRto);
        return this;
    }

    public int getMtu() {
        return this.kcp.getMtu();
    }

    public Ukcp setMtu(int mtu) {
        this.kcp.setMtu(mtu);
        return this;
    }

    public boolean isStream() {
        return this.kcp.isStream();
    }

    public Ukcp setStream(boolean stream) {
        this.kcp.setStream(stream);
        return this;
    }

    public int getDeadLink() {
        return this.kcp.getDeadLink();
    }

    public Ukcp setDeadLink(int deadLink) {
        this.kcp.setDeadLink(deadLink);
        return this;
    }

    public Ukcp setByteBufAllocator(ByteBufAllocator allocator) {
        this.kcp.setByteBufAllocator(allocator);
        return this;
    }

    public boolean isAutoSetConv() {
        return this.kcp.isAutoSetConv();
    }

    public Ukcp setAutoSetConv(boolean autoSetConv) {
        this.kcp.setAutoSetConv(autoSetConv);
        return this;
    }

    public Ukcp wndSize(int sndWnd, int rcvWnd) {
        this.kcp.wndsize(sndWnd, rcvWnd);
        return this;
    }

    public int waitSnd() {
        return this.kcp.waitSnd();
    }

    public int getRcvWnd() {
        return this.kcp.getRcvWnd();
    }

    public Ukcp setRcvWnd(int rcvWnd) {
        this.kcp.setRcvWnd(rcvWnd);
        return this;
    }

    public int getSndWnd() {
        return this.kcp.getSndWnd();
    }

    public Ukcp setSndWnd(int sndWnd) {
        this.kcp.setSndWnd(sndWnd);
        return this;
    }

    public boolean isFastFlush() {
        return this.fastFlush;
    }

    public Ukcp setFastFlush(boolean fastFlush) {
        this.fastFlush = fastFlush;
        return this;
    }

    public boolean isMergeSegmentBuf() {
        return this.mergeSegmentBuf;
    }

    public Ukcp setMergeSegmentBuf(boolean mergeSegmentBuf) {
        this.mergeSegmentBuf = mergeSegmentBuf;
        return this;
    }

    public int getTsUpdate() {
        return this.tsUpdate;
    }

    public Ukcp setTsUpdate(int tsUpdate) {
        this.tsUpdate = tsUpdate;
        return this;
    }

    public int getState() {
        return this.kcp.getState();
    }

    public boolean isActive() {
        return this.active;
    }

    void setClosed(boolean closeKcp) {
        this.active = false;
        if (closeKcp) {
            this.setKcpClosed();
        }
    }

    void setKcpClosed() {
        this.kcp.setState(-1);
        this.kcp.release();
    }

    public <T extends Channel> T channel() {
        return (T)((Channel)this.kcp.getUser());
    }

    public Ukcp channel(Channel channel) {
        this.kcp.setUser(channel);
        return this;
    }

    public String toString() {
        return "Ukcp(getConv=" + this.kcp.getConv() + ", state=" + this.kcp.getState() + ", active=" + this.active + ')';
    }
}

