/*
 * Decompiled with CFR 0.152.
 */
package io.jpower.kcp.netty;

import io.jpower.kcp.netty.Consts;
import io.jpower.kcp.netty.Ukcp;
import io.jpower.kcp.netty.UkcpChannelConfig;
import io.jpower.kcp.netty.UkcpChannelOption;
import io.jpower.kcp.netty.UkcpServerChildChannel;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.ChannelOption;
import io.netty.channel.DefaultChannelConfig;
import io.netty.channel.FixedRecvByteBufAllocator;
import io.netty.channel.MessageSizeEstimator;
import io.netty.channel.RecvByteBufAllocator;
import io.netty.channel.WriteBufferWaterMark;
import java.util.Map;
import java.util.Objects;

public class DefaultUkcpServerChildChannelConfig
extends DefaultChannelConfig
implements UkcpChannelConfig {
    private final Ukcp ukcp;

    public DefaultUkcpServerChildChannelConfig(UkcpServerChildChannel channel, Ukcp ukcp) {
        super(channel, new FixedRecvByteBufAllocator(Consts.FIXED_RECV_BYTEBUF_ALLOCATE_SIZE));
        this.ukcp = Objects.requireNonNull(ukcp, "ukcp");
    }

    @Override
    public Map<ChannelOption<?>, Object> getOptions() {
        return this.getOptions(super.getOptions(), UkcpChannelOption.UKCP_NODELAY, UkcpChannelOption.UKCP_INTERVAL, UkcpChannelOption.UKCP_FAST_RESEND, UkcpChannelOption.UKCP_FAST_LIMIT, UkcpChannelOption.UKCP_NOCWND, UkcpChannelOption.UKCP_MIN_RTO, UkcpChannelOption.UKCP_MTU, UkcpChannelOption.UKCP_RCV_WND, UkcpChannelOption.UKCP_SND_WND, UkcpChannelOption.UKCP_STREAM, UkcpChannelOption.UKCP_DEAD_LINK, UkcpChannelOption.UKCP_AUTO_SET_CONV, UkcpChannelOption.UKCP_FAST_FLUSH, UkcpChannelOption.UKCP_MERGE_SEGMENT_BUF);
    }

    @Override
    public <T> T getOption(ChannelOption<T> option) {
        if (option == UkcpChannelOption.UKCP_NODELAY) {
            return (T)Boolean.valueOf(this.isNodelay());
        }
        if (option == UkcpChannelOption.UKCP_INTERVAL) {
            return (T)Integer.valueOf(this.getInterval());
        }
        if (option == UkcpChannelOption.UKCP_FAST_RESEND) {
            return (T)Integer.valueOf(this.getFastResend());
        }
        if (option == UkcpChannelOption.UKCP_FAST_LIMIT) {
            return (T)Integer.valueOf(this.getFastLimit());
        }
        if (option == UkcpChannelOption.UKCP_NOCWND) {
            return (T)Boolean.valueOf(this.isNocwnd());
        }
        if (option == UkcpChannelOption.UKCP_MIN_RTO) {
            return (T)Integer.valueOf(this.getMinRto());
        }
        if (option == UkcpChannelOption.UKCP_MTU) {
            return (T)Integer.valueOf(this.getMtu());
        }
        if (option == UkcpChannelOption.UKCP_RCV_WND) {
            return (T)Integer.valueOf(this.getRcvWnd());
        }
        if (option == UkcpChannelOption.UKCP_SND_WND) {
            return (T)Integer.valueOf(this.getSndWnd());
        }
        if (option == UkcpChannelOption.UKCP_STREAM) {
            return (T)Boolean.valueOf(this.isStream());
        }
        if (option == UkcpChannelOption.UKCP_DEAD_LINK) {
            return (T)Integer.valueOf(this.getDeadLink());
        }
        if (option == UkcpChannelOption.UKCP_AUTO_SET_CONV) {
            return (T)Boolean.valueOf(this.isAutoSetConv());
        }
        if (option == UkcpChannelOption.UKCP_FAST_FLUSH) {
            return (T)Boolean.valueOf(this.isFastFlush());
        }
        if (option == UkcpChannelOption.UKCP_MERGE_SEGMENT_BUF) {
            return (T)Boolean.valueOf(this.isMergeSegmentBuf());
        }
        return super.getOption(option);
    }

    @Override
    public <T> boolean setOption(ChannelOption<T> option, T value) {
        this.validate(option, value);
        if (option == UkcpChannelOption.UKCP_NODELAY) {
            this.setNodelay((Boolean)value);
        } else if (option == UkcpChannelOption.UKCP_INTERVAL) {
            this.setInterval((Integer)value);
        } else if (option == UkcpChannelOption.UKCP_FAST_RESEND) {
            this.setFastResend((Integer)value);
        } else if (option == UkcpChannelOption.UKCP_FAST_LIMIT) {
            this.setFastLimit((Integer)value);
        } else if (option == UkcpChannelOption.UKCP_NOCWND) {
            this.setNocwnd((Boolean)value);
        } else if (option == UkcpChannelOption.UKCP_MIN_RTO) {
            this.setMinRto((Integer)value);
        } else if (option == UkcpChannelOption.UKCP_MTU) {
            this.setMtu((Integer)value);
        } else if (option == UkcpChannelOption.UKCP_RCV_WND) {
            this.setRcvWnd((Integer)value);
        } else if (option == UkcpChannelOption.UKCP_SND_WND) {
            this.setSndWnd((Integer)value);
        } else if (option == UkcpChannelOption.UKCP_STREAM) {
            this.setStream((Boolean)value);
        } else if (option == UkcpChannelOption.UKCP_DEAD_LINK) {
            this.setDeadLink((Integer)value);
        } else if (option == UkcpChannelOption.UKCP_AUTO_SET_CONV) {
            this.setAutoSetConv((Boolean)value);
        } else if (option == UkcpChannelOption.UKCP_FAST_FLUSH) {
            this.setFastFlush((Boolean)value);
        } else if (option == UkcpChannelOption.UKCP_MERGE_SEGMENT_BUF) {
            this.setMergeSegmentBuf((Boolean)value);
        } else {
            return super.setOption(option, value);
        }
        return true;
    }

    @Override
    public boolean isNodelay() {
        return this.ukcp.isNodelay();
    }

    @Override
    public UkcpChannelConfig setNodelay(boolean nodelay) {
        this.ukcp.setNodelay(nodelay);
        return this;
    }

    @Override
    public int getInterval() {
        return this.ukcp.getInterval();
    }

    @Override
    public UkcpChannelConfig setInterval(int interval) {
        this.ukcp.setInterval(interval);
        return this;
    }

    @Override
    public int getFastResend() {
        return this.ukcp.getFastResend();
    }

    @Override
    public UkcpChannelConfig setFastResend(int fastResend) {
        this.ukcp.setFastResend(fastResend);
        return this;
    }

    @Override
    public int getFastLimit() {
        return this.ukcp.getFastLimit();
    }

    @Override
    public UkcpChannelConfig setFastLimit(int fastLimit) {
        this.ukcp.setFastLimit(fastLimit);
        return this;
    }

    @Override
    public boolean isNocwnd() {
        return this.ukcp.isNocwnd();
    }

    @Override
    public UkcpChannelConfig setNocwnd(boolean nocwnd) {
        this.ukcp.setNocwnd(nocwnd);
        return this;
    }

    @Override
    public int getMinRto() {
        return this.ukcp.getMinRto();
    }

    @Override
    public UkcpChannelConfig setMinRto(int minRto) {
        this.ukcp.setMinRto(minRto);
        return this;
    }

    @Override
    public int getMtu() {
        return this.ukcp.getMtu();
    }

    @Override
    public UkcpChannelConfig setMtu(int mtu) {
        this.ukcp.setMtu(mtu);
        return this;
    }

    @Override
    public int getRcvWnd() {
        return this.ukcp.getRcvWnd();
    }

    @Override
    public UkcpChannelConfig setRcvWnd(int rcvWnd) {
        this.ukcp.setRcvWnd(rcvWnd);
        return this;
    }

    @Override
    public int getSndWnd() {
        return this.ukcp.getSndWnd();
    }

    @Override
    public UkcpChannelConfig setSndWnd(int sndWnd) {
        this.ukcp.setSndWnd(sndWnd);
        return this;
    }

    @Override
    public boolean isStream() {
        return this.ukcp.isStream();
    }

    @Override
    public UkcpChannelConfig setStream(boolean stream) {
        this.ukcp.setStream(stream);
        return this;
    }

    @Override
    public int getDeadLink() {
        return this.ukcp.getDeadLink();
    }

    @Override
    public UkcpChannelConfig setDeadLink(int deadLink) {
        this.ukcp.setDeadLink(deadLink);
        return this;
    }

    @Override
    public boolean isAutoSetConv() {
        return this.ukcp.isAutoSetConv();
    }

    @Override
    public UkcpChannelConfig setAutoSetConv(boolean autoSetConv) {
        this.ukcp.setAutoSetConv(autoSetConv);
        return this;
    }

    @Override
    public boolean isFastFlush() {
        return this.ukcp.isFastFlush();
    }

    @Override
    public UkcpChannelConfig setFastFlush(boolean fastFlush) {
        this.ukcp.setFastFlush(fastFlush);
        return this;
    }

    @Override
    public boolean isMergeSegmentBuf() {
        return this.ukcp.isMergeSegmentBuf();
    }

    @Override
    public UkcpChannelConfig setMergeSegmentBuf(boolean mergeSegmentBuf) {
        this.ukcp.setMergeSegmentBuf(mergeSegmentBuf);
        return this;
    }

    @Override
    public UkcpChannelConfig setAllocator(ByteBufAllocator allocator) {
        super.setAllocator(allocator);
        this.ukcp.setByteBufAllocator(allocator);
        return this;
    }

    @Override
    public UkcpChannelConfig setWriteSpinCount(int writeSpinCount) {
        super.setWriteSpinCount(writeSpinCount);
        return this;
    }

    @Override
    public UkcpChannelConfig setConnectTimeoutMillis(int connectTimeoutMillis) {
        super.setConnectTimeoutMillis(connectTimeoutMillis);
        return this;
    }

    @Override
    @Deprecated
    public UkcpChannelConfig setMaxMessagesPerRead(int maxMessagesPerRead) {
        super.setMaxMessagesPerRead(maxMessagesPerRead);
        return this;
    }

    @Override
    public UkcpChannelConfig setRecvByteBufAllocator(RecvByteBufAllocator allocator) {
        super.setRecvByteBufAllocator(allocator);
        return this;
    }

    @Override
    public UkcpChannelConfig setAutoRead(boolean autoRead) {
        super.setAutoRead(autoRead);
        return this;
    }

    @Override
    public UkcpChannelConfig setAutoClose(boolean autoClose) {
        super.setAutoClose(autoClose);
        return this;
    }

    @Override
    public UkcpChannelConfig setWriteBufferHighWaterMark(int writeBufferHighWaterMark) {
        super.setWriteBufferHighWaterMark(writeBufferHighWaterMark);
        return this;
    }

    @Override
    public UkcpChannelConfig setWriteBufferLowWaterMark(int writeBufferLowWaterMark) {
        super.setWriteBufferLowWaterMark(writeBufferLowWaterMark);
        return this;
    }

    @Override
    public UkcpChannelConfig setWriteBufferWaterMark(WriteBufferWaterMark writeBufferWaterMark) {
        super.setWriteBufferWaterMark(writeBufferWaterMark);
        return this;
    }

    @Override
    public UkcpChannelConfig setMessageSizeEstimator(MessageSizeEstimator estimator) {
        super.setMessageSizeEstimator(estimator);
        return this;
    }
}

