/*
 * Decompiled with CFR 0.152.
 */
package io.javalin.core;

import io.javalin.Javalin;
import io.javalin.core.JettyUtil;
import io.javalin.core.compression.Brotli;
import io.javalin.core.compression.CompressionStrategy;
import io.javalin.core.compression.Gzip;
import io.javalin.core.plugin.Plugin;
import io.javalin.core.plugin.PluginAlreadyRegisteredException;
import io.javalin.core.plugin.PluginInitLifecycleViolationException;
import io.javalin.core.plugin.PluginLifecycleInit;
import io.javalin.core.plugin.PluginNotFoundException;
import io.javalin.core.security.AccessManager;
import io.javalin.core.security.SecurityUtil;
import io.javalin.core.util.CorsPlugin;
import io.javalin.core.util.LogUtil;
import io.javalin.http.Handler;
import io.javalin.http.RequestLogger;
import io.javalin.http.SinglePageHandler;
import io.javalin.http.staticfiles.JettyResourceHandler;
import io.javalin.http.staticfiles.Location;
import io.javalin.http.staticfiles.ResourceHandler;
import io.javalin.http.staticfiles.StaticFileConfig;
import io.javalin.websocket.WsHandler;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.session.SessionHandler;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.websocket.servlet.WebSocketServletFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavalinConfig {
    public static Consumer<JavalinConfig> noopConfig = JavalinConfig2 -> {};
    @Deprecated
    public boolean dynamicGzip = true;
    public boolean autogenerateEtags = false;
    public boolean prefer405over404 = false;
    public boolean enforceSsl = false;
    public boolean precompressStaticFiles = false;
    public ContextHandler.AliasCheck aliasCheckForStaticFiles = null;
    public boolean showJavalinBanner = true;
    public boolean logIfServerNotStarted = true;
    public boolean ignoreTrailingSlashes = true;
    @NotNull
    public String defaultContentType = "text/plain";
    @NotNull
    public String contextPath = "/";
    @Deprecated
    @NotNull
    public Long requestCacheSize = 4096L;
    public Long maxRequestSize;
    @NotNull
    public Long asyncRequestTimeout = 0L;
    @NotNull
    public Inner inner = new Inner();

    public JavalinConfig registerPlugin(@NotNull Plugin plugin) {
        if (this.inner.plugins.containsKey(plugin.getClass())) {
            throw new PluginAlreadyRegisteredException(plugin.getClass());
        }
        this.inner.plugins.put(plugin.getClass(), plugin);
        return this;
    }

    public <T extends Plugin> T getPlugin(@NotNull Class<T> pluginClass) {
        Plugin result = this.inner.plugins.get(pluginClass);
        if (result == null) {
            throw new PluginNotFoundException(pluginClass);
        }
        return (T)result;
    }

    public JavalinConfig enableDevLogging() {
        this.requestLogger(LogUtil::requestDevLogger);
        this.wsLogger(LogUtil::wsDevLogger);
        return this;
    }

    public JavalinConfig enableWebjars() {
        return this.addStaticFiles("/webjars", Location.CLASSPATH);
    }

    public JavalinConfig addStaticFiles(@NotNull String classpathPath) {
        return this.addStaticFiles(classpathPath, Location.CLASSPATH);
    }

    public JavalinConfig addStaticFiles(@NotNull String path, @NotNull Location location) {
        return this.addStaticFiles("/", path, location);
    }

    public JavalinConfig addStaticFiles(@NotNull String urlPathPrefix, @NotNull String path, @NotNull Location location) {
        JettyUtil.disableJettyLogger();
        if (this.inner.resourceHandler == null) {
            this.inner.resourceHandler = new JettyResourceHandler(this.precompressStaticFiles, this.aliasCheckForStaticFiles);
        }
        this.inner.resourceHandler.addStaticFileConfig(new StaticFileConfig(urlPathPrefix, path, location));
        return this;
    }

    public JavalinConfig addSinglePageRoot(@NotNull String path, @NotNull String filePath) {
        this.addSinglePageRoot(path, filePath, Location.CLASSPATH);
        return this;
    }

    public JavalinConfig addSinglePageRoot(@NotNull String path, @NotNull String filePath, @NotNull Location location) {
        this.inner.singlePageHandler.add(path, filePath, location);
        return this;
    }

    public JavalinConfig addSinglePageHandler(@NotNull String path, @NotNull Handler customHandler) {
        this.inner.singlePageHandler.add(path, customHandler);
        return this;
    }

    public JavalinConfig enableCorsForAllOrigins() {
        this.registerPlugin(CorsPlugin.forAllOrigins());
        return this;
    }

    public JavalinConfig enableCorsForOrigin(String ... origins) {
        this.registerPlugin(CorsPlugin.forOrigins(origins));
        return this;
    }

    public JavalinConfig accessManager(@NotNull AccessManager accessManager) {
        this.inner.accessManager = accessManager;
        return this;
    }

    public JavalinConfig requestLogger(@NotNull RequestLogger requestLogger) {
        this.inner.requestLogger = requestLogger;
        return this;
    }

    public JavalinConfig sessionHandler(@NotNull Supplier<SessionHandler> sessionHandlerSupplier) {
        JettyUtil.disableJettyLogger();
        this.inner.sessionHandler = sessionHandlerSupplier.get();
        return this;
    }

    public JavalinConfig wsFactoryConfig(@NotNull Consumer<WebSocketServletFactory> wsFactoryConfig) {
        this.inner.wsFactoryConfig = wsFactoryConfig;
        return this;
    }

    public JavalinConfig wsLogger(@NotNull Consumer<WsHandler> ws) {
        WsHandler logger = new WsHandler();
        ws.accept(logger);
        this.inner.wsLogger = logger;
        return this;
    }

    public JavalinConfig server(Supplier<Server> server) {
        this.inner.server = server.get();
        return this;
    }

    public JavalinConfig configureServletContextHandler(Consumer<ServletContextHandler> consumer) {
        this.inner.servletContextHandlerConsumer = consumer;
        return this;
    }

    public JavalinConfig compressionStrategy(Brotli brotli, Gzip gzip) {
        this.inner.compressionStrategy = new CompressionStrategy(brotli, gzip);
        return this;
    }

    public JavalinConfig compressionStrategy(CompressionStrategy compressionStrategy) {
        this.inner.compressionStrategy = compressionStrategy;
        return this;
    }

    public static void applyUserConfig(Javalin app, JavalinConfig config, Consumer<JavalinConfig> userConfig) {
        userConfig.accept(config);
        if (!config.dynamicGzip) {
            config.inner.compressionStrategy = CompressionStrategy.NONE;
        }
        AtomicBoolean anyHandlerAdded = new AtomicBoolean(false);
        app.events(listener -> {
            listener.handlerAdded(x -> anyHandlerAdded.set(true));
            listener.wsHandlerAdded(x -> anyHandlerAdded.set(true));
        });
        config.getPluginsExtending(PluginLifecycleInit.class).forEach(plugin -> {
            plugin.init(app);
            if (anyHandlerAdded.get()) {
                throw new PluginInitLifecycleViolationException(((Plugin)((Object)plugin)).getClass());
            }
        });
        config.inner.plugins.values().forEach(plugin -> plugin.apply(app));
        if (config.enforceSsl) {
            app.before(SecurityUtil::sslRedirect);
        }
    }

    private <T> Stream<? extends T> getPluginsExtending(Class<T> clazz) {
        return this.inner.plugins.values().stream().filter(clazz::isInstance).map(plugin -> plugin);
    }

    public class Inner {
        @NotNull
        public Map<Class<? extends Plugin>, Plugin> plugins = new HashMap<Class<? extends Plugin>, Plugin>();
        @NotNull
        public Map<Class<?>, Object> appAttributes = new HashMap();
        @Nullable
        public RequestLogger requestLogger = null;
        @Nullable
        public ResourceHandler resourceHandler = null;
        @NotNull
        public AccessManager accessManager = SecurityUtil::noopAccessManager;
        @NotNull
        public SinglePageHandler singlePageHandler = new SinglePageHandler();
        @Nullable
        public SessionHandler sessionHandler = null;
        @Nullable
        public Consumer<WebSocketServletFactory> wsFactoryConfig = null;
        @Nullable
        public WsHandler wsLogger = null;
        @Nullable
        public Server server = null;
        @Nullable
        public Consumer<ServletContextHandler> servletContextHandlerConsumer = null;
        @NotNull
        public CompressionStrategy compressionStrategy = CompressionStrategy.GZIP;
    }
}

