/*
 * Decompiled with CFR 0.152.
 */
package emu.grasscutter.utils;

import ch.qos.logback.classic.Logger;
import emu.grasscutter.Grasscutter;
import emu.grasscutter.utils.ConfigContainer;
import emu.grasscutter.utils.Language;
import emu.grasscutter.utils.Position;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.time.DayOfWeek;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.temporal.TemporalAdjusters;
import java.util.Base64;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nullable;

public final class Utils {
    public static final Random random = new Random();
    private static final char[] HEX_ARRAY = "0123456789abcdef".toCharArray();

    public static int randomRange(int min2, int max2) {
        return random.nextInt(max2 - min2 + 1) + min2;
    }

    public static float randomFloatRange(float min2, float max2) {
        return random.nextFloat() * (max2 - min2) + min2;
    }

    public static double getDist(Position pos1, Position pos2) {
        double xs = pos1.getX() - pos2.getX();
        xs *= xs;
        double ys = pos1.getY() - pos2.getY();
        ys *= ys;
        double zs = pos1.getZ() - pos2.getZ();
        zs *= zs;
        return Math.sqrt(xs + zs + ys);
    }

    public static int getCurrentSeconds() {
        return (int)((double)System.currentTimeMillis() / 1000.0);
    }

    public static String lowerCaseFirstChar(String s2) {
        StringBuilder sb = new StringBuilder(s2);
        sb.setCharAt(0, Character.toLowerCase(sb.charAt(0)));
        return sb.toString();
    }

    public static String toString(InputStream inputStream) throws IOException {
        BufferedInputStream bis = new BufferedInputStream(inputStream);
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        int result = bis.read();
        while (result != -1) {
            buf.write((byte)result);
            result = bis.read();
        }
        return buf.toString();
    }

    public static void logByteArray(byte[] array) {
        ByteBuf b = Unpooled.wrappedBuffer(array);
        Grasscutter.getLogger().info("\n" + ByteBufUtil.prettyHexDump(b));
        b.release();
    }

    public static String bytesToHex(byte[] bytes) {
        if (bytes == null) {
            return "";
        }
        char[] hexChars = new char[bytes.length * 2];
        for (int j = 0; j < bytes.length; ++j) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = HEX_ARRAY[v >>> 4];
            hexChars[j * 2 + 1] = HEX_ARRAY[v & 0xF];
        }
        return new String(hexChars);
    }

    public static String bytesToHex(ByteBuf buf) {
        return Utils.bytesToHex(Utils.byteBufToArray(buf));
    }

    public static byte[] byteBufToArray(ByteBuf buf) {
        byte[] bytes = new byte[buf.capacity()];
        buf.getBytes(0, bytes);
        return bytes;
    }

    public static int abilityHash(String str) {
        int v7 = 0;
        int v8 = 0;
        while (v8 < str.length()) {
            v7 = str.charAt(v8++) + 131 * v7;
        }
        return v7;
    }

    public static String toFilePath(String path) {
        return path.replace("/", File.separator);
    }

    public static boolean fileExists(String path) {
        return new File(path).exists();
    }

    public static boolean createFolder(String path) {
        return new File(path).mkdirs();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean copyFromResources(String resource, String destination) {
        try (InputStream stream = Grasscutter.class.getResourceAsStream(resource);){
            if (stream == null) {
                Grasscutter.getLogger().warn("Could not find resource: " + resource);
                boolean bl2 = false;
                return bl2;
            }
            Files.copy(stream, new File(destination).toPath(), StandardCopyOption.REPLACE_EXISTING);
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            Grasscutter.getLogger().warn("Unable to copy resource " + resource + " to " + destination, e);
            return false;
        }
    }

    public static <T> T requireNonNullElseGet(T nonNull, T fallback) {
        return nonNull != null ? nonNull : fallback;
    }

    public static void logObject(Object object) {
        String asJson = Grasscutter.getGsonFactory().toJson(object);
        Grasscutter.getLogger().info(asJson);
    }

    public static void startupCheck() {
        ConfigContainer config = Grasscutter.getConfig();
        Logger logger = Grasscutter.getLogger();
        boolean exit = false;
        String resourcesFolder = config.folderStructure.resources;
        String dataFolder = config.folderStructure.data;
        if (!Utils.fileExists(resourcesFolder)) {
            logger.info(Language.translate("messages.status.create_resources", new Object[0]));
            logger.info(Language.translate("messages.status.resources_error", new Object[0]));
            Utils.createFolder(resourcesFolder);
            exit = true;
        }
        if (!Utils.fileExists(resourcesFolder + "BinOutput") || !Utils.fileExists(resourcesFolder + "ExcelBinOutput")) {
            logger.info(Language.translate("messages.status.resources_error", new Object[0]));
            exit = true;
        }
        if (!Utils.fileExists(dataFolder)) {
            Utils.createFolder(dataFolder);
        }
        if (exit) {
            System.exit(1);
        }
    }

    public static int getNextTimestampOfThisHour(int hour, String timeZone, int param) {
        ZonedDateTime zonedDateTime = ZonedDateTime.now(ZoneId.of(timeZone));
        for (int i2 = 0; i2 < param; ++i2) {
            zonedDateTime = zonedDateTime.getHour() < hour ? zonedDateTime.withHour(hour).withMinute(0).withSecond(0) : zonedDateTime.plusDays(1L).withHour(hour).withMinute(0).withSecond(0);
        }
        return (int)zonedDateTime.toInstant().atZone(ZoneOffset.UTC).toEpochSecond();
    }

    public static int getNextTimestampOfThisHourInNextWeek(int hour, String timeZone, int param) {
        ZonedDateTime zonedDateTime = ZonedDateTime.now(ZoneId.of(timeZone));
        for (int i2 = 0; i2 < param; ++i2) {
            zonedDateTime = zonedDateTime.getDayOfWeek() == DayOfWeek.MONDAY && zonedDateTime.getHour() < hour ? ZonedDateTime.now(ZoneId.of(timeZone)).withHour(hour).withMinute(0).withSecond(0) : zonedDateTime.with(TemporalAdjusters.next(DayOfWeek.MONDAY)).withHour(hour).withMinute(0).withSecond(0);
        }
        return (int)zonedDateTime.toInstant().atZone(ZoneOffset.UTC).toEpochSecond();
    }

    public static int getNextTimestampOfThisHourInNextMonth(int hour, String timeZone, int param) {
        ZonedDateTime zonedDateTime = ZonedDateTime.now(ZoneId.of(timeZone));
        for (int i2 = 0; i2 < param; ++i2) {
            zonedDateTime = zonedDateTime.getDayOfMonth() == 1 && zonedDateTime.getHour() < hour ? ZonedDateTime.now(ZoneId.of(timeZone)).withHour(hour).withMinute(0).withSecond(0) : zonedDateTime.with(TemporalAdjusters.firstDayOfNextMonth()).withHour(hour).withMinute(0).withSecond(0);
        }
        return (int)zonedDateTime.toInstant().atZone(ZoneOffset.UTC).toEpochSecond();
    }

    public static String readFromInputStream(@Nullable InputStream stream) {
        if (stream == null) {
            return "empty";
        }
        StringBuilder stringBuilder = new StringBuilder();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(stream, StandardCharsets.UTF_8));){
            String line;
            while ((line = reader.readLine()) != null) {
                stringBuilder.append(line);
            }
            stream.close();
        }
        catch (IOException e) {
            Grasscutter.getLogger().warn("Failed to read from input stream.");
        }
        catch (NullPointerException ignored) {
            return "empty";
        }
        return stringBuilder.toString();
    }

    public static Map<String, Object> switchPropertiesUpperLowerCase(Map<String, Object> objMap, Class<?> cls) {
        HashMap<String, Object> map = new HashMap<String, Object>(objMap.size());
        for (String key : objMap.keySet()) {
            try {
                String after;
                String s1;
                char c = key.charAt(0);
                if (c >= 'a' && c <= 'z') {
                    try {
                        cls.getDeclaredField(key);
                        map.put(key, objMap.get(key));
                    }
                    catch (NoSuchFieldException e) {
                        s1 = String.valueOf(c).toUpperCase();
                        after = key.length() > 1 ? s1 + key.substring(1) : s1;
                        cls.getDeclaredField(after);
                        map.put(after, objMap.get(key));
                    }
                    continue;
                }
                if (c < 'A' || c > 'Z') continue;
                try {
                    cls.getDeclaredField(key);
                    map.put(key, objMap.get(key));
                }
                catch (NoSuchFieldException e) {
                    s1 = String.valueOf(c).toLowerCase();
                    after = key.length() > 1 ? s1 + key.substring(1) : s1;
                    cls.getDeclaredField(after);
                    map.put(after, objMap.get(key));
                }
            }
            catch (NoSuchFieldException e) {
                map.put(key, objMap.get(key));
            }
        }
        return map;
    }

    public static int lerp(int x, int[][] xyArray) {
        try {
            if (x <= xyArray[0][0]) {
                return xyArray[0][1];
            }
            if (x >= xyArray[xyArray.length - 1][0]) {
                return xyArray[xyArray.length - 1][1];
            }
            for (int i2 = 0; i2 < xyArray.length - 1; ++i2) {
                if (x == xyArray[i2 + 1][0]) {
                    return xyArray[i2 + 1][1];
                }
                if (x >= xyArray[i2 + 1][0]) continue;
                int position = x - xyArray[i2][0];
                int fullDist = xyArray[i2 + 1][0] - xyArray[i2][0];
                int prevValue = xyArray[i2][1];
                int fullDelta = xyArray[i2 + 1][1] - prevValue;
                return prevValue + position * fullDelta / fullDist;
            }
        }
        catch (IndexOutOfBoundsException e) {
            Grasscutter.getLogger().error("Malformed lerp point array. Must be of form [[x0, y0], ..., [xN, yN]].");
        }
        return 0;
    }

    public static boolean intInArray(int key, int[] array) {
        for (int i2 : array) {
            if (i2 != key) continue;
            return true;
        }
        return false;
    }

    public static int[] setSubtract(int[] minuend, int[] subtrahend) {
        IntArrayList temp = new IntArrayList();
        for (int i2 : minuend) {
            if (Utils.intInArray(i2, subtrahend)) continue;
            temp.add(i2);
        }
        return temp.toIntArray();
    }

    public static String getLanguageCode(Locale locale) {
        return String.format("%s-%s", locale.getLanguage(), locale.getCountry());
    }

    public static String base64Encode(byte[] toEncode) {
        return Base64.getEncoder().encodeToString(toEncode);
    }

    public static byte[] base64Decode(String toDecode) {
        return Base64.getDecoder().decode(toDecode);
    }

    public static <T> T jsonDecode(String jsonData, Class<T> classType) {
        try {
            return Grasscutter.getGsonFactory().fromJson(jsonData, classType);
        }
        catch (Exception ignored) {
            return null;
        }
    }
}

