/*
 * Decompiled with CFR 0.152.
 */
package emu.grasscutter.utils;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import emu.grasscutter.Configuration;
import emu.grasscutter.Grasscutter;
import emu.grasscutter.game.player.Player;
import emu.grasscutter.utils.Utils;
import java.io.InputStream;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class Language {
    private static final Map<String, Language> cachedLanguages = new ConcurrentHashMap<String, Language>();
    private final JsonObject languageData;
    private final String languageCode;
    private final Map<String, String> cachedTranslations = new ConcurrentHashMap<String, String>();

    public static Language getLanguage(String langCode) {
        Language languageInst;
        if (cachedLanguages.containsKey(langCode)) {
            return cachedLanguages.get(langCode);
        }
        String fallbackLanguageCode = Utils.getLanguageCode(Configuration.FALLBACK_LANGUAGE);
        LanguageStreamDescription description = Language.getLanguageFileDescription(langCode, fallbackLanguageCode);
        String actualLanguageCode = description.getLanguageCode();
        if (description.getLanguageFile() != null) {
            languageInst = new Language(description);
            cachedLanguages.put(actualLanguageCode, languageInst);
        } else {
            languageInst = cachedLanguages.get(actualLanguageCode);
            cachedLanguages.put(langCode, languageInst);
        }
        return languageInst;
    }

    public static String translate(String key, Object ... args2) {
        String translated = Grasscutter.getLanguage().get(key);
        try {
            return translated.formatted(args2);
        }
        catch (Exception exception) {
            Grasscutter.getLogger().error("Failed to format string: " + key, exception);
            return translated;
        }
    }

    public static String translate(Player player, String key, Object ... args2) {
        if (player == null) {
            return Language.translate(key, args2);
        }
        String langCode = Utils.getLanguageCode(player.getAccount().getLocale());
        String translated = Grasscutter.getLanguage(langCode).get(key);
        try {
            return translated.formatted(args2);
        }
        catch (Exception exception) {
            Grasscutter.getLogger().error("Failed to format string: " + key, exception);
            return translated;
        }
    }

    public String getLanguageCode() {
        return this.languageCode;
    }

    private Language(LanguageStreamDescription description) {
        JsonObject languageData = null;
        this.languageCode = description.getLanguageCode();
        try {
            languageData = Grasscutter.getGsonFactory().fromJson(Utils.readFromInputStream(description.getLanguageFile()), JsonObject.class);
        }
        catch (Exception exception) {
            Grasscutter.getLogger().warn("Failed to load language file: " + description.getLanguageCode(), exception);
        }
        this.languageData = languageData;
    }

    private static LanguageStreamDescription getLanguageFileDescription(String languageCode, String fallbackLanguageCode) {
        String fileName = languageCode + ".json";
        String fallback = fallbackLanguageCode + ".json";
        String actualLanguageCode = languageCode;
        InputStream file = Grasscutter.class.getResourceAsStream("/languages/" + fileName);
        if (file == null) {
            Grasscutter.getLogger().warn("Failed to load language file: " + fileName + ", falling back to: " + fallback);
            actualLanguageCode = fallbackLanguageCode;
            if (cachedLanguages.containsKey(actualLanguageCode)) {
                return new LanguageStreamDescription(actualLanguageCode, null);
            }
            file = Grasscutter.class.getResourceAsStream("/languages/" + fallback);
        }
        if (file == null) {
            Grasscutter.getLogger().warn("Failed to load language file: " + fallback + ", falling back to: en-US.json");
            actualLanguageCode = "en-US";
            if (cachedLanguages.containsKey(actualLanguageCode)) {
                return new LanguageStreamDescription(actualLanguageCode, null);
            }
            file = Grasscutter.class.getResourceAsStream("/languages/en-US.json");
        }
        if (file == null) {
            throw new RuntimeException("Unable to load the primary, fallback, and 'en-US' language files.");
        }
        return new LanguageStreamDescription(actualLanguageCode, file);
    }

    public String get(String key) {
        String englishValue;
        String currentKey;
        if (this.cachedTranslations.containsKey(key)) {
            return this.cachedTranslations.get(key);
        }
        String[] keys2 = key.split("\\.");
        JsonObject object = this.languageData;
        int index = 0;
        String valueNotFoundPattern = "This value does not exist. Please report this to the Discord: ";
        Object result = valueNotFoundPattern + key;
        boolean isValueFound = false;
        while (index != keys2.length && object.has(currentKey = keys2[index++])) {
            JsonElement element = object.get(currentKey);
            if (element.isJsonObject()) {
                object = element.getAsJsonObject();
                continue;
            }
            isValueFound = true;
            result = element.getAsString();
            break;
        }
        if (!(isValueFound || this.languageCode.equals("en-US") || (englishValue = Grasscutter.getLanguage("en-US").get(key)).contains(valueNotFoundPattern))) {
            result = (String)result + "\nhere is english version:\n" + englishValue;
        }
        this.cachedTranslations.put(key, (String)result);
        return result;
    }

    private static class LanguageStreamDescription {
        private final String languageCode;
        private final InputStream languageFile;

        public LanguageStreamDescription(String languageCode, InputStream languageFile) {
            this.languageCode = languageCode;
            this.languageFile = languageFile;
        }

        public String getLanguageCode() {
            return this.languageCode;
        }

        public InputStream getLanguageFile() {
            return this.languageFile;
        }
    }
}

